# NSFC 中标题目写作规则（基于 2016–2023 立项题目统计）

本规则用于给 NSFC 申请书生成“更像中标题目”的标题候选，并解释每个候选标题的取舍理由。

## 快速结论（最重要的共性）

- **题目长度**：中位数约 **29** 字符，约 90% 不超过 **43** 字符（去空白计数）。建议默认控制在 **25–40** 字符区间，超过 45 字符通常需要压缩信息密度或拆掉从句。
- **“研究对象 + 关键科学问题/机制 + 可验证终点”三件套**是最稳定的结构。
- 不同学部的“题目偏好”差异显著：
  - **医学/生命**：高度偏好 **机制/调控/作用** 叙事（如医学科学部题目中约 **79%** 含“机制”）。
  - **工程材料/化学**：更常出现 **方法/制备/构建/性能**，题目更“工程化可验收”。
  - **信息/数理**：更常出现 **方法/模型/算法/预测**，题目更“问题定义清晰 + 方法路径明确”。

## 通用写作规则（跨学科）

### 信息密度规则

题目需要同时回答三件事（越靠前越重要）：
1) **研究对象/系统**：材料/器件/疾病/通路/过程/场景/任务
2) **核心动作/关系**：调控、影响、耦合、构建、优化、识别、预测、评估……
3) **科学问题或可验证终点**：机制阐明、因果链、关键判据、性能边界、可解释性、稳健性、泛化性、转化/应用场景……

### 用词与结构规则

- **动词驱动**：优先使用可验证的动词（“解析/揭示/阐明/构建/开发/验证/评估/预测/优化”），少用空泛动词（“探索/探讨/研究进展”）作为核心承载。
- **少而准的限定词**：限定词只保留“会影响评审判断”的那一个（例如“时空”“跨尺度”“多中心”“多模态”“可解释”）；避免堆叠形容词。
- **术语一致**：题目中出现的关键名词，应与摘要里的对象/假说/指标一致（避免题目说 A，摘要主线写 B）。
- **避免营销词**：除非用户给出可核验依据并明确要求保留，否则默认不使用“国际领先/填补空白/首创”等。

### “中标题目”常见模板（可直接套用）

以下模板中的括号为可替换槽位：

1) **机制主线（生医/生命最常见）**
   - （对象/通路/细胞）**通过**（关键因子/过程）**调控**（表型/过程）的机制研究
   - （因素）**对**（表型/疾病进程）的影响及机制研究
2) **方法-问题对齐（信息/工程常见）**
   - **面向**（任务/场景）的（方法/模型/系统）构建与（性能/稳健性/可解释性）研究
   - （约束/噪声/不确定性）下（任务）的（模型/算法）与理论分析
3) **工程实现（工程材料/化学常见）**
   - （材料/结构）的设计、制备及（性能/机理/应用）研究
   - （器件/体系）的构建与（关键性能指标）调控机理
4) **转化与应用（医学常见但需克制）**
   - （机制/标志物/模型）驱动的（诊断/预测/分层/干预）策略及验证
   - （技术/平台）在（疾病/场景）中的应用与评价

## 学科偏好（用于“题目风格”对齐）

以下为从本地 CSV 做的粗统计（同一题目可能同时命中多个关键词）：

- **全体题目**：含“机制”约 **45%**；含“调控”约 **21%**；含“基于”约 **16%**。
- **医学科学部**（n≈10259）：含“机制”约 **79%**；“调控”约 **34%**；“治疗”约 **10%**。
- **工程与材料科学部**（n≈5742）：“方法”约 **16%**；“性能”约 **13%**；“机制”约 **24%**。
- **信息科学部**（n≈3737）：“方法”约 **26%**；“模型”约 **6%**；“预测”约 **3%**。

> 用法：当用户给出学科/学部时，标题候选应“向该学部偏好靠拢”；当用户未给出学科时，默认生成一组“机制向 + 方法向 + 应用向”的混合候选，便于选择。

## 生成 5 个标题候选（默认策略）

默认输出 5 个中文候选标题，并给出**一句话理由**（理由要可对比，避免重复）：

1) **机制向**：突出“因果链/通路/调控关系”，适合医学/生命学部评审口味。
2) **判据向**：突出“关键指标/可验证终点/评价口径”，强调可检验性。
3) **方法向**：突出“技术路线/模型/平台/算法”，强调可实现性与创新方法。
4) **场景向**：突出“疾病亚型/应用场景/边界条件”，强调对准真实问题。
5) **整合向**：突出“跨尺度/多模态/时空动态/系统机制”，强调整体性（但要控制字数）。

筛选优先级（从高到低）：
- P0：对象清楚 + 科学问题清楚 + 可验证终点清楚
- P1：与摘要主线一致；术语统一；没有“空话形容词堆叠”
- P2：长度控制；读起来顺；避免生硬缩写堆叠

## 常见错误（需要在候选理由里主动规避）

- **对象不具体**：只写“大数据/新材料/免疫治疗”等泛对象，评审无法判断可行性与边界。
- **动词不落地**：通篇“探索/研究”但没有可验证动作（调控/构建/评估/验证等）。
- **从句过长**：一个题目塞进 3–4 个并列从句，读起来像摘要第一句。
- **题目与摘要脱节**：题目写机制，摘要主线是方法学；或题目写转化应用，摘要没有验证路径。

> 变更历史记录在项目根级 `CHANGELOG.md`。

