# 紧急医疗信息卡 - 使用示例

## 示例 1: 为旅行准备紧急信息卡

### 用户输入
```
我下周要去北京旅行，需要准备紧急医疗信息卡
```

### Claude 执行
1. 读取用户的过敏史（发现青霉素4级过敏）
2. 读取当前用药（阿司匹林、氨氯地平）
3. 读取植入物信息（心脏起搏器）
4. 生成包含关键信息的JSON和文本格式卡片
5. 生成二维码便于手机扫描

### 输出结果
```json
{
  "emergency_card": {
    "version": "1.0",
    "generated_at": "2025-12-31T12:34:56Z",
    "basic_info": {
      "name": "张三",
      "age": 35,
      "gender": "男",
      "blood_type": "A+",
      "weight": "70kg",
      "emergency_contacts": [
        {
          "name": "李四",
          "relationship": "配偶",
          "phone": "138****1234"
        }
      ]
    },
    "critical_allergies": [
      {
        "allergen": "青霉素",
        "severity": "过敏性休克（4级）",
        "reaction": "呼吸困难、喉头水肿、意识丧失",
        "diagnosed_date": "2010-05-15"
      }
    ],
    "current_medications": [
      {
        "name": "阿司匹林",
        "dosage": "100mg",
        "frequency": "每日1次",
        "instructions": "早餐后服用",
        "purpose": "心血管预防"
      },
      {
        "name": "氨氯地平",
        "dosage": "5mg",
        "frequency": "每日2次",
        "instructions": "早晚服用",
        "purpose": "降压治疗"
      }
    ],
    "medical_conditions": [
      {
        "condition": "高血压",
        "diagnosis_date": "2023-01-15",
        "status": "控制中"
      },
      {
        "condition": "2型糖尿病",
        "diagnosis_date": "2022-08-20",
        "status": "监测中"
      }
    ],
    "implants": [
      {
        "type": "心脏起搏器",
        "implant_date": "2022-06-10",
        "hospital": "XX医院",
        "notes": "定期复查，避免MRI检查"
      }
    ],
    "disclaimer": "此信息卡仅供参考，不替代专业医疗诊断",
    "data_source": "my-his个人健康信息系统"
  }
}
```

### 旅行建议
```
💡 旅行建议：
━━━━━━━━━━━━━━━━━━━━━━━━━━
1. 将二维码保存到手机相册
2. 将文本版打印一份放在钱包
3. 将JSON文件上传到云盘
4. 随身携带过敏急救卡
5. 告知同行同伴你的过敏情况

⚠️  特别注意：
━━━━━━━━━━━━━━━━━━━━━━━━━━
• 心脏起搏器：机场安检时主动告知
• 青霉素过敏：就医时必须告知医生
• 慢性病用药：携带足够药量并分开放置
```

---

## 示例 2: 为老年人准备急救卡

### 用户输入
```
我父亲75岁了，独居，需要准备一个急救卡
```

### Claude 执行
1. 读取用户父亲的档案（年龄：75岁，血型：B+）
2. 读取严重过敏史（磺胺类药物3级过敏）
3. 读取多重用药（5种慢性病药物）
4. 读取医疗状况（高血压、糖尿病、冠心病）
5. 生成大字体、清晰的文本版卡片

### 输出结果（文本格式）
```
╔═══════════════════════════════════════════════════════════╗
║                  老年急救信息卡                          ║
╠═══════════════════════════════════════════════════════════╣
║ 姓名：王五                      年龄：75岁               ║
║ 性别：男                        血型：B+                 ║
╠═══════════════════════════════════════════════════════════╣
║ 🆘 严重过敏（紧急）                                      ║
║ ─────────────────────────────────────────────────────── ║
║ • 磺胺类药物 - 严重过敏（3级）                          ║
║   反应：全身皮疹、发热                                  ║
╠═══════════════════════════════════════════════════════════╣
║ 💊 当前用药（5种）                                      ║
║ ─────────────────────────────────────────────────────── ║
║ 1. 阿司匹林 100mg - 每日1次                             ║
║ 2. 氨氯地平 5mg - 每日2次                               ║
║ 3. 二甲双胍 500mg - 每日3次                             ║
║ 4. 美托洛尔 25mg - 每日2次                              ║
║ 5. 辛伐他汀 20mg - 每晚1次                              ║
╠═══════════════════════════════════════════════════════════╣
║ 🏥 医疗状况                                              ║
║ ─────────────────────────────────────────────────────── ║
║ • 高血压（2018-03-10诊断）                              ║
║ • 2型糖尿病（2019-07-22诊断）                           ║
║ • 冠心病（2020-11-05诊断）                              ║
╠═══════════════════════════════════════════════════════════╣
║ 📞 紧急联系人（2人）                                    ║
║ ─────────────────────────────────────────────────────── ║
║ 1. 王小明（儿子）- 139****5678                          ║
║ 2. 王女士（儿媳）- 136****9012                          ║
╠═══════════════════════════════════════════════════════════╣
║ ⚠️  特别注意                                            ║
║ ─────────────────────────────────────────────────────── ║
║ • 独居老人，请先联系家属                                ║
║ • 磺胺类药物严重过敏，绝对禁止使用                      ║
║ • 有心血管疾病史，注意监测血压和心率                    ║
╚═══════════════════════════════════════════════════════════╝

⚠️  如遇紧急情况，请立即拨打120
生成时间：2025-12-31 12:34:56
```

### 老年人使用建议
```
💡 老年人使用建议：
━━━━━━━━━━━━━━━━━━━━━━━━━━
1. 将卡片放大打印，贴在冰箱上
2. 随身携带小尺寸卡片
3. 告知邻居和社区医生
4. 手机设置紧急联系人快捷拨号
5. 每季度更新一次信息
```

---

## 示例 3: 为儿童准备医疗信息卡

### 用户输入
```
我儿子8岁，学校需要医疗信息档案
```

### Claude 执行
1. 读取儿童档案（年龄：8岁，血型：O+）
2. 读取过敏史（鸡蛋、牛奶2级过敏）
3. 读取用药情况（哮喘预防用药）
4. 读取医疗状况（支气管哮喘）
5. 生成包含家长联系方式的儿童专用卡片

### 输出结果
```json
{
  "emergency_card": {
    "version": "1.0",
    "type": "pediatric",
    "generated_at": "2025-12-31T12:34:56Z",
    "basic_info": {
      "name": "王小明",
      "age": 8,
      "gender": "男",
      "blood_type": "O+",
      "weight": "25kg",
      "school": "XX小学",
      "grade": "二年级"
    },
    "allergies": [
      {
        "allergen": "鸡蛋",
        "severity": "中度过敏（2级）",
        "reaction": "皮肤瘙痒、荨麻疹",
        "diagnosed_date": "2021-03-15"
      },
      {
        "allergen": "牛奶",
        "severity": "轻度过敏（1级）",
        "reaction": "轻微腹痛",
        "diagnosed_date": "2021-06-20"
      }
    ],
    "current_medications": [
      {
        "name": "孟鲁司特钠",
        "dosage": "5mg",
        "frequency": "每晚1次",
        "purpose": "哮喘预防"
      }
    ],
    "medical_conditions": [
      {
        "condition": "支气管哮喘",
        "diagnosis_date": "2022-09-10",
        "status": "控制中",
        "triggers": ["花粉", "尘螨", "冷空气"]
      }
    ],
    "emergency_contacts": [
      {
        "name": "王先生（父亲）",
        "phone": "138****1234"
      },
      {
        "name": "李女士（母亲）",
        "phone": "139****5678"
      },
      {
        "name": "XX小学医务室",
        "phone": "010-****1234"
      }
    ],
    "school_instructions": [
      "避免食用含鸡蛋和牛奶的食品",
      "体育课如出现呼吸困难立即停止",
      "春秋季节减少户外活动",
      "随身携带哮喘急救药"
    ],
    "disclaimer": "此信息卡仅供参考，不替代专业医疗诊断"
  }
}
```

### 学校使用建议
```
💡 学校使用建议：
━━━━━━━━━━━━━━━━━━━━━━━━━━
1. 复印一份交给班主任
2. 复印一份交给校医
3. 告知体育老师过敏情况
4. 定期更新紧急联系人
5. 每学期更新一次健康信息
```

---

## 示例 4: 无过敏史、无用药的健康人

### 用户输入
```
生成紧急医疗信息卡
```

### Claude 执行
1. 读取用户档案（年龄：28岁，健康）
2. 未发现过敏史
3. 未发现当前用药
4. 未发现植入物
5. 生成简洁的基础信息卡片

### 输出结果
```
✅ 紧急医疗信息卡已生成

文件位置：data/emergency-cards/emergency-card-2025-12-31.json

包含信息：
━━━━━━━━━━━━━━━━━━━━━━━━━━
✓ 基础信息（姓名、年龄、血型）
✓ 过敏史：未记录
✓ 当前用药：无
✓ 医疗状况：无
✓ 植入物：无

💡 说明：
━━━━━━━━━━━━━━━━━━━━━━━━━━
您目前未记录严重的过敏史、用药或医疗状况。
建议：
• 定期更新健康信息
• 如有新的诊断及时记录
• 旅行前再次生成最新卡片
```

---

## 示例 5: 多种严重过敏 + 多重用药

### 用户输入
```
我有多种严重过敏，需要详细的急救卡
```

### Claude 执行
1. 读取用户过敏史（青霉素4级、磺胺3级、碘造影剂3级）
2. 读取当前用药（7种药物，存在相互作用警示）
3. 读取医疗状况（过敏性哮喘、高血压、肾功能不全）
4. 生成详细的医疗信息卡片

### 输出结果
```
╔═══════════════════════════════════════════════════════════╗
║            严重过敏患者 - 紧急医疗信息卡                  ║
╠═══════════════════════════════════════════════════════════╣
║ 姓名：赵六                      年龄：45岁               ║
║ 血型：AB+                      体重：65kg                ║
╠═══════════════════════════════════════════════════════════╣
║ 🆘🆘🆘 严重过敏（危及生命）🆘🆘🆘                      ║
╠═══════════════════════════════════════════════════════════╣
║ 1. 青霉素 - 过敏性休克（4级）🆘                          ║
║    ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ ║
║    反应：呼吸困难、喉头水肿、血压下降、意识丧失          ║
║    诊断：2010-05-15                                      ║
║    ⚠️  绝对禁止：所有青霉素类药物                       ║
║    ⚠️  交叉过敏：头孢菌素类需谨慎                       ║
╠═══════════════════════════════════════════════════════════╣
║ 2. 磺胺类药物 - 严重过敏（3级）🆘                        ║
║    ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ ║
║    反应：全身性皮疹、发热、关节痛                        ║
║    诊断：2012-08-20                                      ║
║    ⚠️  绝对禁止：磺胺类抗菌药物                          ║
╠═══════════════════════════════════════════════════════════╣
║ 3. 碘造影剂 - 严重过敏（3级）🆘                          ║
║    ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ ║
║    反应：面部水肿、呼吸困难、低血压                      ║
║    诊断：2018-03-10                                      ║
║    ⚠️  绝对禁止：含碘造影剂（CT增强、血管造影）         ║
║    ⚠️  替代方案：MRI或超声检查                           ║
╠═══════════════════════════════════════════════════════════╣
║ 💊 当前用药（7种）                                      ║
╠═══════════════════════════════════════════════════════════╣
║ ⚠️  药物相互作用警示                                   ║
║ ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ ║
║ • 阿司匹林 + 氯吡格雷                                  ║
║   风险：出血风险增加                                    ║
║ • ACEI + 利尿剂                                        ║
║   风险：肾功能影响                                      ║
╠═══════════════════════════════════════════════════════════╣
║ 用药列表：                                              ║
║ ─────────────────────────────────────────────────────── ║
║ 1. 阿司匹林 100mg - 每日1次                             ║
║ 2. 氯吡格雷 75mg - 每日1次                              ║
║ 3. 氨氯地平 5mg - 每日2次                               ║
║ 4. 贝那普利 10mg - 每日1次                              ║
║ 5. 氢氯噻嗪 12.5mg - 每日1次                            ║
║ 6. 孟鲁司特钠 10mg - 每晚1次                            ║
║ 7. 布地奈德吸入剂 - 必要时使用                          ║
╠═══════════════════════════════════════════════════════════╣
║ 🏥 医疗状况                                              ║
║ ─────────────────────────────────────────────────────── ║
║ • 过敏性哮喘（2015-04-12诊断）                          ║
║ • 高血压（2018-06-20诊断）                              ║
║ • 肾功能不全（CKD 3期，2020-11-05诊断）                 ║
╠═══════════════════════════════════════════════════════════╣
║ 📞 紧急联系人                                            ║
║ ─────────────────────────────────────────────────────── ║
║ • 配偶：周女士 - 137****2468                            ║
╠═══════════════════════════════════════════════════════════╣
║ ⚠️  就医注意事项                                        ║
║ ─────────────────────────────────────────────────────── ║
║ 1. 主动告知医生三种严重过敏史                           ║
║ 2. 避免使用含碘造影剂，选择MRI或超声                    ║
║ 3. 肾功能不全，用药需调整剂量                           ║
║ 4. 抗血小板药物，手术需提前停药                         ║
║ 5. 哮喘患者，避免使用β受体阻滞剂                        ║
╠═══════════════════════════════════════════════════════════╣
║ 🆘 过敏急救流程                                          ║
║ ─────────────────────────────────────────────────────── ║
║ 如出现呼吸困难、喉头水肿、血压下降：                    ║
║ 1. 立即停止接触可疑过敏原                               ║
║ 2. 立即拨打120                                          ║
║ 3. 保持呼吸道通畅                                        ║
║ 4. 如有肾上腺素自动注射器，立即使用                     ║
║ 5. 等待专业医疗救援                                      ║
╚═══════════════════════════════════════════════════════════╝

⚠️  此患者存在多重严重过敏，请特别小心用药
生成时间：2025-12-31 12:34:56
```

### 严重过敏患者建议
```
💡 严重过敏患者使用建议：
━━━━━━━━━━━━━━━━━━━━━━━━━━
1. 随身携带过敏急救包
2. 佩戴医疗警示手环
3. 手机设置过敏警示壁纸
4. 每次就诊主动告知过敏史
5. 定期更新过敏信息
6. 告知家人过敏急救方法
```

---

## 常见使用场景总结

| 场景 | 重点信息 | 建议格式 |
|------|---------|---------|
| **旅行** | 过敏史、用药、植入物 | 二维码 + 文本版 |
| **老年人独居** | 多重用药、紧急联系人 | 大字体文本版 |
| **儿童上学** | 过敏、家长联系方式 | 学校专用格式 |
| **严重过敏** | 过敏原、交叉过敏、急救流程 | 详细版 + 急救说明 |
| **手术准备** | 用药、植入物、过敏 | 医生专用格式 |
| **日常携带** | 简洁版关键信息 | 钱包卡片尺寸 |
