---
name: occupational-health-analyzer
description: 分析职业健康数据、识别工作相关健康风险、评估职业健康状况、提供个性化职业健康建议。支持与睡眠、运动、心理健康等其他健康数据的关联分析。
allowed-tools: Read, Grep, Glob, Write, Edit
---

# 职业健康分析技能

## 核心功能

职业健康分析技能提供全面的职业健康数据分析功能，帮助用户追踪工作相关健康问题、识别职业健康风险、评估工作环境人机工程水平和优化职业健康。

**主要功能模块：**

1. **职业健康风险评估** - 久坐、视屏终端、倒班工作、重复性劳损、工作压力等多维度风险评估
2. **工作相关问题追踪** - 颈肩腰腿痛、眼疲劳、腕管综合征等症状监测
3. **人机工程评估** - 工作站、椅子、显示器、键盘、环境等全方位评估
4. **职业病筛查** - 基于工作类型的职业病风险评估和筛查建议
5. **趋势分析** - 症状发展、改善效果、风险变化趋势
6. **关联分析** - 与睡眠、运动、心理健康、慢性病模块的关联分析
7. **个性化建议** - 工作姿势、休息提醒、设备建议、环境优化
8. **预警系统** - 高风险模式、症状恶化、职业病风险预警

## 触发条件

技能在以下情况下自动触发：

1. 用户使用 `/work trend` 查看职业健康趋势
2. 用户使用 `/work status` 查看综合健康状态
3. 用户使用 `/work recommend` 获取改进建议
4. 用户使用 `/work assess` 进行综合评估
5. 用户使用 `/work issue` 记录问题后的分析
6. 用户使用 `/work ergonomic` 进行人机工程评估后的分析

## 医学安全边界

**本技能不能做的事：**
- ❌ 不进行职业病诊断
- ❌ 不出具职业病诊断证明
- ❌ 不替代工作场所健康监护
- ❌ 不预测疾病发展
- ❌ 不处理急性健康危机

**本技能能做的事：**
- ✅ 职业健康风险评估和筛查
- ✅ 工作相关症状识别和追踪
- ✅ 人机工程评估和改进建议
- ✅ 职业病风险预警
- ✅ 工作环境改善建议
- ✅ 健康记录保存（就医时参考）
- ✅ 与其他健康数据的关联分析

## 执行步骤

### 第1步：数据读取

读取职业健康数据文件：
- `data-example/occupational-health-tracker.json` - 主职业健康档案

**数据验证：**
- 检查文件是否存在
- 验证数据结构完整性
- 确认有足够的数据点进行分析

### 第2步：职业健康风险评估

#### 久坐风险评估（Sedentary Risk Score）

**评分维度（每个维度0-10分）**：

1. **每天久坐时间** (sedentary_time_daily)
   - >8小时：10分
   - 6-8小时：7分
   - 4-6小时：4分
   - <4小时：1分

2. **休息频率** (break_frequency)
   - 无休息：10分
   - 每3小时+：8分
   - 每2小时：5分
   - 每小时：2分

3. **每周运动时间** (weekly_exercise_minutes)
   - 0分钟：10分
   - <60分钟：7分
   - 60-150分钟：4分
   - >150分钟：1分

4. **现有症状** (existing_symptoms_severity)
   - 严重症状：10分
   - 中度症状：7分
   - 轻度症状：4分
   - 无症状：1分

**总分计算**：
```
总分 = 久坐时间 + 休息频率 + 运动时间 + 现有症状
范围：4-40分
```

**风险等级判定**：
- 低风险：4-13分
- 中风险：14-26分
- 高风险：27-40分

#### 视屏终端风险评估（VDT Risk Score）

**评分维度（每个维度0-10分）**：

1. **每天屏幕时间** (screen_time_daily)
   - >8小时：10分
   - 6-8小时：7分
   - 4-6小时：4分
   - <4小时：1分

2. **20-20-20法则遵守** (rule_20_20_20_compliance)
   - 从不遵守：10分
   - 偶尔遵守：6分
   - 经常遵守：3分
   - 总是遵守：1分

3. **照明条件** (lighting_quality)
   - 很差：10分
   - 较差：7分
   - 一般：4分
   - 良好：1分

4. **眼部症状** (eye_symptoms_severity)
   - 严重症状：10分
   - 中度症状：7分
   - 轻度症状：4分
   - 无症状：1分

**总分计算和风险等级判定同久坐风险**

#### 综合风险评估

**综合风险等级计算**：
```
综合风险分数 = max(久坐风险, 视屏风险, 倒班风险, 劳损风险, 压力风险)

如果有多个高风险因素（≥27分），综合风险等级上调一级
如果有3个及以上中风险因素（14-26分），综合风险等级上调一级
```

### 第3步：人机工程评估

#### 评估维度和评分

**椅子评估**（0-20分）：
```
- 可调节性（0-5分）
- 腰椎支撑（0-5分）
- 座椅深度（0-5分）
- 扶手（0-5分）
```

**显示器评估**（0-20分）：
```
- 高度（0-7分）
- 距离（0-7分）
- 角度（0-6分）
```

**键盘和鼠标评估**（0-20分）：
```
- 键盘位置（0-5分）
- 鼠标位置（0-5分）
- 手腕支撑（0-10分）
```

**工作台评估**（0-20分）：
```
- 高度（0-10分）
- 空间（0-10分）
```

**环境评估**（0-20分）：
```
- 照明（0-7分）
- 噪音（0-7分）
- 温度（0-6分）
```

**总分计算**：
```
总分 = 椅子 + 显示器 + 键盘鼠标 + 工作台 + 环境
范围：0-100分

评分等级：
- 优秀：0-20分
- 良好：21-40分
- 一般：41-60分
- 较差：61-80分
- 差：81-100分
```

### 第4步：职业病筛查

#### 基于工作类型的筛查推荐

**办公室工作**：
```
必查项目：
- 视力测试（每年1次）
- 肌肉骨骼评估（每年1次）
```

**体力劳动**：
```
必查项目：
- 肌肉骨骼评估（每年1次）
- 肺功能检查（粉尘环境每年1次）
```

**倒班工作**：
```
必查项目：
- 睡眠质量评估（每6个月1次）
- 心理健康筛查（每年1次）
```

**噪音环境工作**：
```
必查项目：
- 听力测试（每年1次）
```

**粉尘/化学环境工作**：
```
必查项目：
- 肺功能检查（每年1次）
- 皮肤病筛查（每年1次）
```

### 第5步：关联分析

#### 睡眠-职业健康关联
- 倒班工作与睡眠质量的相关性
- 睡眠不足与工作相关症状的关系

#### 运动-职业健康关联
- 久坐工作与运动量的关系
- 运动与肌肉骨骼症状的关系

#### 心理健康-职业健康关联
- 工作压力与心理状态的关系
- 职业健康问题与心理症状的关联

### 第6步：生成报告

输出包括：
- 职业健康状况摘要
- 风险评估结果和趋势
- 工作相关问题分析
- 人机工程评估结果
- 职业病筛查建议
- 与其他健康因素的关联分析
- 预警信息（如适用）
- 个性化建议和行动计划

## 输出格式

### 职业健康分析报告结构

```markdown
# 职业健康分析报告

**报告日期**: YYYY-MM-DD
**分析周期**: YYYY-MM-DD 至 YYYY-MM-DD
**数据完整性**: 良好

⚠️ **重要提示**：本报告仅供参考，不构成职业病诊断。

---

## 1. 职业健康状况摘要

[整体评价：优秀/良好/一般/需改进/高风险]
- 综合风险等级：[低/中/高]
- 职业健康评分：X/100
- 人机工程评分：X/100
- 活跃问题数：X个
- 整体趋势：改善/稳定/恶化

## 2. 风险评估结果

### 久坐风险评估
**风险等级**: 🟢 低风险 | 🟡 中风险 | 🔴 高风险
**风险评分**: X/40

**建议**: [具体建议]

### 视屏终端风险评估
**风险等级**: 🟢 低风险 | 🟡 中风险 | 🔴 高风险
**风险评分**: X/40

**建议**: [具体建议]

## 3. 工作相关问题分析

### 当前活跃问题
- [问题1]: 严重程度、频率、持续时间
- [问题2]: 严重程度、频率、持续时间

### 症状趋势
- 改善的问题
- 稳定的问题
- 恶化的问题 ⚠️

## 4. 人机工程评估

**人机工程评分**: X/100
**评分等级**: 优秀/良好/一般/较差/差

### 改进建议
- 高优先级建议
- 中优先级建议
- 低优先级建议

## 5. 职业病筛查

### 推荐筛查
- [筛查项目1] - 建议时间
- [筛查项目2] - 建议时间

## 6. 综合建议

### 立即行动
- [行动项]

### 本周行动计划
- [行动项1]
- [行动项2]

### 预防措施
- [预防措施列表]

---

**报告生成时间**: YYYY-MM-DD HH:MM:SS
⚠️ **免责声明**：本报告仅供参考，不构成职业病诊断或治疗建议。
```

## 错误处理

### 数据文件不存在
```
错误：未找到职业健康数据文件
建议：请先使用 /work assess 命令创建数据
```

### 数据不足
```
警告：数据不足以进行趋势分析
建议：至少需要3次评估记录
```

### 高风险预警
```
🔴 职业病高风险警告

检测到以下高风险因素：
- [列出高风险因素]

建议行动：
1. 立即就医，进行职业病诊断
2. 咨询职业医学专科医生
3. 考虑工作调整
```

## 数据源说明

**主要数据源**：
- `data-example/occupational-health-tracker.json` - 职业健康主数据

**关联数据源**：
- `data-example/sleep-tracker.json` - 睡眠数据
- `data-example/fitness-tracker.json` - 运动数据
- `data-example/mental-health-tracker.json` - 心理健康数据

---

**技能版本**: v1.0.0
**最后更新**: 2025-01-08
**维护者**: WellAlly Tech
