---
name: mental-health-analyzer
description: 分析心理健康数据、识别心理模式、评估心理健康状况、提供个性化心理健康建议。支持与睡眠、运动、营养等其他健康数据的关联分析。
allowed-tools: Read, Grep, Glob, Write, Edit
---

# 心理健康分析技能

## 核心功能

心理健康分析技能提供全面的心理健康数据分析功能，帮助用户追踪心理状态、识别情绪模式、监测危机风险和优化应对策略。

**主要功能模块：**

1. **心理健康评估分析** - PHQ-9/GAD-7等量表评分趋势分析
2. **情绪模式识别** - 识别常见情绪、触发因素和应对方式效果
3. **心理治疗进展追踪** - 治疗目标达成和症状改善评估
4. **危机风险评估** - 多级危机风险检测（高/中/低）和预警
5. **睡眠-心理关联分析** - 睡眠质量与心理状态的关联性分析
6. **运动-情绪关联分析** - 运动与情绪改善的关系分析
7. **营养-心理关联分析** - 饮食对情绪和焦虑的影响分析
8. **慢性病-心理关联分析** - 慢性疾病与心理健康的关系分析

## 触发条件

技能在以下情况下自动触发：

1. 用户使用 `/mental trend` 查看心理状况趋势
2. 用户使用 `/mental pattern` 分析情绪模式
3. 用户使用 `/mental therapy progress` 查看治疗进展
4. 用户使用 `/crisis assessment` 进行危机风险评估
5. 用户使用 `/mental report` 生成心理健康报告

## 医学安全边界

**本技能不能做的事：**
- ❌ 不进行心理疾病诊断
- ❌ 不开具精神药物处方
- ❌ 不预测自杀风险或自伤行为
- ❌ 不替代专业心理治疗
- ❌ 不处理急性精神危机

**本技能能做的事：**
- ✅ 识别心理健康趋势和模式
- ✅ 评估危机风险等级并发出预警
- ✅ 提供应对策略建议（非治疗性）
- ✅ 追踪治疗进展和目标达成
- ✅ 提供就医建议和专业资源信息
- ✅ 分析心理健康与其他健康因素的关联

## 执行步骤

### 第1步：数据读取

读取心理健康数据文件：
- `data-example/mental-health-tracker.json` - 主心理健康档案
- `data-example/mental-health-logs/.index.json` - 日志索引
- `data-example/mental-health-logs/YYYY-MM/YYYY-MM-DD.json` - 每日情绪日记

**数据验证：**
- 检查文件是否存在
- 验证数据结构完整性
- 确认有足够的数据点进行分析（建议至少3次PHQ-9/GAD-7评估，或7天情绪日记）

### 第2步：心理健康评估趋势分析

**PHQ-9抑郁评分趋势分析：**
```
- 分析不同时间点的PHQ-9评分
- 计算评分变化速率（分/月）
- 识别严重程度变化（无/轻度/中度/重度）
- 检测PHQ-9第9项（自伤意念）的变化
- 预测未来趋势（改善/稳定/恶化）
- 与治疗进展关联分析
```

**GAD-7焦虑评分趋势分析：**
```
- 分析GAD-7评分时序变化
- 识别焦虑症状变化模式
- 关联触发因素与焦虑水平
- 评估应对方式效果
- 预测焦虑趋势
```

**PSQI睡眠质量与心理状态关联：**
```
- PSQI评分与PHQ-9/GAD-7评分的相关性
- 睡眠障碍对情绪的影响
- 睡眠改善与心理状态改善的关系
```

**严重程度变化检测：**
```
- 识别严重程度升级（需要关注）
- 识别严重程度降级（积极信号）
- 检测快速恶化（≥5分/月，危机预警）
- 检测快速改善（强化有效策略）
```

### 第3步：情绪模式识别

**常见情绪统计：**
```
- 统计最常见的主要情绪（top 5）
- 计算平均情绪强度
- 识别情绪分布模式
- 分析情绪多样性
```

**时间模式分析：**
```
- 一天中的情绪变化模式（早/中/晚）
- 一周中的情绪变化模式（周一至周日）
- 情绪波动程度（方差/标准差）
- 情绪稳定性评估
```

**触发因素分析：**
```
- 统计高频触发因素（top 10）
- 计算每个触发因素的平均影响
- 识别高危触发因素（高影响+高频）
- 触发因素与情绪类型的关联
```

**应对方式效果评估：**
```
- 计算每种应对方式的有效性（有帮助/没帮助的比例）
- 识别高效应对策略（>80%有效）
- 识别低效应对策略（<50%有效）
- 应对方式与情绪类型的匹配分析
```

### 第4步：心理治疗进展追踪

**治疗目标达成评估：**
```
- 计算每个目标的完成百分比
- 评估症状改善程度（基线→当前→目标）
- 预估目标达成时间
- 识别滞后目标（需要调整）
```

**治疗过程分析：**
```
- 治疗频率和依从性
- 作业完成率和质量
- 治疗联盟强度
- 咨询前后情绪变化
```

**症状改善评估：**
```
- PHQ-9/GAD-7评分变化（治疗前→治疗后）
- 症状缓解百分比
- 功能水平改善
- 生活质量变化
```

### 第5步：危机风险评估（优先级：最高）

**多级风险检测机制：**

```
风险等级计算（总分0-20+）：

1. PHQ-9第9项检测（最高优先级）
   - 得分=2（经常）：+10分，直接判定高风险
   - 得分=1（有时）：+5分
   - 得分=0（完全不会）：+0分

2. 症状快速恶化检测
   - 快速恶化（≥5分/月）：+5分
   - 恶化（2-4分/月）：+3分
   - 稳定（-1至1分/月）：+0分
   - 改善（≤-2分/月）：-2分

3. 高强度负面情绪占比检测
   - 占比>70%：+3分
   - 占比50-70%：+2分
   - 占比<50%：+0分

4. 情绪波动检测
   - 方差>6（波动大）：+2分
   - 方差4-6（波动中）：+1分
   - 方差<4（波动小）：+0分

5. 危机计划预警信号检测
   - 每出现一个预警信号：+2分

6. 社会退缩检测
   - 严重退缩（独处时间>80%）：+3分
   - 中度退缩（独处时间50-80%）：+2分
   - 轻度/无退缩：+0分

7. 功能受损检测
   - 严重受损（≥5天/周）：+4分
   - 中度受损（3-4天/周）：+2分
   - 轻度/无受损：+0分

风险等级判定：
- 高风险（≥10分）：立即就医，启动危机干预
- 中风险（5-9分）：密切关注，考虑就医（48小时内）
- 低风险（0-4分）：继续监测，定期评估
```

**危机预警信号检测：**
```
- 绝望感（hopelessness）
- 社会退缩（social_withdrawal）
- 极端情绪波动（extreme_mood_swings）
- 谈论死亡（talk_of_death）
- 送走财物（giving_away_possessions）
- 自伤意念（self_harm）
- 自杀想法（suicidal_thoughts）
- 物质滥用（substance_abuse）
```

**紧急行动触发条件：**
```
立即就医（24小时内）：
- PHQ-9第9项得分≥2
- 总风险评分≥10分
- 出现幻觉或妄想
- 有自伤或自杀计划

尽快就医（48小时内）：
- PHQ-9≥15分或GAD-7≥15分
- 总风险评分5-9分
- 症状快速恶化（≥5分/月）
- 严重影响功能

定期就医（1个月内）：
- PHQ-9 10-14分或GAD-7 10-14分
- 总风险评分<5分但症状持续
- 需要专业支持
```

### 第6步：睡眠-心理关联分析

**数据来源：**
- 读取 `data-example/sleep-tracker.json`
- 提取睡眠时长、睡眠质量（PSQI）、入睡时间等数据

**关联分析：**
```
- 睡眠时长与PHQ-9评分的相关性
- 睡眠质量与GAD-7评分的相关性
- 失眠症状与情绪稳定性的关系
- 睡眠改善与心理状态改善的时间关系
- 睡眠障碍类型与特定心理症状的关联
```

**分析输出：**
```
- 相关性系数和统计显著性
- 睡眠对心理状态的影响程度（高/中/低）
- 睡眠改善建议
- 睡眠与情绪的双向关系分析
```

### 第7步：运动-情绪关联分析

**数据来源：**
- 读取 `data-example/fitness-tracker.json`
- 提取运动频率、运动类型、运动强度、运动时长等数据

**关联分析：**
```
- 运动频率与平均情绪强度的关系
- 运动类型与情绪改善效果的关系
- 运动强度与焦虑水平的关系
- 运动时长与情绪持续时间的关系
- 运动后的情绪变化模式
- 运动习惯与抑郁症状的关系
```

**分析输出：**
```
- 运动对情绪的积极影响程度
- 最有效的运动类型推荐
- 最佳运动频率建议
- 运动与应对方式的关系
```

### 第8步：营养-心理关联分析

**数据来源：**
- 读取 `data-example/nutrition-tracker.json`
- 提取咖啡因摄入、糖分摄入、饮食习惯等数据

**关联分析：**
```
- 咖啡因摄入量与GAD-7焦虑评分的关系
- 糖分摄入与情绪波动的关联
- 饮食规律性与情绪稳定性的关系
- 特定营养素缺乏（维生素D、Omega-3）与抑郁症状
- 饮食模式与整体心理健康
```

**分析输出：**
```
- 饮食对心理状态的影响程度
- 营养建议（如减少咖啡因、均衡饮食）
- 可能的营养缺乏提示
- 饮食调整建议
```

### 第9步：慢性病-心理关联分析

**数据来源：**
- 读取相关慢性病数据文件（如 `diabetes-tracker.json`, `hypertension-tracker.json`）
- 提取疾病控制情况、症状负担、功能受限等数据

**关联分析：**
```
- 慢性疼痛与抑郁症状的关系
- 疾病控制情况与心理状态的关系
- 功能受限与心理健康的关系
- 疾病负担与焦虑水平的关系
- 共病模式识别
- 药物副作用对情绪的影响
- 药物依从性与症状改善的关系
```
```

**分析输出：**
```
- 慢性疾病对心理健康的影响程度
- 需要特别关注的心理问题
- 整体健康管理建议
- 心理支持对疾病管理的益处
```

### 第10步：生成报告

输出包括：
- 心理健康状况摘要
- 评估量表趋势分析
- 情绪模式和触发因素
- 治疗进展评估
- 危机风险等级和建议
- 与其他健康因素的关联分析
- 个性化建议和行动计划

## 输出格式

### 心理健康分析报告结构

```markdown
# 心理健康分析报告

**报告日期**: YYYY-MM-DD
**分析周期**: YYYY-MM-DD 至 YYYY-MM-DD
**数据完整性**: 良好

⚠️ **重要提示**：本报告仅供参考，不构成医学诊断。如有严重心理困扰，请寻求专业心理医生帮助。

---

## 危机风险预警

**当前风险等级**: 🟢 低风险 | 🟡 中风险 | 🔴 高风险

**风险评分**: X/20

**风险因素**:
- [列出检测到的风险因素]

**建议行动**:
- [根据风险等级提供具体建议]

---

## 1. 心理健康状况摘要

[整体评价：优秀/良好/一般/需改进/危机]
- PHQ-9评分：X分（严重程度）
- GAD-7评分：X分（严重程度）
- 睡眠质量：X分（PSQI）
- 整体趋势：改善/稳定/恶化

## 2. 心理评估趋势分析

### PHQ-9抑郁评分趋势
- 当前评分：X分
- 基线评分：X分
- 变化：±X分
- 变化速率：X分/月
- 趋势：改善/稳定/恶化
- 严重程度变化：[严重程度1] → [严重程度2]

**图表描述**：
- [折线图展示PHQ-9评分变化]
- [标记严重程度分界线：5, 10, 15]

**特别关注**：
- 第9项（自伤意念）得分：X
- 最高分项：[条目名称]
- 持续存在问题：[列出条目]

### GAD-7焦虑评分趋势
- 当前评分：X分
- 基线评分：X分
- 变化：±X分
- 变化速率：X分/月
- 趋势：改善/稳定/恶化

**图表描述**：
- [折线图展示GAD-7评分变化]
- [标记严重程度分界线：5, 10, 15]

**主要焦虑症状**：
- 最高分项：[条目名称]
- 主要触发因素：[列出]

### PSQI睡眠质量
- 总分：X分
- 睡眠质量：[评价]
- 主要问题：[列出问题成分]

## 3. 情绪模式分析

### 常见情绪
1. [情绪1] - 占比X%，平均强度X/10
2. [情绪2] - 占比X%，平均强度X/10
3. [情绪3] - 占比X%，平均强度X/10

**图表描述**：
- [饼图展示情绪分布]
- [雷达图展示多维度情绪]

### 时间模式
- 早晨：主要情绪[情绪]，平均强度X/10
- 下午：主要情绪[情绪]，平均强度X/10
- 晚上：主要情绪[情绪]，平均强度X/10

### 周模式
- 周一至周五：主要情绪[情绪]，平均强度X/10
- 周末：主要情绪[情绪]，平均强度X/10

### 情绪稳定性
- 波动程度：高/中/低
- 情绪方差：X

**图表描述**：
- [折线图展示情绪强度时序变化]
- [波动范围可视化]

## 4. 触发因素分析

### 高频触发因素（Top 10）
| 排名 | 触发因素 | 频次 | 平均影响 |
|------|----------|------|----------|
| 1 | [触发因素1] | X次 | 高/中/低 |
| 2 | [触发因素2] | X次 | 高/中/低 |
| ... |

### 高危触发因素（高影响+高频）
- [触发因素1] - 频次X，影响高，建议：[应对建议]
- [触发因素2] - 频次X，影响高，建议：[应对建议]

**图表描述**：
- [柱状图展示触发因素频次]
- [热图展示触发因素与情绪类型的关联]

## 5. 应对方式效果评估

### 应对方式排名（按效果）
| 应对方式 | 有效次数 | 无效次数 | 有效率 | 排名 |
|----------|----------|----------|--------|------|
| [应对方式1] | X次 | X次 | XX% | 1 |
| [应对方式2] | X次 | X次 | XX% | 2 |
| ... |

### 高效应对策略（>80%有效）
- [策略1] - 有效率XX%，推荐使用
- [策略2] - 有效率XX%，推荐使用

### 低效应对策略（<50%有效）
- [策略1] - 有效率XX%，建议调整或停止
- [策略2] - 有效率XX%，建议调整或停止

**图表描述**：
- [条形图展示应对方式效果排名]
- [饼图展示有效/无效比例]

## 6. 心理治疗进展

### 治疗概况
- 治疗类型：[CBT/心理动力学/人本主义等]
- 治疗频率：[每周/每两周等]
- 已进行咨询次数：X次
- 治疗时长：X个月

### 治疗目标进展
| 目标 | 基线 | 当前 | 目标 | 进展 | 预计达成时间 |
|------|------|------|------|------|--------------|
| [目标1] | X分 | X分 | X分 | XX% | YYYY-MM-DD |
| [目标2] | X分 | X分 | X分 | XX% | YYYY-MM-DD |

**整体进展评价**：[优秀/良好/一般/需改进]

### 症状改善
- PHQ-9评分变化：X分 → X分，改善XX%
- GAD-7评分变化：X分 → X分，改善XX%
- 整体功能水平：[改善/稳定/恶化]

### 作业完成情况
- 平均完成率：XX%
- 高质量完成：XX%
- 需要加强的方面：[列出]

## 7. 危机风险评估

### 风险等级
**当前风险等级**: 🟢 低风险 | 🟡 中风险 | 🔴 高风险

**风险评分**: X/20

### 风险因素分析
| 风险因素 | 得分 | 详情 |
|----------|------|------|
| PHQ-9第9项 | X分 | 得分X，[详情] |
| 症状变化 | X分 | [快速恶化/恶化/稳定/改善] |
| 情绪强度 | X分 | 高强度负面情绪占比XX% |
| 情绪波动 | X分 | 波动[大/中/小] |
| 预警信号 | X分 | 出现X个预警信号：[列出] |
| 社会退缩 | X分 | [严重/中度/轻度/无]退缩 |
| 功能受损 | X分 | [严重/中度/轻度/无]受损 |

### 检测到的预警信号
- [如有列出]

### 建议行动
- [根据风险等级提供具体行动建议]

### 紧急资源
- 心理危机热线：400-xxx-xxxx（24小时）
- 精神科急诊：就近三甲医院
- 急救电话：120

## 8. 与其他健康因素的关联分析

### 睡眠-心理关联
**关联强度**: 高/中/低

**主要发现**:
- 睡眠时长与PHQ-9评分的相关性：r=X.XX
- 睡眠质量与情绪稳定性的关系：[描述]
- 主要睡眠问题：[列出]
- 改善睡眠对心理状态的潜在益处：[描述]

**建议**:
- [具体的睡眠改善建议]

### 运动-情绪关联
**关联强度**: 高/中/低

**主要发现**:
- 运动频率与情绪改善的关系：[描述]
- 最有效的运动类型：[列出]
- 运动后的情绪变化：[描述]

**建议**:
- [具体的运动建议]

### 营养-心理关联
**关联强度**: 高/中/低

**主要发现**:
- 咖啡因摄入与焦虑的关系：[描述]
- 糖分摄入与情绪波动的关系：[描述]
- 可能的营养缺乏：[列出]

**建议**:
- [具体的营养建议]

### 慢性病-心理关联
**关联强度**: 高/中/低

**主要发现**:
- [慢性病]与心理状态的关系：[描述]
- 疾病负担对心理健康的影响：[描述]
- 功能受限与情绪的关系：[描述]

**建议**:
- [具体的整体健康管理建议]

## 9. 综合建议

### 立即行动（如适用）
- [如有紧急问题，列出立即需要采取的行动]

### 本周行动计划
1. [行动项1] - 优先级：高/中/低
2. [行动项2] - 优先级：高/中/低
3. ...

### 本月目标
1. [目标1]
2. [目标2]
3. ...

### 继续保持的方面
- [列出做得好的方面，鼓励继续保持]

### 需要改进的方面
- [列出需要改进的方面，提供具体建议]

### 推荐资源
- [书籍/APP/支持团体/在线资源等]

## 10. 数据质量说明

- 数据完整性：[优秀/良好/一般/需改进]
- PHQ-9评估次数：X次
- GAD-7评估次数：X次
- 情绪日记条目：X条
- 时间跨度：X天

---

**报告生成时间**: YYYY-MM-DD HH:MM:SS
**下次评估建议时间**: YYYY-MM-DD

⚠️ **免责声明**：本报告由心理健康分析技能自动生成，仅供参考，不构成医学诊断或治疗建议。如有任何心理健康问题，请寻求专业心理医生或精神科医生的帮助。
```

## 使用示例

### 示例1：趋势分析

**用户输入**：
```
/mental trend 3months
```

**技能执行**：
1. 读取最近3个月的PHQ-9和GAD-7评估数据
2. 计算评分变化速率和趋势
3. 分析严重程度变化
4. 检测PHQ-9第9项变化
5. 生成趋势报告

**输出**：
```markdown
# 心理健康趋势分析（近3个月）

## 整体趋势
- PHQ-9：14分 → 8分，改善6分，趋势：改善 ✓
- GAD-7：12分 → 6分，改善6分，趋势：改善 ✓
- 变化速率：约2分/月

## 严重程度变化
- PHQ-9：中度抑郁 → 轻度抑郁 ✓
- GAD-7：中度焦虑 → 轻度焦虑 ✓

## 积极信号
- 症状持续改善
- PHQ-9第9项得分：1 → 0 ✓
- 治疗效果良好

## 建议
- 继续当前治疗
- 保持运动和睡眠习惯
- 下次评估：1个月后
```

### 示例2：情绪模式分析

**用户输入**：
```
/mental pattern
```

**技能执行**：
1. 读取情绪日记数据
2. 统计常见情绪和时间模式
3. 分析触发因素和应对方式
4. 生成模式识别报告

**输出**：
```markdown
# 情绪模式分析

## 常见情绪（Top 3）
1. 焦虑 - 占比35%，平均强度7/10
2. 疲劳 - 占比25%，平均强度6/10
3. 平静 - 占比20%，平均强度7/10

## 时间模式
- 早晨：平静（强度7/10）😌
- 下午：焦虑（强度7/10）😰
- 晚上：疲劳（强度6/10）😴

## 主要触发因素（Top 5）
1. 工作压力 - 12次，影响高
2. 睡眠不足 - 8次，影响中
3. 运动 - 6次，影响积极
4. 社交 - 5次，影响积极
5. 交通拥堵 - 4次，影响中

## 高效应对策略
1. 运动 - 有效率90% ✓
2. 冥想 - 有效率85% ✓
3. 深呼吸 - 有效率75% ✓

## 建议
- 下午工作压力大时，可使用深呼吸或短暂散步
- 保持规律运动，对情绪改善效果显著
- 改善睡眠有助于减轻焦虑和疲劳
```

### 示例3：危机风险评估

**用户输入**：
```
/crisis assessment
```

**技能执行**：
1. 读取最近的PHQ-9/GAD-7评估
2. 读取最近的情绪日记
3. 执行危机风险检测算法
4. 计算风险评分和等级
5. 生成危机风险报告

**输出**：
```markdown
# 危机风险评估

## 当前风险等级：🟢 低风险

**风险评分**: 3/20

## 风险因素分析
| 风险因素 | 得分 | 详情 |
|----------|------|------|
| PHQ-9第9项 | 0分 | 得分0，无自伤意念 ✓ |
| 症状变化 | -2分 | 改善趋势 ✓ |
| 情绪强度 | 2分 | 高强度负面情绪占比45% |
| 情绪波动 | 1分 | 波动中等 |
| 预警信号 | 0分 | 未检测到 ✓ |
| 社会退缩 | 0分 | 社交活动良好 ✓ |
| 功能受损 | 0分 | 功能正常 ✓ |
| **总分** | **3分** | **低风险** ✓ |

## 建议行动
- 继续监测心理状态
- 保持健康的生活习惯
- 定期进行心理评估（每月1次）
- 继续心理治疗（如有）

## 紧急资源（备用）
- 心理危机热线：400-xxx-xxxx（24小时）
- 精神科急诊：就近三甲医院
- 急救电话：120

⚠️ 如出现以下情况，请立即寻求专业帮助：
- 有自伤或自杀想法或计划
- 幻觉、妄想
- 完全失去功能
- 无法控制的情绪爆发
```

### 示例4：治疗进展分析

**用户输入**：
```
/mental therapy progress
```

**技能执行**：
1. 读取治疗记录和目标
2. 计算目标完成百分比
3. 分析症状改善程度
4. 评估作业完成情况
5. 生成治疗进展报告

**输出**：
```markdown
# 心理治疗进展分析

## 治疗概况
- 治疗类型：CBT（认知行为治疗）
- 治疗频率：每周1次
- 已进行咨询：24次
- 治疗时长：5个月

## 治疗目标进展
| 目标 | 基线 | 当前 | 目标 | 进展 | 预计达成时间 |
|------|------|------|------|------|--------------|
| 降低焦虑水平 | 14分 | 8分 | 5分 | 57% | 2025-08-01 |
| 改善睡眠质量 | 10分 | 6分 | 4分 | 60% | 2025-07-15 |
| 增加愉快活动 | 2次/周 | 5次/周 | 7次/周 | 50% | 2025-07-01 |

**整体进展评价**: 良好 ✓

## 症状改善
- PHQ-9评分：14分 → 8分，改善43% ✓
- GAD-7评分：14分 → 6分，改善57% ✓
- 整体功能水平：显著改善 ✓

## 作业完成情况
- 平均完成率：85%
- 高质量完成：60%
- 需要加强：认知重构练习

## 治疗亮点
- 焦虑症状显著改善
- 睡眠质量明显提升
- 行为激活效果良好
- 认知扭曲识别能力提升

## 继续保持
- 每周心理咨询
- 每日放松练习
- 行为激活（运动、社交）
- 思维记录

## 需要加强
- 认知重构练习
- 应对技巧应用
- 睡眠卫生维持
```

### 示例5：关联分析

**用户输入**：
```
/mental analysis correlations
```

**技能执行**：
1. 读取心理健康、睡眠、运动、营养、慢性病数据
2. 计算相关性系数
3. 分析影响程度
4. 生成关联分析报告

**输出**：
```markdown
# 心理健康关联分析

## 睡眠-心理关联（关联强度：高）

### 主要发现
- 睡眠时长与PHQ-9评分呈负相关（r=-0.72, p<0.01）
- 睡眠质量与情绪稳定性呈正相关（r=0.68, p<0.01）
- PSQI评分每改善1分，PHQ-9评分平均降低1.2分

### 睡眠问题影响
- 入睡困难 → 次日焦虑增加40%
- 夜间易醒 → 次日情绪低落增加35%
- 睡眠不足 → 注意力不集中，情绪波动加大

### 建议
- 保持规律作息，每晚23:00前入睡
- 改善睡眠卫生：避免咖啡因下午摄入
- 继续放松练习，促进睡眠

## 运动-情绪关联（关联强度：高）

### 主要发现
- 运动频率与积极情绪占比呈正相关（r=0.75, p<0.01）
- 运动日情绪平均强度比非运动日高1.5分
- 运动后焦虑感平均降低50%

### 最有效的运动类型
1. 有氧运动（跑步、游泳）- 改善率85%
2. 瑜伽 - 改善率80%
3. 户外散步 - 改善率75%

### 建议
- 保持每周3-5次运动，每次30分钟以上
- 优先选择有氧运动
- 焦虑时可进行户外散步

## 营养-心理关联（关联强度：中）

### 主要发现
- 咖啡因摄入与GAD-7评分呈正相关（r=0.52, p<0.05）
- 高糖饮食与情绪波动呈正相关（r=0.48, p<0.05）
- Omega-3摄入不足可能与抑郁症状相关

### 建议
- 减少咖啡因摄入（每天≤2杯）
- 减少添加糖摄入
- 考虑补充Omega-3（咨询医生）

## 综合建议
基于关联分析，以下生活方式对改善心理健康最有效：
1. **规律运动**（每周3-5次，30分钟+）
2. **充足睡眠**（7-8小时，23:00前入睡）
3. **均衡饮食**（减少咖啡因和糖分）
4. **持续治疗**（CBT心理治疗）

这4个方面的综合干预对您的心理健康改善贡献率为**75%**。
```

### 示例6：完整报告生成

**用户输入**：
```
/mental report
```

**技能执行**：
1. 读取所有相关数据
2. 执行完整分析流程
3. 生成交互式HTML报告
4. 包含危机警告和建议

**输出**：
生成完整的心理健康分析报告HTML文件，包含：
- 所有图表（ECharts交互式图表）
- 危机风险警告（如适用）
- 详细分析和建议
- 可下载或打印

---

## 错误处理

### 数据文件不存在
```
错误：未找到心理健康数据文件
建议：请先使用 /mental assess 或 /mental mood 命令创建数据
```

### 数据不足
```
警告：数据不足以进行趋势分析
建议：至少需要3次PHQ-9/GAD-7评估或7天情绪日记
当前数据：PHQ-9评估X次，情绪日记X条
```

### 危机风险高
```
🔴 危机警告：检测到高风险因素

立即行动：
1. 联系心理危机热线：400-xxx-xxxx（24小时）
2. 前往最近的精神科急诊
3. 拨打急救电话：120
4. 联系家人或朋友陪伴

检测到的风险因素：
- [列出高风险因素]

不要犹豫，立即寻求专业帮助！
```

## 数据源说明

**主要数据源**：
- `data-example/mental-health-tracker.json` - 心理健康主数据
- `data-example/mental-health-logs/` - 情绪日记日志

**关联数据源**：
- `data-example/sleep-tracker.json` - 睡眠数据
- `data-example/fitness-tracker.json` - 运动数据
- `data-example/nutrition-tracker.json` - 营养数据
- `data-example/diabetes-tracker.json` - 糖尿病数据（如适用）
- `data-example/hypertension-tracker.json` - 高血压数据（如适用）
- `data-example/medication-tracker.json` - 用药数据

## 性能优化

对于大量数据（如>6个月的情绪日记），采用以下优化策略：
- 数据聚合：按周/月聚合情绪数据
- 抽样分析：随机抽样代表性数据点
- 增量分析：仅分析新增数据
- 缓存中间结果

---

**技能版本**: v1.0.0
**最后更新**: 2025-01-06
**维护者**: WellAlly Tech
