---
name: travel-health-analyzer
description: 分析旅行健康数据、评估目的地健康风险、提供疫苗接种建议、生成多语言紧急医疗信息卡片。支持WHO/CDC数据集成的专业级旅行健康风险评估。
allowed-tools: Read, Write, Grep, Glob
---

# 旅行健康分析技能

## 🚨 重要医学免责声明

**本技能提供的所有健康建议和信息仅供参考,不能替代专业医疗建议。**

- ⚠️ **所有建议必须由专业医生审核**
- ⚠️ **疫苗接种和用药方案必须由医生制定**
- ⚠️ **不提供具体的医疗处方或诊断**
- ⚠️ **健康风险数据来源于WHO/CDC,可能存在滞后性**
- ⚠️ **紧急情况下请立即就医**

---

## 技能功能

### 1. 旅行健康规划分析

分析用户的旅行计划,提供全面的健康准备建议。

**输入**: 旅行目的地、日期、旅行目的
**输出**:
- 目的地健康风险评估
- 必要和推荐的疫苗接种清单
- 旅行药箱建议清单
- 预防措施建议
- 旅行前准备时间表

**分析要点**:
- 识别目的地传染病风险
- 评估食物和饮水安全
- 确认环境风险(高温、高原等)
- 检查当前疫情爆发信息
- 提供WHO/CDC参考链接

---

### 2. 目的地健康风险评估

基于WHO/CDC数据,对旅行目的地进行专业级健康风险评估。

**数据源**:
- 世界卫生组织(WHO)国际旅行健康
- 美国疾控中心(CDC)旅行健康
- 当地卫生部门官方数据

**评估维度**:
- 传染病风险(登革热、疟疾、霍乱、甲肝等)
- 食物和饮水安全
- 环境风险(高温、高原、空气污染)
- 季节性风险
- 当前疫情爆发警报

**风险等级**:
- 🟢 **低风险** - 常规预防措施
- 🟡 **中等风险** - 需要特别注意
- 🔴 **高风险** - 需要采取严格预防措施
- ⚫ **极高风险** - 建议推迟旅行或采取特殊防护

**输出格式**:
```markdown
## 目的地健康风险评估: Thailand

### 传染病风险
#### 🔴 登革热 - 高风险
- **传播方式**: 蚊子叮咬
- **季节性**: 全年
- **症状**: 高热、头痛、肌肉关节痛、皮疹
- **预防**: 使用防蚊液、穿长袖衣物、住宿选择有空调房间
- **数据源**: [WHO](https://www.who.int/ith) | [CDC](https://www.cdc.gov/dengue)

### 食物饮水安全
#### 🟡 中等风险
- 饮用瓶装水或煮沸的水
- 避免冰块
- 避免生食
- 水果自己剥皮

### 当前疫情警报
暂无重大疫情爆发警报
```

---

### 3. 疫苗接种需求分析

根据目的地和旅行计划,分析疫苗接种需求。

**分析内容**:
- 必需疫苗接种(如黄热病)
- 推荐疫苗接种(如甲肝、伤寒)
- 疫苗接种时间规划
- 疫苗相互作用检查
- 接种禁忌症评估

**疫苗清单模板**:
```json
{
  "vaccine": "甲肝疫苗",
  "status": "completed|planned|not_required|contraindicated",
  "date": "2025-06-15",
  "booster_required": false,
  "notes": "已完成接种,提供长期保护"
}
```

**时间规划原则**:
- 出发前4-6周:完成必需疫苗接种
- 出发前2-4周:完成推荐疫苗接种
- 某些疫苗需要多次接种,需提前规划

---

### 4. 旅行药箱智能建议

根据目的地健康风险和个人健康状况,生成个性化旅行药箱清单。

**药箱分类**:

#### 处方药
- 个人慢性病用药(足量+额外)
- 疟疾预防用药(如需要)
- 其他医生开具的旅行用药

#### 非处方药
- 止泻药(洛哌丁胺)
- 口服补液盐
- 退烧止痛药(对乙酰氨基酚/布洛芬)
- 抗过敏药(氯雷他定)
- 晕车药
- 抗酸药

#### 防护用品
- 防蚊液(DEET 20-30%)
- 防晒霜(SPF 50+)
- 口罩(N95)

#### 急救用品
- 创可贴
- 消毒液
- 纱布和绷带
- 体温计
- 小剪刀和镊子

**个性化建议**:
- 根据个人疾病史调整用药
- 根据目的地风险增减物品
- 考虑旅行时长和活动类型

---

### 5. 用药相互作用检查

检查旅行用药与个人慢性病用药之间的潜在相互作用。

**检查内容**:
- 疟疾预防用药 vs 慢性病用药
- 旅行期间临时用药 vs 常规用药
- 疫苗 vs 药物相互作用
- 食物 vs 药物相互作用

**常见相互作用**:
- 多西环素 vs 抗酸药、钙铁补充剂
- 甲氟喹 vs 某些心脏病药物
- 某些抗生素 vs 口服避孕药

**输出**:
```markdown
## 用药相互作用检查结果

### ⚠️ 发现潜在相互作用

**多西环素 ↔ 抗酸药**
- **影响**: 抗酸药降低多西环素吸收
- **建议**: 间隔2小时服用
- **严重程度**: 中等

### ✅ 无相互作用
- 氨氯地平 vs 旅行用药无已知相互作用
```

---

### 6. 多语言紧急信息卡片生成

生成包含关键医疗信息的多语言紧急卡片。

**支持语言**:
- 英语 (en)
- 中文 (zh)
- 日语 (ja)
- 韩语 (ko)
- 法语 (fr)
- 西班牙语 (es)
- 泰语 (th)
- 越南语 (vi)

**卡片内容**:
```markdown
---
紧急医疗信息 | EMERGENCY MEDICAL INFORMATION
---

姓名: 张三 | Name: Zhang San
血型: A+ | Blood Type: A+
出生日期: 1990-01-01 | DOB: 1990-01-01

⚠️ 过敏史 | ALLERGIES
- 青霉素 (严重: 皮疹、呼吸困难) | Penicillin (Severe: Rash, Difficulty breathing)

当前用药 | CURRENT MEDICATIONS
- 氨氯地平 5mg 每日一次 (控制血压) | Amlodipine 5mg Once daily (Blood pressure)

疾病史 | MEDICAL CONDITIONS
- 高血压 (控制中) | Hypertension (Controlled)

紧急联系人 | EMERGENCY CONTACT
- 配偶: 李四 +86-138-1234-5678 | Spouse: Li Si +86-138-1234-5678
- 医生: 王医生 +86-10-8765-4321 | Doctor: Dr. Wang +86-10-8765-4321

---
[二维码: 扫描查看完整医疗记录]
[QR Code: Scan for complete medical records]
---
```

**二维码功能**:
- 编码关键医疗信息摘要
- 云端访问链接(模拟)
- 支持离线访问
- 可分享给医护人员

---

### 7. 旅行前后健康检查

#### 旅行前健康检查

**检查内容**:
- 个人健康状况评估
- 慢性病病情确认
- 用药充足性检查
- 疫苗接种确认
- 健康建议

**输出**:
```markdown
## 旅行前健康检查报告

### 整体评估: ✅ 适合旅行

### 健康状况
- 血压: 控制良好
- 慢性病: 稳定
- 用药: 充足

### 准备完成度
- ✅ 疫苗接种: 已完成
- ✅ 旅行药箱: 已准备
- ✅ 保险: 已购买
- ⚠️ 紧急卡片: 待生成

### 建议
1. 生成多语言紧急卡片
2. 携带足量慢性病用药
3. 旅行期间注意血压监测
```

#### 旅行后健康监测

**监测内容**:
- 发热监测(持续2-4周)
- 消化系统症状
- 皮肤异常
- 其他不适症状

**潜伏期疾病提醒**:
- 疟疾: 可在返回后数月内发病
- 登革热: 通常3-14天
- 伤寒: 1-3周
- 甲肝: 2-6周

---

## 数据文件操作

### 读取数据
```bash
# 读取旅行健康数据
Read: data/travel-health-tracker.json

# 读取示例数据
Read: data-example/travel-health-tracker.json
```

### 写入数据
```bash
# 更新旅行计划
Write: data/travel-health-tracker.json

# 保存健康检查日志
Write: data/travel-health-logs/pre-trip-assessment-YYYY-MM-DD.json
```

### 数据结构验证
- 验证必需字段存在
- 验证日期格式正确
- 验证枚举值有效
- 验证数据完整性

---

## WHO/CDC数据集成

### 静态数据库(当前实现)

内置常见旅行目的地健康风险数据:
- 东南亚: 登革热、甲肝、伤寒、疟疾
- 非洲: 疟疾、黄热病、霍乱、脑膜炎
- 南美: 登革热、黄热病、寨卡病毒
- 中东: 中东呼吸综合征(MERS)

**数据更新**: 手动更新,建议每季度更新一次

### 动态查询(未来扩展)

计划集成:
- WHO疫情新闻RSS订阅
- CDC Travel Health API
- 当地卫生部门疫情通报

---

## 输出格式

### 报告格式
- Markdown格式,便于阅读
- 结构化,便于程序处理
- 包含数据源引用
- 包含时间戳

### 日志格式
```json
{
  "log_id": "log_20250728_pretrip",
  "log_type": "pre_trip_assessment",
  "trip_id": "trip_20250801_seasia",
  "generated_at": "2025-07-28T10:00:00.000Z",
  "assessment_results": {
    "health_status": "suitable_for_travel",
    "vaccination_status": "completed",
    "risk_assessment": {...},
    "recommendations": [...]
  }
}
```

---

## 安全和隐私

### 数据保护
- 护照号码加密存储
- 二维码不包含完整敏感信息
- 支持数据导出和删除

### 医学安全
- 所有建议包含免责声明
- 强调医生咨询的必要性
- 不提供具体处方
- 引用权威数据源

---

## 使用示例

### 分析旅行计划
```
输入: "计划2025年8月去东南亚旅游14天"

输出:
1. 目的地健康风险评估
2. 疫苗接种建议
3. 旅行药箱清单
4. 预防措施
5. 时间表
```

### 生成紧急卡片
```
输入: "生成英中日泰四语紧急卡片"

输出:
1. 多语言卡片文本
2. 二维码(描述)
3. 保存建议
```

### 评估健康风险
```
输入: "评估泰国的健康风险"

输出:
1. 传染病风险清单
2. 食物饮水安全建议
3. 环境风险
4. 当前疫情警报
5. WHO/CDC参考链接
```

---

**版本**: v1.0.0
**最后更新**: 2025-01-08
**维护者**: WellAlly Tech
