#!/usr/bin/env bun
// @generated by mcporter@0.0.0 on 2025-11-27T03:43:15.400Z. DO NOT EDIT.
import { Command } from 'commander';
import { createRuntime, createServerProxy } from 'mcporter';
import { createCallResult } from 'mcporter';

const embeddedServer = {
  "name": "context7",
  "description": "Use this server to retrieve up-to-date documentation and code examples for any library.",
  "command": {
    "kind": "http",
    "url": "https://mcp.context7.com/mcp"
  }
} as const;
const embeddedSchemas = {
  "resolve-library-id": {
    "type": "object",
    "properties": {
      "libraryName": {
        "type": "string",
        "description": "Library name to search for and retrieve a Context7-compatible library ID."
      }
    },
    "required": [
      "libraryName"
    ]
  },
  "get-library-docs": {
    "type": "object",
    "properties": {
      "context7CompatibleLibraryID": {
        "type": "string",
        "description": "Exact Context7-compatible library ID (e.g., '/mongodb/docs', '/vercel/next.js', '/supabase/supabase', '/vercel/next.js/v14.3.0-canary.87') retrieved from 'resolve-library-id' or directly from user query in the format '/org/project' or '/org/project/version'."
      },
      "mode": {
        "type": "string",
        "enum": [
          "code",
          "info"
        ],
        "default": "code",
        "description": "Documentation mode: 'code' for API references and code examples (default), 'info' for conceptual guides, narrative information, and architectural questions."
      },
      "topic": {
        "type": "string",
        "description": "Topic to focus documentation on (e.g., 'hooks', 'routing')."
      },
      "page": {
        "type": "integer",
        "minimum": 1,
        "maximum": 10,
        "description": "Page number for pagination (start: 1, default: 1). If the context is not sufficient, try page=2, page=3, page=4, etc. with the same topic."
      }
    },
    "required": [
      "context7CompatibleLibraryID"
    ]
  }
} as const;
const embeddedName = "context7";
const embeddedDescription = "Use this server to retrieve up-to-date documentation and code examples for any library.";
const generatorInfo = "Generated by mcporter@0.0.0 — https://github.com/steipete/mcporter";
const generatorTools = [
  {
    "name": "resolve-library-id",
    "description": "Resolves a package/product name to a Context7-compatible library ID and returns a list of matching libraries.\n\nYou MUST call this function before 'get-library-docs' to obtain a valid Context7-compatible library ID UNLESS the user explicitly provides a library ID in the format '/org/project' or '/org/project/version' in their query.\n\nSelection Process:\n1. Analyze the query to understand what library/package the user is looking for\n2. Return the most relevant match based on:\n- Name similarity to the query (exact matches prioritized)\n- Description relevance to the query's intent\n- Documentation coverage (prioritize libraries with higher Code Snippet counts)\n- Source reputation (consider libraries with High or Medium reputation more authoritative)\n- Benchmark Score: Quality indicator (100 is the highest score)\n\nResponse Format:\n- Return the selected library ID in a clearly marked section\n- Provide a brief explanation for why this library was chosen\n- If multiple good matches exist, acknowledge this but proceed with the most relevant one\n- If no good matches exist, clearly state this and suggest query refinements\n\nFor ambiguous queries, request clarification before proceeding with a best-guess match.",
    "usage": "resolve-library-id --library-name <library-name> [--raw <json>]",
    "flags": "--library-name <library-name> [--raw <json>]"
  },
  {
    "name": "get-library-docs",
    "description": "Fetches up-to-date documentation for a library. You must call 'resolve-library-id' first to obtain the exact Context7-compatible library ID required to use this tool, UNLESS the user explicitly provides a library ID in the format '/org/project' or '/org/project/version' in their query. Use mode='code' (default) for API references and code examples, or mode='info' for conceptual guides, narrative information, and architectural questions.",
    "usage": "get-library-docs --context7-compatible-library-i-d <context7-compatible-library-i-d> [--mode <mode:code|info>] [--topic <topic>] [--page <page>] [--raw <json>]",
    "flags": "--context7-compatible-library-i-d <context7-compatible-library-i-d> [--mode <mode:code|info>] [--topic <topic>] [--page <page>] [--raw <json>]"
  }
] as const;
const embeddedMetadata = {
  "schemaVersion": 1,
  "generatedAt": "2025-11-27T03:43:15.400Z",
  "generator": {
    "name": "mcporter",
    "version": "0.0.0"
  },
  "server": {
    "name": "context7",
    "definition": {
      "name": "context7",
      "description": "Use this server to retrieve up-to-date documentation and code examples for any library.",
      "command": {
        "kind": "http",
        "url": "https://mcp.context7.com/mcp"
      }
    }
  },
  "artifact": {
    "path": "",
    "kind": "template"
  },
  "invocation": {
    "serverRef": "{\"name\":\"context7\",\"command\":\"https://mcp.context7.com/mcp\"}",
    "runtime": "bun",
    "bundler": "bun",
    "timeoutMs": 30000,
    "minify": false
  }
} as const;
const artifactKind = determineArtifactKind();
const program = new Command();
program.name(embeddedName);
program.description(embeddedDescription);
program.option('-t, --timeout <ms>', 'Call timeout in milliseconds', (value) => parseInt(value, 10), 30000);
program.option('-o, --output <format>', 'Output format: text|markdown|json|raw', 'text');
const commandSignatures: Record<string, string> = {
  "resolve-library-id": "function resolve-library-id(libraryName: string);",
  "get-library-docs": "function get-library-docs(context7CompatibleLibraryID: string, mode?: \"code\" | \"info\", topic?: string, page?: unknown);"
};
program.configureHelp({
	commandTerm(cmd) {
		const term = cmd.name();
		return commandSignatures[term] ?? cmd.name();
	},
});
program.showSuggestionAfterError(true);

program
	.command("resolve-library-id")
	.summary("resolve-library-id --library-name <library-name> [--raw <json>]")
	.description("Resolves a package/product name to a Context7-compatible library ID and returns a list of matching libraries.\n\nYou MUST call this function before 'get-library-docs' to obtain a valid Context7-compatible library ID UNLESS the user explicitly provides a library ID in the format '/org/project' or '/org/project/version' in their query.\n\nSelection Process:\n1. Analyze the query to understand what library/package the user is looking for\n2. Return the most relevant match based on:\n- Name similarity to the query (exact matches prioritized)\n- Description relevance to the query's intent\n- Documentation coverage (prioritize libraries with higher Code Snippet counts)\n- Source reputation (consider libraries with High or Medium reputation more authoritative)\n- Benchmark Score: Quality indicator (100 is the highest score)\n\nResponse Format:\n- Return the selected library ID in a clearly marked section\n- Provide a brief explanation for why this library was chosen\n- If multiple good matches exist, acknowledge this but proceed with the most relevant one\n- If no good matches exist, clearly state this and suggest query refinements\n\nFor ambiguous queries, request clarification before proceeding with a best-guess match.")
	.usage("--library-name <library-name> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--library-name <library-name>", "Library name to search for and retrieve a Context7-compatible library ID.")
	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.libraryName !== undefined) args.libraryName = cmdOpts.libraryName;
			const call = (proxy.resolveLibraryId as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call context7.resolve-library-id(libraryName: \"value\")");

program
	.command("get-library-docs")
	.summary("get-library-docs --context7-compatible-library-i-d <context7-compatible-library-i-d> [--mode <mode:code|info>] [--topic <topic>] [--page <page>] [--raw <json>]")
	.description("Fetches up-to-date documentation for a library. You must call 'resolve-library-id' first to obtain the exact Context7-compatible library ID required to use this tool, UNLESS the user explicitly provides a library ID in the format '/org/project' or '/org/project/version' in their query. Use mode='code' (default) for API references and code examples, or mode='info' for conceptual guides, narrative information, and architectural questions.")
	.usage("--context7-compatible-library-i-d <context7-compatible-library-i-d> [--mode <mode:code|info>] [--topic <topic>] [--page <page>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--context7-compatible-library-i-d <context7-compatible-library-i-d>", "Exact Context7-compatible library ID (e.g., '/mongodb/docs', '/vercel/next.js', '/supabase/supabase', '/vercel/next.js/v14.3.0-canary.87') retrieved from 'resolve-library-id' or directly from user query in the format '/org/project' or '/org/project/version'. (example: example-id)")
	.option("--mode <mode:code|info>", "Documentation mode: 'code' for API references and code examples (default), 'info' for conceptual guides, narrative information, and architectural questions. (choices: code, info; default: code; example: code)")
	.option("--topic <topic>", "Topic to focus documentation on (e.g., 'hooks', 'routing').")
	.option("--page <page>", "Page number for pagination (start: 1, default: 1). If the context is not sufficient, try page=2, page=3, page=4, etc. with the same topic.")
	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.context7CompatibleLibraryID !== undefined) args.context7CompatibleLibraryID = cmdOpts.context7CompatibleLibraryID;
		if (cmdOpts.mode !== undefined) args.mode = cmdOpts.mode;
		if (cmdOpts.topic !== undefined) args.topic = cmdOpts.topic;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
			const call = (proxy.getLibraryDocs as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call context7.get-library-docs(context7CompatibleLibraryID: \"exam, ...)");

program
	.command('__mcporter_inspect', { hidden: true })
	.description('Internal metadata printer for mcporter inspect-cli.')
	.action(() => {
		const payload = buildMetadataPayload();
		console.log(JSON.stringify(payload, null, 2));
	});

configureToolCommandHelps();

const FORCE_COLOR = process.env.FORCE_COLOR?.toLowerCase();
const forceDisableColor = FORCE_COLOR === '0' || FORCE_COLOR === 'false';
const forceEnableColor = FORCE_COLOR === '1' || FORCE_COLOR === 'true' || FORCE_COLOR === '2' || FORCE_COLOR === '3';
const hasNoColor = process.env.NO_COLOR !== undefined;
const stdoutStream = process.stdout as NodeJS.WriteStream | undefined;
const supportsAnsiColor = !hasNoColor && (forceEnableColor || (!forceDisableColor && Boolean(stdoutStream?.isTTY)));

const tint = {
	bold(text: string): string {
		return supportsAnsiColor ? '[1m' + text + '[0m' : text;
	},
	dim(text: string): string {
		return supportsAnsiColor ? '[90m' + text + '[0m' : text;
	},
	extraDim(text: string): string {
		return supportsAnsiColor ? '[38;5;244m' + text + '[0m' : text;
	},
};

function configureGeneratedCommandHelp(command: Command): void {
	command.configureHelp({
		commandUsage(target) {
			const usage = (target.name() + ' ' + target.usage()).trim() || target.name();
			return supportsAnsiColor ? tint.bold(usage) : usage;
		},
		optionTerm(option) {
			const term = option.flags ?? '';
			return supportsAnsiColor ? tint.bold(term) : term;
		},
		optionDescription(option) {
			const description = option.description ?? '';
			return supportsAnsiColor ? tint.extraDim(description) : description;
		},
	});
}

function configureToolCommandHelps(): void {
	program.commands.forEach((cmd) => {
		if (cmd.name() === '__mcporter_inspect') {
			return;
		}
		configureGeneratedCommandHelp(cmd);
	});
}

function renderStandaloneHelp(): string {
	const colorfulTitle = tint.bold(embeddedName) + ' ' + tint.dim('— ' + embeddedDescription);
	const plainTitle = embeddedName + ' — ' + embeddedDescription;
	const title = supportsAnsiColor ? colorfulTitle : plainTitle;
	const lines = [title, '', 'Usage: ' + embeddedName + ' <command> [options]', ''];
	if (generatorTools) {
		lines.push(formatEmbeddedTools());
	}
	lines.push('', formatGlobalFlags(), '', formatQuickStart());
	if (generatorInfo) {
		lines.push('', tint.extraDim(generatorInfo));
	}
	return lines.join('\n');
}

program.helpInformation = () => renderStandaloneHelp();

function formatEmbeddedTools(): string {
	const header = supportsAnsiColor ? tint.bold('Embedded tools') : 'Embedded tools';
	if (!generatorTools.length) {
		return header;
	}
	const lines = [header];
	generatorTools.forEach((entry) => {
		const renderedDesc = entry.description
			? supportsAnsiColor
				? tint.extraDim(entry.description)
				: entry.description
			: undefined;
		const base = renderedDesc ? entry.name + ' - ' + renderedDesc : entry.name;
		lines.push('  ' + base);
		if (entry.flags) {
			const renderedFlags = supportsAnsiColor ? tint.extraDim(entry.flags) : entry.flags;
			lines.push('    ' + renderedFlags);
		}
		lines.push('');
	});
	if (lines[lines.length - 1] === '') {
		lines.pop();
	}
	return lines.join('\n');
}

function formatGlobalFlags(): string {
	const header = supportsAnsiColor ? tint.bold('Global flags') : 'Global flags';
	const entries = [
		['-t, --timeout <ms>', 'Call timeout in milliseconds'],
		['-o, --output <format>', 'text | markdown | json | raw (default text)'],
	];
	const formatted = entries.map(([flag, summary]) => '  ' + flag.padEnd(28) + summary);
	return [header, ...formatted].join('\n');
}

function formatQuickStart(): string {
  const header = supportsAnsiColor ? tint.bold('Quick start') : 'Quick start';
  const examples = quickStartExamples();
  if (!examples.length) {
    return header;
  }
  const formatted = examples.map(([cmd, note]) => '  ' + cmd + '\n    ' + tint.dim('# ' + note));
  return [header, ...formatted].join('\n');
}

function quickStartExamples(): Array<[string, string]> {
  const examples: Array<[string, string]> = [];
  const commandMap = new Map<string, string>();
  program.commands.forEach((cmd) => {
    const name = cmd.name();
    if (name !== '__mcporter_inspect') {
      commandMap.set(name, name);
    }
  });
  const embedded = Array.isArray(generatorTools) ? generatorTools : [];
  for (const entry of embedded.slice(0, 3)) {
    const commandName = commandMap.get(entry.name) ?? entry.name;
    const flags = entry.flags ? ' ' + entry.flags.replace(/<[^>]+>/g, '<value>') : '';
    examples.push([embeddedName + ' ' + commandName + flags, 'invoke ' + commandName]);
  }
  if (!examples.length) {
    examples.push([embeddedName + ' <tool> --key value', 'invoke a tool with flags']);
  }
  return examples;
}

function printResult(result: unknown, format: string) {
	const wrapped = createCallResult(result);
	switch (format) {
		case 'json': {
			const json = wrapped.json();
			if (json) {
				console.log(JSON.stringify(json, null, 2));
				return;
			}
			break;
		}
		case 'markdown': {
			const markdown = wrapped.markdown();
			if (markdown) {
				console.log(markdown);
				return;
			}
			break;
		}
		case 'raw': {
			console.log(JSON.stringify(wrapped.raw, null, 2));
			return;
		}
	}
	const text = wrapped.text();
	if (text) {
		console.log(text);
	} else {
		console.log(JSON.stringify(wrapped.raw, null, 2));
	}
}

function normalizeEmbeddedServer(server: typeof embeddedServer) {
	const base = { ...server } as Record<string, unknown>;
	if ((server.command as any).kind === 'http') {
		const urlRaw = (server.command as any).url;
		const urlValue = typeof urlRaw === 'string' ? urlRaw : String(urlRaw);
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				url: new URL(urlValue),
			},
		};
	}
	if ((server.command as any).kind === 'stdio') {
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				args: [ ...((server.command as any).args ?? []) ],
			},
		};
	}
	return base;
}

function determineArtifactKind(): 'template' | 'bundle' | 'binary' {
	const scriptPath = typeof process !== 'undefined' && Array.isArray(process.argv) ? process.argv[1] ?? '' : '';
	if (scriptPath.endsWith('.ts')) {
		return 'template';
	}
	if (scriptPath.endsWith('.js')) {
		return 'bundle';
	}
	return 'binary';
}

function resolveArtifactPath(): string {
	if (typeof process !== 'undefined' && Array.isArray(process.argv) && process.argv.length > 1) {
		const script = process.argv[1];
		if (script) {
			return script;
		}
	}
	return embeddedMetadata.artifact.path;
}

function buildMetadataPayload() {
	const invocation = { ...embeddedMetadata.invocation };
	const path = resolveArtifactPath();
	if (artifactKind === 'template' && path) {
		invocation.outputPath = invocation.outputPath ?? path;
	} else if (artifactKind === 'bundle' && path) {
		invocation.bundle = invocation.bundle ?? path;
	} else if (artifactKind === 'binary' && path) {
		invocation.compile = invocation.compile ?? path;
	}
	return {
		...embeddedMetadata,
		artifact: {
			path,
			kind: artifactKind,
		},
		invocation,
	};
}

async function ensureRuntime(): Promise<Awaited<ReturnType<typeof createRuntime>>> {
	return await createRuntime({
		servers: [normalizeEmbeddedServer(embeddedServer)],
	});
}

async function invokeWithTimeout<T>(call: Promise<T>, timeout: number): Promise<T> {
	if (!Number.isFinite(timeout) || timeout <= 0) {
		return await call;
	}
	let timer: ReturnType<typeof setTimeout> | undefined;
	try {
		return await Promise.race([
			call,
			new Promise<never>((_, reject) => {
				timer = setTimeout(() => {
					reject(new Error('Call timed out after ' + timeout + 'ms.'));
				}, timeout);
			}),
		]);
	} finally {
		if (timer) {
			clearTimeout(timer);
		}
	}
}

async function runCli(): Promise<void> {
	const args = process.argv.slice(2);
	if (args.length === 0) {
		program.outputHelp();
		return;
	}
	await program.parseAsync(process.argv);
}

if (process.env.MCPORTER_DISABLE_AUTORUN !== '1') {
	runCli().catch((error) => {
		const message = error instanceof Error ? error.message : String(error);
		console.error(message);
		process.exit(1);
	});
}
