#!/usr/bin/env bun
// @generated by mcporter@0.0.0 on 2025-11-27T04:18:09.007Z. DO NOT EDIT.
import { Command } from 'commander';
import { createRuntime, createServerProxy } from 'mcporter';
import { createCallResult } from 'mcporter';

const embeddedServer = {
  "name": "grep",
  "description": "mcp-typescript server on vercel",
  "command": {
    "kind": "http",
    "url": "https://mcp.grep.app/"
  }
} as const;
const embeddedSchemas = {
  "searchGitHub": {
    "type": "object",
    "properties": {
      "query": {
        "type": "string",
        "description": "The literal code pattern to search for (e.g., 'useState(', 'export function'). Use actual code that would appear in files, not keywords or questions."
      },
      "matchCase": {
        "type": "boolean",
        "description": "Whether the search should be case sensitive",
        "default": false
      },
      "matchWholeWords": {
        "type": "boolean",
        "description": "Whether to match whole words only",
        "default": false
      },
      "useRegexp": {
        "type": "boolean",
        "description": "Whether to interpret the query as a regular expression",
        "default": false
      },
      "repo": {
        "type": "string",
        "description": "Filter by repository.\n            Examples: 'facebook/react', 'microsoft/vscode', 'vercel/ai'.\n            Can match partial names, for example 'vercel/' will find repositories in the vercel org."
      },
      "path": {
        "type": "string",
        "description": "Filter by file path.\n            Examples: 'src/components/Button.tsx', 'README.md'.\n            Can match partial paths, for example '/route.ts' will find route.ts files at any level."
      },
      "language": {
        "type": "array",
        "items": {
          "type": "string"
        },
        "description": "Filter by programming language.\n            Examples: ['TypeScript', 'TSX'], ['JavaScript'], ['Python'], ['Java'], ['C#'], ['Markdown'], ['YAML']"
      }
    },
    "required": [
      "query"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  }
} as const;
const embeddedName = "grep";
const embeddedDescription = "mcp-typescript server on vercel";
const generatorInfo = "Generated by mcporter@0.0.0 — https://github.com/steipete/mcporter";
const generatorTools = [
  {
    "name": "searchGitHub",
    "description": "Find real-world code examples from over a million public GitHub repositories to help answer programming questions.\n\n**IMPORTANT: This tool searches for literal code patterns (like grep), not keywords. Search for actual code that would appear in files:**\n- ✅ Good: 'useState(', 'import React from', 'async function', '(?s)try {.*await'\n- ❌ Bad: 'react tutorial', 'best practices', 'how to use'\n\n**When to use this tool:**\n- When implementing unfamiliar APIs or libraries and need to see real usage patterns\n- When unsure about correct syntax, parameters, or configuration for a specific library\n- When looking for production-ready examples and best practices for implementation\n- When needing to understand how different libraries or frameworks work together\n\n**Perfect for questions like:**\n- \"How do developers handle authentication in Next.js apps?\" → Search: 'getServerSession' with language=['TypeScript', 'TSX']\n- \"What are common React error boundary patterns?\" → Search: 'ErrorBoundary' with language=['TSX']\n- \"Show me real useEffect cleanup examples\" → Search: '(?s)useEffect\\(\\(\\) => {.*removeEventListener' with useRegexp=true\n- \"How do developers handle CORS in Flask applications?\" → Search: 'CORS(' with matchCase=true and language=['Python']\n\nUse regular expressions with useRegexp=true for flexible patterns like '(?s)useState\\(.*loading' to find useState hooks with loading-related variables. Prefix the pattern with '(?s)' to match across multiple lines.\n\nFilter by language, repository, or file path to narrow results.",
    "usage": "searchGitHub --query <query> [--match-case <match-case:true|false>] [--match-whole-words <match-whole-words:true|false>] [--use-regexp <use-regexp:true|false>] [--repo <repo>] [--raw <json>]",
    "flags": "--query <query> [--match-case <match-case:true|false>] [--match-whole-words <match-whole-words:true|false>] [--use-regexp <use-regexp:true|false>] [--repo <repo>] [--raw <json>]"
  }
] as const;
const embeddedMetadata = {
  "schemaVersion": 1,
  "generatedAt": "2025-11-27T04:18:09.007Z",
  "generator": {
    "name": "mcporter",
    "version": "0.0.0"
  },
  "server": {
    "name": "grep",
    "definition": {
      "name": "grep",
      "description": "mcp-typescript server on vercel",
      "command": {
        "kind": "http",
        "url": "https://mcp.grep.app/"
      }
    }
  },
  "artifact": {
    "path": "",
    "kind": "template"
  },
  "invocation": {
    "serverRef": "{\"name\":\"grep\",\"command\":\"https://mcp.grep.app/\"}",
    "runtime": "bun",
    "bundler": "bun",
    "timeoutMs": 30000,
    "minify": false
  }
} as const;
const artifactKind = determineArtifactKind();
const program = new Command();
program.name(embeddedName);
program.description(embeddedDescription);
program.option('-t, --timeout <ms>', 'Call timeout in milliseconds', (value) => parseInt(value, 10), 30000);
program.option('-o, --output <format>', 'Output format: text|markdown|json|raw', 'text');
const commandSignatures: Record<string, string> = {
  "searchGitHub": "function searchGitHub(query: string, matchCase?: boolean, matchWholeWords?: boolean, useRegexp?: boolean, repo?: string);"
};
program.configureHelp({
	commandTerm(cmd) {
		const term = cmd.name();
		return commandSignatures[term] ?? cmd.name();
	},
});
program.showSuggestionAfterError(true);

program
	.command("searchGitHub")
	.summary("searchGitHub --query <query> [--match-case <match-case:true|false>] [--match-whole-words <match-whole-words:true|false>] [--use-regexp <use-regexp:true|false>] [--repo <repo>] [--raw <json>]")
	.description("Find real-world code examples from over a million public GitHub repositories to help answer programming questions.\n\n**IMPORTANT: This tool searches for literal code patterns (like grep), not keywords. Search for actual code that would appear in files:**\n- ✅ Good: 'useState(', 'import React from', 'async function', '(?s)try {.*await'\n- ❌ Bad: 'react tutorial', 'best practices', 'how to use'\n\n**When to use this tool:**\n- When implementing unfamiliar APIs or libraries and need to see real usage patterns\n- When unsure about correct syntax, parameters, or configuration for a specific library\n- When looking for production-ready examples and best practices for implementation\n- When needing to understand how different libraries or frameworks work together\n\n**Perfect for questions like:**\n- \"How do developers handle authentication in Next.js apps?\" → Search: 'getServerSession' with language=['TypeScript', 'TSX']\n- \"What are common React error boundary patterns?\" → Search: 'ErrorBoundary' with language=['TSX']\n- \"Show me real useEffect cleanup examples\" → Search: '(?s)useEffect\\(\\(\\) => {.*removeEventListener' with useRegexp=true\n- \"How do developers handle CORS in Flask applications?\" → Search: 'CORS(' with matchCase=true and language=['Python']\n\nUse regular expressions with useRegexp=true for flexible patterns like '(?s)useState\\(.*loading' to find useState hooks with loading-related variables. Prefix the pattern with '(?s)' to match across multiple lines.\n\nFilter by language, repository, or file path to narrow results.")
	.usage("--query <query> [--match-case <match-case:true|false>] [--match-whole-words <match-whole-words:true|false>] [--use-regexp <use-regexp:true|false>] [--repo <repo>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--query <query>", "The literal code pattern to search for (e.g., 'useState(', 'export function'). Use actual code that would appear in files, not keywords or questions.")
	.option("--match-case <match-case:true|false>", "Whether the search should be case sensitive (default: false; example: false)", (value) => value !== 'false')
	.option("--match-whole-words <match-whole-words:true|false>", "Whether to match whole words only (default: false; example: false)", (value) => value !== 'false')
	.option("--use-regexp <use-regexp:true|false>", "Whether to interpret the query as a regular expression (default: false; example: false)", (value) => value !== 'false')
	.option("--repo <repo>", "Filter by repository.\n            Examples: 'facebook/react', 'microsoft/vscode', 'vercel/ai'.\n            Can match partial names, for example 'vercel/' will find repositories in the vercel org.")
	.option("--path <path>", "Filter by file path.\n            Examples: 'src/components/Button.tsx', 'README.md'.\n            Can match partial paths, for example '/route.ts' will find route.ts files at any level. (example: /path/to/file.md)")
	.option("--language <language:value1,value2>", "Filter by programming language.\n            Examples: ['TypeScript', 'TSX'], ['JavaScript'], ['Python'], ['Java'], ['C#'], ['Markdown'], ['YAML'] (example: value1,value2)", (value) => value.split(','))
	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.query !== undefined) args.query = cmdOpts.query;
		if (cmdOpts.matchCase !== undefined) args.matchCase = cmdOpts.matchCase;
		if (cmdOpts.matchWholeWords !== undefined) args.matchWholeWords = cmdOpts.matchWholeWords;
		if (cmdOpts.useRegexp !== undefined) args.useRegexp = cmdOpts.useRegexp;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.path !== undefined) args.path = cmdOpts.path;
		if (cmdOpts.language !== undefined) args.language = cmdOpts.language;
			const call = (proxy.searchGitHub as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call grep.searchGitHub(query: \"value\", matchCase: false, matchWho, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (2): path, language" + '\n');

program
	.command('__mcporter_inspect', { hidden: true })
	.description('Internal metadata printer for mcporter inspect-cli.')
	.action(() => {
		const payload = buildMetadataPayload();
		console.log(JSON.stringify(payload, null, 2));
	});

configureToolCommandHelps();

const FORCE_COLOR = process.env.FORCE_COLOR?.toLowerCase();
const forceDisableColor = FORCE_COLOR === '0' || FORCE_COLOR === 'false';
const forceEnableColor = FORCE_COLOR === '1' || FORCE_COLOR === 'true' || FORCE_COLOR === '2' || FORCE_COLOR === '3';
const hasNoColor = process.env.NO_COLOR !== undefined;
const stdoutStream = process.stdout as NodeJS.WriteStream | undefined;
const supportsAnsiColor = !hasNoColor && (forceEnableColor || (!forceDisableColor && Boolean(stdoutStream?.isTTY)));

const tint = {
	bold(text: string): string {
		return supportsAnsiColor ? '[1m' + text + '[0m' : text;
	},
	dim(text: string): string {
		return supportsAnsiColor ? '[90m' + text + '[0m' : text;
	},
	extraDim(text: string): string {
		return supportsAnsiColor ? '[38;5;244m' + text + '[0m' : text;
	},
};

function configureGeneratedCommandHelp(command: Command): void {
	command.configureHelp({
		commandUsage(target) {
			const usage = (target.name() + ' ' + target.usage()).trim() || target.name();
			return supportsAnsiColor ? tint.bold(usage) : usage;
		},
		optionTerm(option) {
			const term = option.flags ?? '';
			return supportsAnsiColor ? tint.bold(term) : term;
		},
		optionDescription(option) {
			const description = option.description ?? '';
			return supportsAnsiColor ? tint.extraDim(description) : description;
		},
	});
}

function configureToolCommandHelps(): void {
	program.commands.forEach((cmd) => {
		if (cmd.name() === '__mcporter_inspect') {
			return;
		}
		configureGeneratedCommandHelp(cmd);
	});
}

function renderStandaloneHelp(): string {
	const colorfulTitle = tint.bold(embeddedName) + ' ' + tint.dim('— ' + embeddedDescription);
	const plainTitle = embeddedName + ' — ' + embeddedDescription;
	const title = supportsAnsiColor ? colorfulTitle : plainTitle;
	const lines = [title, '', 'Usage: ' + embeddedName + ' <command> [options]', ''];
	if (generatorTools) {
		lines.push(formatEmbeddedTools());
	}
	lines.push('', formatGlobalFlags(), '', formatQuickStart());
	if (generatorInfo) {
		lines.push('', tint.extraDim(generatorInfo));
	}
	return lines.join('\n');
}

program.helpInformation = () => renderStandaloneHelp();

function formatEmbeddedTools(): string {
	const header = supportsAnsiColor ? tint.bold('Embedded tools') : 'Embedded tools';
	if (!generatorTools.length) {
		return header;
	}
	const lines = [header];
	generatorTools.forEach((entry) => {
		const renderedDesc = entry.description
			? supportsAnsiColor
				? tint.extraDim(entry.description)
				: entry.description
			: undefined;
		const base = renderedDesc ? entry.name + ' - ' + renderedDesc : entry.name;
		lines.push('  ' + base);
		if (entry.flags) {
			const renderedFlags = supportsAnsiColor ? tint.extraDim(entry.flags) : entry.flags;
			lines.push('    ' + renderedFlags);
		}
		lines.push('');
	});
	if (lines[lines.length - 1] === '') {
		lines.pop();
	}
	return lines.join('\n');
}

function formatGlobalFlags(): string {
	const header = supportsAnsiColor ? tint.bold('Global flags') : 'Global flags';
	const entries = [
		['-t, --timeout <ms>', 'Call timeout in milliseconds'],
		['-o, --output <format>', 'text | markdown | json | raw (default text)'],
	];
	const formatted = entries.map(([flag, summary]) => '  ' + flag.padEnd(28) + summary);
	return [header, ...formatted].join('\n');
}

function formatQuickStart(): string {
  const header = supportsAnsiColor ? tint.bold('Quick start') : 'Quick start';
  const examples = quickStartExamples();
  if (!examples.length) {
    return header;
  }
  const formatted = examples.map(([cmd, note]) => '  ' + cmd + '\n    ' + tint.dim('# ' + note));
  return [header, ...formatted].join('\n');
}

function quickStartExamples(): Array<[string, string]> {
  const examples: Array<[string, string]> = [];
  const commandMap = new Map<string, string>();
  program.commands.forEach((cmd) => {
    const name = cmd.name();
    if (name !== '__mcporter_inspect') {
      commandMap.set(name, name);
    }
  });
  const embedded = Array.isArray(generatorTools) ? generatorTools : [];
  for (const entry of embedded.slice(0, 3)) {
    const commandName = commandMap.get(entry.name) ?? entry.name;
    const flags = entry.flags ? ' ' + entry.flags.replace(/<[^>]+>/g, '<value>') : '';
    examples.push([embeddedName + ' ' + commandName + flags, 'invoke ' + commandName]);
  }
  if (!examples.length) {
    examples.push([embeddedName + ' <tool> --key value', 'invoke a tool with flags']);
  }
  return examples;
}

function printResult(result: unknown, format: string) {
	const wrapped = createCallResult(result);
	switch (format) {
		case 'json': {
			const json = wrapped.json();
			if (json) {
				console.log(JSON.stringify(json, null, 2));
				return;
			}
			break;
		}
		case 'markdown': {
			const markdown = wrapped.markdown();
			if (markdown) {
				console.log(markdown);
				return;
			}
			break;
		}
		case 'raw': {
			console.log(JSON.stringify(wrapped.raw, null, 2));
			return;
		}
	}
	const text = wrapped.text();
	if (text) {
		console.log(text);
	} else {
		console.log(JSON.stringify(wrapped.raw, null, 2));
	}
}

function normalizeEmbeddedServer(server: typeof embeddedServer) {
	const base = { ...server } as Record<string, unknown>;
	if ((server.command as any).kind === 'http') {
		const urlRaw = (server.command as any).url;
		const urlValue = typeof urlRaw === 'string' ? urlRaw : String(urlRaw);
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				url: new URL(urlValue),
			},
		};
	}
	if ((server.command as any).kind === 'stdio') {
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				args: [ ...((server.command as any).args ?? []) ],
			},
		};
	}
	return base;
}

function determineArtifactKind(): 'template' | 'bundle' | 'binary' {
	const scriptPath = typeof process !== 'undefined' && Array.isArray(process.argv) ? process.argv[1] ?? '' : '';
	if (scriptPath.endsWith('.ts')) {
		return 'template';
	}
	if (scriptPath.endsWith('.js')) {
		return 'bundle';
	}
	return 'binary';
}

function resolveArtifactPath(): string {
	if (typeof process !== 'undefined' && Array.isArray(process.argv) && process.argv.length > 1) {
		const script = process.argv[1];
		if (script) {
			return script;
		}
	}
	return embeddedMetadata.artifact.path;
}

function buildMetadataPayload() {
	const invocation = { ...embeddedMetadata.invocation };
	const path = resolveArtifactPath();
	if (artifactKind === 'template' && path) {
		invocation.outputPath = invocation.outputPath ?? path;
	} else if (artifactKind === 'bundle' && path) {
		invocation.bundle = invocation.bundle ?? path;
	} else if (artifactKind === 'binary' && path) {
		invocation.compile = invocation.compile ?? path;
	}
	return {
		...embeddedMetadata,
		artifact: {
			path,
			kind: artifactKind,
		},
		invocation,
	};
}

async function ensureRuntime(): Promise<Awaited<ReturnType<typeof createRuntime>>> {
	return await createRuntime({
		servers: [normalizeEmbeddedServer(embeddedServer)],
	});
}

async function invokeWithTimeout<T>(call: Promise<T>, timeout: number): Promise<T> {
	if (!Number.isFinite(timeout) || timeout <= 0) {
		return await call;
	}
	let timer: ReturnType<typeof setTimeout> | undefined;
	try {
		return await Promise.race([
			call,
			new Promise<never>((_, reject) => {
				timer = setTimeout(() => {
					reject(new Error('Call timed out after ' + timeout + 'ms.'));
				}, timeout);
			}),
		]);
	} finally {
		if (timer) {
			clearTimeout(timer);
		}
	}
}

async function runCli(): Promise<void> {
	const args = process.argv.slice(2);
	if (args.length === 0) {
		program.outputHelp();
		return;
	}
	await program.parseAsync(process.argv);
}

if (process.env.MCPORTER_DISABLE_AUTORUN !== '1') {
	runCli().catch((error) => {
		const message = error instanceof Error ? error.message : String(error);
		console.error(message);
		process.exit(1);
	});
}
