#!/usr/bin/env bun
// @generated by mcporter@0.0.0 on 2025-11-27T05:28:40.283Z. DO NOT EDIT.
import { Command } from 'commander';
import { createRuntime, createServerProxy } from 'mcporter';
import { createCallResult } from 'mcporter';

const embeddedServer = {
  "name": "modelcontextprotocol-server-github",
  "command": {
    "kind": "stdio",
    "command": "npx",
    "args": [
      "-y",
      "@modelcontextprotocol/server-github"
    ]
  },
  "source": {
    "kind": "local",
    "path": "<adhoc>"
  },
  "description": "github-mcp-server"
} as const;
const embeddedSchemas = {
  "create_or_update_file": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "path": {
        "type": "string",
        "description": "Path where to create/update the file"
      },
      "content": {
        "type": "string",
        "description": "Content of the file"
      },
      "message": {
        "type": "string",
        "description": "Commit message"
      },
      "branch": {
        "type": "string",
        "description": "Branch to create/update the file in"
      },
      "sha": {
        "type": "string",
        "description": "SHA of the file being replaced (required when updating existing files)"
      }
    },
    "required": [
      "owner",
      "repo",
      "path",
      "content",
      "message",
      "branch"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "search_repositories": {
    "type": "object",
    "properties": {
      "query": {
        "type": "string",
        "description": "Search query (see GitHub search syntax)"
      },
      "page": {
        "type": "number",
        "description": "Page number for pagination (default: 1)"
      },
      "perPage": {
        "type": "number",
        "description": "Number of results per page (default: 30, max: 100)"
      }
    },
    "required": [
      "query"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "create_repository": {
    "type": "object",
    "properties": {
      "name": {
        "type": "string",
        "description": "Repository name"
      },
      "description": {
        "type": "string",
        "description": "Repository description"
      },
      "private": {
        "type": "boolean",
        "description": "Whether the repository should be private"
      },
      "autoInit": {
        "type": "boolean",
        "description": "Initialize with README.md"
      }
    },
    "required": [
      "name"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_file_contents": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "path": {
        "type": "string",
        "description": "Path to the file or directory"
      },
      "branch": {
        "type": "string",
        "description": "Branch to get contents from"
      }
    },
    "required": [
      "owner",
      "repo",
      "path"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "push_files": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "branch": {
        "type": "string",
        "description": "Branch to push to (e.g., 'main' or 'master')"
      },
      "files": {
        "type": "array",
        "items": {
          "type": "object",
          "properties": {
            "path": {
              "type": "string"
            },
            "content": {
              "type": "string"
            }
          },
          "required": [
            "path",
            "content"
          ],
          "additionalProperties": false
        },
        "description": "Array of files to push"
      },
      "message": {
        "type": "string",
        "description": "Commit message"
      }
    },
    "required": [
      "owner",
      "repo",
      "branch",
      "files",
      "message"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "create_issue": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "title": {
        "type": "string"
      },
      "body": {
        "type": "string"
      },
      "assignees": {
        "type": "array",
        "items": {
          "type": "string"
        }
      },
      "milestone": {
        "type": "number"
      },
      "labels": {
        "type": "array",
        "items": {
          "type": "string"
        }
      }
    },
    "required": [
      "owner",
      "repo",
      "title"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "create_pull_request": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "title": {
        "type": "string",
        "description": "Pull request title"
      },
      "body": {
        "type": "string",
        "description": "Pull request body/description"
      },
      "head": {
        "type": "string",
        "description": "The name of the branch where your changes are implemented"
      },
      "base": {
        "type": "string",
        "description": "The name of the branch you want the changes pulled into"
      },
      "draft": {
        "type": "boolean",
        "description": "Whether to create the pull request as a draft"
      },
      "maintainer_can_modify": {
        "type": "boolean",
        "description": "Whether maintainers can modify the pull request"
      }
    },
    "required": [
      "owner",
      "repo",
      "title",
      "head",
      "base"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "fork_repository": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "organization": {
        "type": "string",
        "description": "Optional: organization to fork to (defaults to your personal account)"
      }
    },
    "required": [
      "owner",
      "repo"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "create_branch": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "branch": {
        "type": "string",
        "description": "Name for the new branch"
      },
      "from_branch": {
        "type": "string",
        "description": "Optional: source branch to create from (defaults to the repository's default branch)"
      }
    },
    "required": [
      "owner",
      "repo",
      "branch"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "list_commits": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "sha": {
        "type": "string"
      },
      "page": {
        "type": "number"
      },
      "perPage": {
        "type": "number"
      }
    },
    "required": [
      "owner",
      "repo"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "list_issues": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "direction": {
        "type": "string",
        "enum": [
          "asc",
          "desc"
        ]
      },
      "labels": {
        "type": "array",
        "items": {
          "type": "string"
        }
      },
      "page": {
        "type": "number"
      },
      "per_page": {
        "type": "number"
      },
      "since": {
        "type": "string"
      },
      "sort": {
        "type": "string",
        "enum": [
          "created",
          "updated",
          "comments"
        ]
      },
      "state": {
        "type": "string",
        "enum": [
          "open",
          "closed",
          "all"
        ]
      }
    },
    "required": [
      "owner",
      "repo"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "update_issue": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "issue_number": {
        "type": "number"
      },
      "title": {
        "type": "string"
      },
      "body": {
        "type": "string"
      },
      "assignees": {
        "type": "array",
        "items": {
          "type": "string"
        }
      },
      "milestone": {
        "type": "number"
      },
      "labels": {
        "type": "array",
        "items": {
          "type": "string"
        }
      },
      "state": {
        "type": "string",
        "enum": [
          "open",
          "closed"
        ]
      }
    },
    "required": [
      "owner",
      "repo",
      "issue_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "add_issue_comment": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "issue_number": {
        "type": "number"
      },
      "body": {
        "type": "string"
      }
    },
    "required": [
      "owner",
      "repo",
      "issue_number",
      "body"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "search_code": {
    "type": "object",
    "properties": {
      "q": {
        "type": "string"
      },
      "order": {
        "type": "string",
        "enum": [
          "asc",
          "desc"
        ]
      },
      "page": {
        "type": "number",
        "minimum": 1
      },
      "per_page": {
        "type": "number",
        "minimum": 1,
        "maximum": 100
      }
    },
    "required": [
      "q"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "search_issues": {
    "type": "object",
    "properties": {
      "q": {
        "type": "string"
      },
      "order": {
        "type": "string",
        "enum": [
          "asc",
          "desc"
        ]
      },
      "page": {
        "type": "number",
        "minimum": 1
      },
      "per_page": {
        "type": "number",
        "minimum": 1,
        "maximum": 100
      },
      "sort": {
        "type": "string",
        "enum": [
          "comments",
          "reactions",
          "reactions-+1",
          "reactions--1",
          "reactions-smile",
          "reactions-thinking_face",
          "reactions-heart",
          "reactions-tada",
          "interactions",
          "created",
          "updated"
        ]
      }
    },
    "required": [
      "q"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "search_users": {
    "type": "object",
    "properties": {
      "q": {
        "type": "string"
      },
      "order": {
        "type": "string",
        "enum": [
          "asc",
          "desc"
        ]
      },
      "page": {
        "type": "number",
        "minimum": 1
      },
      "per_page": {
        "type": "number",
        "minimum": 1,
        "maximum": 100
      },
      "sort": {
        "type": "string",
        "enum": [
          "followers",
          "repositories",
          "joined"
        ]
      }
    },
    "required": [
      "q"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_issue": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string"
      },
      "repo": {
        "type": "string"
      },
      "issue_number": {
        "type": "number"
      }
    },
    "required": [
      "owner",
      "repo",
      "issue_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_pull_request": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "list_pull_requests": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "state": {
        "type": "string",
        "enum": [
          "open",
          "closed",
          "all"
        ],
        "description": "State of the pull requests to return"
      },
      "head": {
        "type": "string",
        "description": "Filter by head user or head organization and branch name"
      },
      "base": {
        "type": "string",
        "description": "Filter by base branch name"
      },
      "sort": {
        "type": "string",
        "enum": [
          "created",
          "updated",
          "popularity",
          "long-running"
        ],
        "description": "What to sort results by"
      },
      "direction": {
        "type": "string",
        "enum": [
          "asc",
          "desc"
        ],
        "description": "The direction of the sort"
      },
      "per_page": {
        "type": "number",
        "description": "Results per page (max 100)"
      },
      "page": {
        "type": "number",
        "description": "Page number of the results"
      }
    },
    "required": [
      "owner",
      "repo"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "create_pull_request_review": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      },
      "commit_id": {
        "type": "string",
        "description": "The SHA of the commit that needs a review"
      },
      "body": {
        "type": "string",
        "description": "The body text of the review"
      },
      "event": {
        "type": "string",
        "enum": [
          "APPROVE",
          "REQUEST_CHANGES",
          "COMMENT"
        ],
        "description": "The review action to perform"
      },
      "comments": {
        "type": "array",
        "items": {
          "anyOf": [
            {
              "type": "object",
              "properties": {
                "path": {
                  "type": "string",
                  "description": "The relative path to the file being commented on"
                },
                "position": {
                  "type": "number",
                  "description": "The position in the diff where you want to add a review comment"
                },
                "body": {
                  "type": "string",
                  "description": "Text of the review comment"
                }
              },
              "required": [
                "path",
                "position",
                "body"
              ],
              "additionalProperties": false
            },
            {
              "type": "object",
              "properties": {
                "path": {
                  "type": "string",
                  "description": "The relative path to the file being commented on"
                },
                "line": {
                  "type": "number",
                  "description": "The line number in the file where you want to add a review comment"
                },
                "body": {
                  "type": "string",
                  "description": "Text of the review comment"
                }
              },
              "required": [
                "path",
                "line",
                "body"
              ],
              "additionalProperties": false
            }
          ]
        },
        "description": "Comments to post as part of the review (specify either position or line, not both)"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number",
      "body",
      "event"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "merge_pull_request": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      },
      "commit_title": {
        "type": "string",
        "description": "Title for the automatic commit message"
      },
      "commit_message": {
        "type": "string",
        "description": "Extra detail to append to automatic commit message"
      },
      "merge_method": {
        "type": "string",
        "enum": [
          "merge",
          "squash",
          "rebase"
        ],
        "description": "Merge method to use"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_pull_request_files": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_pull_request_status": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "update_pull_request_branch": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      },
      "expected_head_sha": {
        "type": "string",
        "description": "The expected SHA of the pull request's HEAD ref"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_pull_request_comments": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  },
  "get_pull_request_reviews": {
    "type": "object",
    "properties": {
      "owner": {
        "type": "string",
        "description": "Repository owner (username or organization)"
      },
      "repo": {
        "type": "string",
        "description": "Repository name"
      },
      "pull_number": {
        "type": "number",
        "description": "Pull request number"
      }
    },
    "required": [
      "owner",
      "repo",
      "pull_number"
    ],
    "additionalProperties": false,
    "$schema": "http://json-schema.org/draft-07/schema#"
  }
} as const;
const embeddedName = "modelcontextprotocol-server-github";
const embeddedDescription = "github-mcp-server";
const generatorInfo = "Generated by mcporter@0.0.0 — https://github.com/steipete/mcporter";
const generatorTools = [
  {
    "name": "create-or-update-file",
    "description": "Create or update a single file in a GitHub repository",
    "usage": "create-or-update-file --owner <owner> --repo <repo> --path <path> --content <content> --message <message> --branch <branch> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --path <path> --content <content> --message <message> --branch <branch> [--raw <json>]"
  },
  {
    "name": "search-repositories",
    "description": "Search for GitHub repositories",
    "usage": "search-repositories --query <query> [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]",
    "flags": "--query <query> [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]"
  },
  {
    "name": "create-repository",
    "description": "Create a new GitHub repository in your account",
    "usage": "create-repository --name <name> [--description <description>] [--private <private:true|false>] [--auto-init <auto-init:true|false>] [--raw <json>]",
    "flags": "--name <name> [--description <description>] [--private <private:true|false>] [--auto-init <auto-init:true|false>] [--raw <json>]"
  },
  {
    "name": "get-file-contents",
    "description": "Get the contents of a file or directory from a GitHub repository",
    "usage": "get-file-contents --owner <owner> --repo <repo> --path <path> [--branch <branch>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --path <path> [--branch <branch>] [--raw <json>]"
  },
  {
    "name": "push-files",
    "description": "Push multiple files to a GitHub repository in a single commit",
    "usage": "push-files --owner <owner> --repo <repo> --branch <branch> --files <files:value1,value2> --message <message> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --branch <branch> --files <files:value1,value2> --message <message> [--raw <json>]"
  },
  {
    "name": "create-issue",
    "description": "Create a new issue in a GitHub repository",
    "usage": "create-issue --owner <owner> --repo <repo> --title <title> [--body <body>] [--assignees <assignees:value1,value2>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --title <title> [--body <body>] [--assignees <assignees:value1,value2>] [--raw <json>]"
  },
  {
    "name": "create-pull-request",
    "description": "Create a new pull request in a GitHub repository",
    "usage": "create-pull-request --owner <owner> --repo <repo> --title <title> --head <head> --base <base> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --title <title> --head <head> --base <base> [--raw <json>]"
  },
  {
    "name": "fork-repository",
    "description": "Fork a GitHub repository to your account or specified organization",
    "usage": "fork-repository --owner <owner> --repo <repo> [--organization <organization>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> [--organization <organization>] [--raw <json>]"
  },
  {
    "name": "create-branch",
    "description": "Create a new branch in a GitHub repository",
    "usage": "create-branch --owner <owner> --repo <repo> --branch <branch> [--from-branch <from-branch>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --branch <branch> [--from-branch <from-branch>] [--raw <json>]"
  },
  {
    "name": "list-commits",
    "description": "Get list of commits of a branch in a GitHub repository",
    "usage": "list-commits --owner <owner> --repo <repo> [--sha <sha>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> [--sha <sha>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]"
  },
  {
    "name": "list-issues",
    "description": "List issues in a GitHub repository with filtering options",
    "usage": "list-issues --owner <owner> --repo <repo> [--direction <direction:asc|desc>] [--labels <labels:value1,value2>] [--page <page:number>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> [--direction <direction:asc|desc>] [--labels <labels:value1,value2>] [--page <page:number>] [--raw <json>]"
  },
  {
    "name": "update-issue",
    "description": "Update an existing issue in a GitHub repository",
    "usage": "update-issue --owner <owner> --repo <repo> --issue-number <issue-number:number> [--title <title>] [--body <body>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --issue-number <issue-number:number> [--title <title>] [--body <body>] [--raw <json>]"
  },
  {
    "name": "add-issue-comment",
    "description": "Add a comment to an existing issue",
    "usage": "add-issue-comment --owner <owner> --repo <repo> --issue-number <issue-number:number> --body <body> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --issue-number <issue-number:number> --body <body> [--raw <json>]"
  },
  {
    "name": "search-code",
    "description": "Search for code across GitHub repositories",
    "usage": "search-code --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]",
    "flags": "--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]"
  },
  {
    "name": "search-issues",
    "description": "Search for issues and pull requests across GitHub repositories",
    "usage": "search-issues --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:comments|reactions|reactions-+1|reactions--1|reactions-smile|reactions-thinking_face|reactions-heart|reactions-tada|interactions|created|updated>] [--raw <json>]",
    "flags": "--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:comments|reactions|reactions-+1|reactions--1|reactions-smile|reactions-thinking_face|reactions-heart|reactions-tada|interactions|created|updated>] [--raw <json>]"
  },
  {
    "name": "search-users",
    "description": "Search for users on GitHub",
    "usage": "search-users --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:followers|repositories|joined>] [--raw <json>]",
    "flags": "--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:followers|repositories|joined>] [--raw <json>]"
  },
  {
    "name": "get-issue",
    "description": "Get details of a specific issue in a GitHub repository.",
    "usage": "get-issue --owner <owner> --repo <repo> --issue-number <issue-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --issue-number <issue-number:number> [--raw <json>]"
  },
  {
    "name": "get-pull-request",
    "description": "Get details of a specific pull request",
    "usage": "get-pull-request --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]"
  },
  {
    "name": "list-pull-requests",
    "description": "List and filter repository pull requests",
    "usage": "list-pull-requests --owner <owner> --repo <repo> [--state <state:open|closed|all>] [--head <head>] [--base <base>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> [--state <state:open|closed|all>] [--head <head>] [--base <base>] [--raw <json>]"
  },
  {
    "name": "create-pull-request-review",
    "description": "Create a review on a pull request",
    "usage": "create-pull-request-review --owner <owner> --repo <repo> --pull-number <pull-number:number> --body <body> --event <event:APPROVE|REQUEST_CHANGES|COMMENT> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> --body <body> --event <event:APPROVE|REQUEST_CHANGES|COMMENT> [--raw <json>]"
  },
  {
    "name": "merge-pull-request",
    "description": "Merge a pull request",
    "usage": "merge-pull-request --owner <owner> --repo <repo> --pull-number <pull-number:number> [--commit-title <commit-title>] [--commit-message <commit-message>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--commit-title <commit-title>] [--commit-message <commit-message>] [--raw <json>]"
  },
  {
    "name": "get-pull-request-files",
    "description": "Get the list of files changed in a pull request",
    "usage": "get-pull-request-files --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]"
  },
  {
    "name": "get-pull-request-status",
    "description": "Get the combined status of all status checks for a pull request",
    "usage": "get-pull-request-status --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]"
  },
  {
    "name": "update-pull-request-branch",
    "description": "Update a pull request branch with the latest changes from the base branch",
    "usage": "update-pull-request-branch --owner <owner> --repo <repo> --pull-number <pull-number:number> [--expected-head-sha <expected-head-sha>] [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--expected-head-sha <expected-head-sha>] [--raw <json>]"
  },
  {
    "name": "get-pull-request-comments",
    "description": "Get the review comments on a pull request",
    "usage": "get-pull-request-comments --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]"
  },
  {
    "name": "get-pull-request-reviews",
    "description": "Get the reviews on a pull request",
    "usage": "get-pull-request-reviews --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]",
    "flags": "--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]"
  }
] as const;
const embeddedMetadata = {
  "schemaVersion": 1,
  "generatedAt": "2025-11-27T05:28:40.283Z",
  "generator": {
    "name": "mcporter",
    "version": "0.0.0"
  },
  "server": {
    "name": "modelcontextprotocol-server-github",
    "source": {
      "kind": "local",
      "path": "<adhoc>"
    },
    "definition": {
      "name": "modelcontextprotocol-server-github",
      "description": "github-mcp-server",
      "command": {
        "kind": "stdio",
        "command": "npx",
        "args": [
          "-y",
          "@modelcontextprotocol/server-github"
        ]
      }
    }
  },
  "artifact": {
    "path": "",
    "kind": "template"
  },
  "invocation": {
    "serverRef": "{\"name\":\"modelcontextprotocol-server-github\",\"command\":{\"kind\":\"stdio\",\"command\":\"npx\",\"args\":[\"-y\",\"@modelcontextprotocol/server-github\"]},\"source\":{\"kind\":\"local\",\"path\":\"<adhoc>\"}}",
    "configPath": "<adhoc>",
    "runtime": "bun",
    "bundler": "bun",
    "timeoutMs": 30000,
    "minify": false
  }
} as const;
const artifactKind = determineArtifactKind();
const program = new Command();
program.name(embeddedName);
program.description(embeddedDescription);
program.option('-t, --timeout <ms>', 'Call timeout in milliseconds', (value) => parseInt(value, 10), 30000);
program.option('-o, --output <format>', 'Output format: text|markdown|json|raw', 'text');
const commandSignatures: Record<string, string> = {
  "create-or-update-file": "function create_or_update_file(owner: string, repo: string, path: string, content: string, message: string, branch: string);",
  "search-repositories": "function search_repositories(query: string, page?: number, perPage?: number);",
  "create-repository": "function create_repository(name: string, description?: string, private?: boolean, autoInit?: boolean);",
  "get-file-contents": "function get_file_contents(owner: string, repo: string, path: string, branch?: string);",
  "push-files": "function push_files(owner: string, repo: string, branch: string, files: string[], message: string);",
  "create-issue": "function create_issue(owner: string, repo: string, title: string, body?: string, assignees?: string[]);",
  "create-pull-request": "function create_pull_request(owner: string, repo: string, title: string, head: string, base: string);",
  "fork-repository": "function fork_repository(owner: string, repo: string, organization?: string);",
  "create-branch": "function create_branch(owner: string, repo: string, branch: string, from_branch?: string);",
  "list-commits": "function list_commits(owner: string, repo: string, sha?: string, page?: number, perPage?: number);",
  "list-issues": "function list_issues(owner: string, repo: string, direction?: \"asc\" | \"desc\", labels?: string[], page?: number);",
  "update-issue": "function update_issue(owner: string, repo: string, issue_number: number, title?: string, body?: string);",
  "add-issue-comment": "function add_issue_comment(owner: string, repo: string, issue_number: number, body: string);",
  "search-code": "function search_code(q: string, order?: \"asc\" | \"desc\", page?: number, per_page?: number);",
  "search-issues": "function search_issues(q: string, order?: \"asc\" | \"desc\", page?: number, per_page?: number, sort?: \"comments\" | \"reactions\" | \"reactions-+1\" | \"reactions--1\" | \"reactions-smile\" | \"reactions-thinking_face\" | \"reactions-heart\" | \"reactions-tada\" | \"interactions\" | \"created\" | \"updated\");",
  "search-users": "function search_users(q: string, order?: \"asc\" | \"desc\", page?: number, per_page?: number, sort?: \"followers\" | \"repositories\" | \"joined\");",
  "get-issue": "function get_issue(owner: string, repo: string, issue_number: number);",
  "get-pull-request": "function get_pull_request(owner: string, repo: string, pull_number: number);",
  "list-pull-requests": "function list_pull_requests(owner: string, repo: string, state?: \"open\" | \"closed\" | \"all\", head?: string, base?: string);",
  "create-pull-request-review": "function create_pull_request_review(owner: string, repo: string, pull_number: number, body: string, event: \"APPROVE\" | \"REQUEST_CHANGES\" | \"COMMENT\");",
  "merge-pull-request": "function merge_pull_request(owner: string, repo: string, pull_number: number, commit_title?: string, commit_message?: string);",
  "get-pull-request-files": "function get_pull_request_files(owner: string, repo: string, pull_number: number);",
  "get-pull-request-status": "function get_pull_request_status(owner: string, repo: string, pull_number: number);",
  "update-pull-request-branch": "function update_pull_request_branch(owner: string, repo: string, pull_number: number, expected_head_sha?: string);",
  "get-pull-request-comments": "function get_pull_request_comments(owner: string, repo: string, pull_number: number);",
  "get-pull-request-reviews": "function get_pull_request_reviews(owner: string, repo: string, pull_number: number);"
};
program.configureHelp({
	commandTerm(cmd) {
		const term = cmd.name();
		return commandSignatures[term] ?? cmd.name();
	},
});
program.showSuggestionAfterError(true);

program
	.command("create-or-update-file")
	.summary("create-or-update-file --owner <owner> --repo <repo> --path <path> --content <content> --message <message> --branch <branch> [--raw <json>]")
	.description("Create or update a single file in a GitHub repository")
	.usage("--owner <owner> --repo <repo> --path <path> --content <content> --message <message> --branch <branch> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--path <path>", "Path where to create/update the file (example: /path/to/file.md)")
	.requiredOption("--content <content>", "Content of the file")
	.requiredOption("--message <message>", "Commit message")
	.requiredOption("--branch <branch>", "Branch to create/update the file in")
	.option("--sha <sha>", "SHA of the file being replaced (required when updating existing files)")
	
	.alias("create_or_update_file")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.path !== undefined) args.path = cmdOpts.path;
		if (cmdOpts.content !== undefined) args.content = cmdOpts.content;
		if (cmdOpts.message !== undefined) args.message = cmdOpts.message;
		if (cmdOpts.branch !== undefined) args.branch = cmdOpts.branch;
		if (cmdOpts.sha !== undefined) args.sha = cmdOpts.sha;
			const call = (proxy.createOrUpdateFile as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_or_update_file(own, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (1): sha" + '\n');

program
	.command("search-repositories")
	.summary("search-repositories --query <query> [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.description("Search for GitHub repositories")
	.usage("--query <query> [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--query <query>", "Search query (see GitHub search syntax)")
	.option("--page <page:number>", "Page number for pagination (default: 1) (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Number of results per page (default: 30, max: 100) (example: 1)", (value) => parseFloat(value))
	
	.alias("search_repositories")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.query !== undefined) args.query = cmdOpts.query;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.perPage !== undefined) args.perPage = cmdOpts.perPage;
			const call = (proxy.searchRepositories as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.search_repositories(query, ...)");

program
	.command("create-repository")
	.summary("create-repository --name <name> [--description <description>] [--private <private:true|false>] [--auto-init <auto-init:true|false>] [--raw <json>]")
	.description("Create a new GitHub repository in your account")
	.usage("--name <name> [--description <description>] [--private <private:true|false>] [--auto-init <auto-init:true|false>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--name <name>", "Repository name")
	.option("--description <description>", "Repository description")
	.option("--private <private:true|false>", "Whether the repository should be private (example: true)", (value) => value !== 'false')
	.option("--auto-init <auto-init:true|false>", "Initialize with README.md (example: true)", (value) => value !== 'false')
	
	.alias("create_repository")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.name !== undefined) args.name = cmdOpts.name;
		if (cmdOpts.description !== undefined) args.description = cmdOpts.description;
		if (cmdOpts.private !== undefined) args.private = cmdOpts.private;
		if (cmdOpts.autoInit !== undefined) args.autoInit = cmdOpts.autoInit;
			const call = (proxy.createRepository as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_repository(name: \", ...)");

program
	.command("get-file-contents")
	.summary("get-file-contents --owner <owner> --repo <repo> --path <path> [--branch <branch>] [--raw <json>]")
	.description("Get the contents of a file or directory from a GitHub repository")
	.usage("--owner <owner> --repo <repo> --path <path> [--branch <branch>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--path <path>", "Path to the file or directory (example: /path/to/file.md)")
	.option("--branch <branch>", "Branch to get contents from")
	
	.alias("get_file_contents")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.path !== undefined) args.path = cmdOpts.path;
		if (cmdOpts.branch !== undefined) args.branch = cmdOpts.branch;
			const call = (proxy.getFileContents as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_file_contents(owner:, ...)");

program
	.command("push-files")
	.summary("push-files --owner <owner> --repo <repo> --branch <branch> --files <files:value1,value2> --message <message> [--raw <json>]")
	.description("Push multiple files to a GitHub repository in a single commit")
	.usage("--owner <owner> --repo <repo> --branch <branch> --files <files:value1,value2> --message <message> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--branch <branch>", "Branch to push to (e.g., 'main' or 'master')")
	.requiredOption("--files <files:value1,value2>", "Array of files to push (example: value1,value2)", (value) => value.split(','))
	.requiredOption("--message <message>", "Commit message")
	
	.alias("push_files")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.branch !== undefined) args.branch = cmdOpts.branch;
		if (cmdOpts.files !== undefined) args.files = cmdOpts.files;
		if (cmdOpts.message !== undefined) args.message = cmdOpts.message;
			const call = (proxy.pushFiles as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.push_files(owner: \"value\", ...)");

program
	.command("create-issue")
	.summary("create-issue --owner <owner> --repo <repo> --title <title> [--body <body>] [--assignees <assignees:value1,value2>] [--raw <json>]")
	.description("Create a new issue in a GitHub repository")
	.usage("--owner <owner> --repo <repo> --title <title> [--body <body>] [--assignees <assignees:value1,value2>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.requiredOption("--title <title>", "Set title.")
	.option("--body <body>", "Set body.")
	.option("--assignees <assignees:value1,value2>", "Set assignees. (example: value1,value2)", (value) => value.split(','))
	.option("--milestone <milestone:number>", "Set milestone. (example: 1)", (value) => parseFloat(value))
	.option("--labels <labels:value1,value2>", "Set labels. (example: value1,value2)", (value) => value.split(','))
	
	.alias("create_issue")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.title !== undefined) args.title = cmdOpts.title;
		if (cmdOpts.body !== undefined) args.body = cmdOpts.body;
		if (cmdOpts.assignees !== undefined) args.assignees = cmdOpts.assignees;
		if (cmdOpts.milestone !== undefined) args.milestone = cmdOpts.milestone;
		if (cmdOpts.labels !== undefined) args.labels = cmdOpts.labels;
			const call = (proxy.createIssue as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_issue(owner: \"valu, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (2): milestone, labels" + '\n');

program
	.command("create-pull-request")
	.summary("create-pull-request --owner <owner> --repo <repo> --title <title> --head <head> --base <base> [--raw <json>]")
	.description("Create a new pull request in a GitHub repository")
	.usage("--owner <owner> --repo <repo> --title <title> --head <head> --base <base> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--title <title>", "Pull request title")
	.option("--body <body>", "Pull request body/description")
	.requiredOption("--head <head>", "The name of the branch where your changes are implemented")
	.requiredOption("--base <base>", "The name of the branch you want the changes pulled into")
	.option("--draft <draft:true|false>", "Whether to create the pull request as a draft (example: true)", (value) => value !== 'false')
	.option("--maintainer-can-modify <maintainer-can-modify:true|false>", "Whether maintainers can modify the pull request (example: true)", (value) => value !== 'false')
	
	.alias("create_pull_request")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.title !== undefined) args.title = cmdOpts.title;
		if (cmdOpts.body !== undefined) args.body = cmdOpts.body;
		if (cmdOpts.head !== undefined) args.head = cmdOpts.head;
		if (cmdOpts.base !== undefined) args.base = cmdOpts.base;
		if (cmdOpts.draft !== undefined) args.draft = cmdOpts.draft;
		if (cmdOpts.maintainer_can_modify !== undefined) args.maintainer_can_modify = cmdOpts.maintainer_can_modify;
			const call = (proxy.createPullRequest as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_pull_request(owner, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (3): body, draft, maintainer_can_modify" + '\n');

program
	.command("fork-repository")
	.summary("fork-repository --owner <owner> --repo <repo> [--organization <organization>] [--raw <json>]")
	.description("Fork a GitHub repository to your account or specified organization")
	.usage("--owner <owner> --repo <repo> [--organization <organization>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.option("--organization <organization>", "Optional: organization to fork to (defaults to your personal account)")
	
	.alias("fork_repository")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.organization !== undefined) args.organization = cmdOpts.organization;
			const call = (proxy.forkRepository as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.fork_repository(owner: \"v, ...)");

program
	.command("create-branch")
	.summary("create-branch --owner <owner> --repo <repo> --branch <branch> [--from-branch <from-branch>] [--raw <json>]")
	.description("Create a new branch in a GitHub repository")
	.usage("--owner <owner> --repo <repo> --branch <branch> [--from-branch <from-branch>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--branch <branch>", "Name for the new branch")
	.option("--from-branch <from-branch>", "Optional: source branch to create from (defaults to the repository's default branch)")
	
	.alias("create_branch")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.branch !== undefined) args.branch = cmdOpts.branch;
		if (cmdOpts.from_branch !== undefined) args.from_branch = cmdOpts.from_branch;
			const call = (proxy.createBranch as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_branch(owner: \"val, ...)");

program
	.command("list-commits")
	.summary("list-commits --owner <owner> --repo <repo> [--sha <sha>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.description("Get list of commits of a branch in a GitHub repository")
	.usage("--owner <owner> --repo <repo> [--sha <sha>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.option("--sha <sha>", "Set sha.")
	.option("--page <page:number>", "Set page. (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Set perPage. (example: 1)", (value) => parseFloat(value))
	
	.alias("list_commits")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.sha !== undefined) args.sha = cmdOpts.sha;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.perPage !== undefined) args.perPage = cmdOpts.perPage;
			const call = (proxy.listCommits as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.list_commits(owner: \"valu, ...)");

program
	.command("list-issues")
	.summary("list-issues --owner <owner> --repo <repo> [--direction <direction:asc|desc>] [--labels <labels:value1,value2>] [--page <page:number>] [--raw <json>]")
	.description("List issues in a GitHub repository with filtering options")
	.usage("--owner <owner> --repo <repo> [--direction <direction:asc|desc>] [--labels <labels:value1,value2>] [--page <page:number>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.option("--direction <direction:asc|desc>", "Set direction. (choices: asc, desc; example: asc)")
	.option("--labels <labels:value1,value2>", "Set labels. (example: value1,value2)", (value) => value.split(','))
	.option("--page <page:number>", "Set page. (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Set per_page. (example: 1)", (value) => parseFloat(value))
	.option("--since <since>", "Set since.")
	.option("--sort <sort:created|updated|comments>", "Set sort. (choices: created, updated, comments; example: created)")
	.option("--state <state:open|closed|all>", "Set state. (choices: open, closed, all; example: open)")
	
	.alias("list_issues")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.direction !== undefined) args.direction = cmdOpts.direction;
		if (cmdOpts.labels !== undefined) args.labels = cmdOpts.labels;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.per_page !== undefined) args.per_page = cmdOpts.per_page;
		if (cmdOpts.since !== undefined) args.since = cmdOpts.since;
		if (cmdOpts.sort !== undefined) args.sort = cmdOpts.sort;
		if (cmdOpts.state !== undefined) args.state = cmdOpts.state;
			const call = (proxy.listIssues as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.list_issues(owner: \"value, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (4): per_page, since, sort, state" + '\n');

program
	.command("update-issue")
	.summary("update-issue --owner <owner> --repo <repo> --issue-number <issue-number:number> [--title <title>] [--body <body>] [--raw <json>]")
	.description("Update an existing issue in a GitHub repository")
	.usage("--owner <owner> --repo <repo> --issue-number <issue-number:number> [--title <title>] [--body <body>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.requiredOption("--issue-number <issue-number:number>", "Set issue_number. (example: 1)", (value) => parseFloat(value))
	.option("--title <title>", "Set title.")
	.option("--body <body>", "Set body.")
	.option("--assignees <assignees:value1,value2>", "Set assignees. (example: value1,value2)", (value) => value.split(','))
	.option("--milestone <milestone:number>", "Set milestone. (example: 1)", (value) => parseFloat(value))
	.option("--labels <labels:value1,value2>", "Set labels. (example: value1,value2)", (value) => value.split(','))
	.option("--state <state:open|closed>", "Set state. (choices: open, closed; example: open)")
	
	.alias("update_issue")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.issue_number !== undefined) args.issue_number = cmdOpts.issue_number;
		if (cmdOpts.title !== undefined) args.title = cmdOpts.title;
		if (cmdOpts.body !== undefined) args.body = cmdOpts.body;
		if (cmdOpts.assignees !== undefined) args.assignees = cmdOpts.assignees;
		if (cmdOpts.milestone !== undefined) args.milestone = cmdOpts.milestone;
		if (cmdOpts.labels !== undefined) args.labels = cmdOpts.labels;
		if (cmdOpts.state !== undefined) args.state = cmdOpts.state;
			const call = (proxy.updateIssue as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.update_issue(owner: \"valu, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (4): assignees, milestone, labels, state" + '\n');

program
	.command("add-issue-comment")
	.summary("add-issue-comment --owner <owner> --repo <repo> --issue-number <issue-number:number> --body <body> [--raw <json>]")
	.description("Add a comment to an existing issue")
	.usage("--owner <owner> --repo <repo> --issue-number <issue-number:number> --body <body> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.requiredOption("--issue-number <issue-number:number>", "Set issue_number. (example: 1)", (value) => parseFloat(value))
	.requiredOption("--body <body>", "Set body.")
	
	.alias("add_issue_comment")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.issue_number !== undefined) args.issue_number = cmdOpts.issue_number;
		if (cmdOpts.body !== undefined) args.body = cmdOpts.body;
			const call = (proxy.addIssueComment as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.add_issue_comment(owner:, ...)");

program
	.command("search-code")
	.summary("search-code --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.description("Search for code across GitHub repositories")
	.usage("--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--q <q>", "Set q.")
	.option("--order <order:asc|desc>", "Set order. (choices: asc, desc; example: asc)")
	.option("--page <page:number>", "Set page. (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Set per_page. (example: 1)", (value) => parseFloat(value))
	
	.alias("search_code")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.q !== undefined) args.q = cmdOpts.q;
		if (cmdOpts.order !== undefined) args.order = cmdOpts.order;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.per_page !== undefined) args.per_page = cmdOpts.per_page;
			const call = (proxy.searchCode as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.search_code(q: \"value\", o, ...)");

program
	.command("search-issues")
	.summary("search-issues --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:comments|reactions|reactions-+1|reactions--1|reactions-smile|reactions-thinking_face|reactions-heart|reactions-tada|interactions|created|updated>] [--raw <json>]")
	.description("Search for issues and pull requests across GitHub repositories")
	.usage("--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:comments|reactions|reactions-+1|reactions--1|reactions-smile|reactions-thinking_face|reactions-heart|reactions-tada|interactions|created|updated>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--q <q>", "Set q.")
	.option("--order <order:asc|desc>", "Set order. (choices: asc, desc; example: asc)")
	.option("--page <page:number>", "Set page. (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Set per_page. (example: 1)", (value) => parseFloat(value))
	.option("--sort <sort:comments|reactions|reactions-+1|reactions--1|reactions-smile|reactions-thinking_face|reactions-heart|reactions-tada|interactions|created|updated>", "Set sort. (choices: comments, reactions, reactions-+1, reactions--1, reactions-smile, reactions-thinking_face, reactions-heart, reactions-tada, interactions, created, updated; example: comments)")
	
	.alias("search_issues")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.q !== undefined) args.q = cmdOpts.q;
		if (cmdOpts.order !== undefined) args.order = cmdOpts.order;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.per_page !== undefined) args.per_page = cmdOpts.per_page;
		if (cmdOpts.sort !== undefined) args.sort = cmdOpts.sort;
			const call = (proxy.searchIssues as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.search_issues(q: \"value\", ...)");

program
	.command("search-users")
	.summary("search-users --q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:followers|repositories|joined>] [--raw <json>]")
	.description("Search for users on GitHub")
	.usage("--q <q> [--order <order:asc|desc>] [--page <page:number>] [--per-page <per-page:number>] [--sort <sort:followers|repositories|joined>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--q <q>", "Set q.")
	.option("--order <order:asc|desc>", "Set order. (choices: asc, desc; example: asc)")
	.option("--page <page:number>", "Set page. (example: 1)", (value) => parseFloat(value))
	.option("--per-page <per-page:number>", "Set per_page. (example: 1)", (value) => parseFloat(value))
	.option("--sort <sort:followers|repositories|joined>", "Set sort. (choices: followers, repositories, joined; example: followers)")
	
	.alias("search_users")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.q !== undefined) args.q = cmdOpts.q;
		if (cmdOpts.order !== undefined) args.order = cmdOpts.order;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.per_page !== undefined) args.per_page = cmdOpts.per_page;
		if (cmdOpts.sort !== undefined) args.sort = cmdOpts.sort;
			const call = (proxy.searchUsers as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.search_users(q: \"value\", ...)");

program
	.command("get-issue")
	.summary("get-issue --owner <owner> --repo <repo> --issue-number <issue-number:number> [--raw <json>]")
	.description("Get details of a specific issue in a GitHub repository.")
	.usage("--owner <owner> --repo <repo> --issue-number <issue-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Set owner.")
	.requiredOption("--repo <repo>", "Set repo.")
	.requiredOption("--issue-number <issue-number:number>", "Set issue_number. (example: 1)", (value) => parseFloat(value))
	
	.alias("get_issue")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.issue_number !== undefined) args.issue_number = cmdOpts.issue_number;
			const call = (proxy.getIssue as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_issue(owner: \"value\", ...)");

program
	.command("get-pull-request")
	.summary("get-pull-request --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.description("Get details of a specific pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	
	.alias("get_pull_request")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
			const call = (proxy.getPullRequest as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_pull_request(owner: \", ...)");

program
	.command("list-pull-requests")
	.summary("list-pull-requests --owner <owner> --repo <repo> [--state <state:open|closed|all>] [--head <head>] [--base <base>] [--raw <json>]")
	.description("List and filter repository pull requests")
	.usage("--owner <owner> --repo <repo> [--state <state:open|closed|all>] [--head <head>] [--base <base>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.option("--state <state:open|closed|all>", "State of the pull requests to return (choices: open, closed, all; example: open)")
	.option("--head <head>", "Filter by head user or head organization and branch name")
	.option("--base <base>", "Filter by base branch name")
	.option("--sort <sort:created|updated|popularity|long-running>", "What to sort results by (choices: created, updated, popularity, long-running; example: created)")
	.option("--direction <direction:asc|desc>", "The direction of the sort (choices: asc, desc; example: asc)")
	.option("--per-page <per-page:number>", "Results per page (max 100) (example: 1)", (value) => parseFloat(value))
	.option("--page <page:number>", "Page number of the results (example: 1)", (value) => parseFloat(value))
	
	.alias("list_pull_requests")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.state !== undefined) args.state = cmdOpts.state;
		if (cmdOpts.head !== undefined) args.head = cmdOpts.head;
		if (cmdOpts.base !== undefined) args.base = cmdOpts.base;
		if (cmdOpts.sort !== undefined) args.sort = cmdOpts.sort;
		if (cmdOpts.direction !== undefined) args.direction = cmdOpts.direction;
		if (cmdOpts.per_page !== undefined) args.per_page = cmdOpts.per_page;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
			const call = (proxy.listPullRequests as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.list_pull_requests(owner:, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (4): sort, direction, per_page, page" + '\n');

program
	.command("create-pull-request-review")
	.summary("create-pull-request-review --owner <owner> --repo <repo> --pull-number <pull-number:number> --body <body> --event <event:APPROVE|REQUEST_CHANGES|COMMENT> [--raw <json>]")
	.description("Create a review on a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> --body <body> --event <event:APPROVE|REQUEST_CHANGES|COMMENT> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	.option("--commit-id <commit-id>", "The SHA of the commit that needs a review (example: example-id)")
	.requiredOption("--body <body>", "The body text of the review")
	.requiredOption("--event <event:APPROVE|REQUEST_CHANGES|COMMENT>", "The review action to perform (choices: APPROVE, REQUEST_CHANGES, COMMENT; example: APPROVE)")
	.option("--comments <comments:value1,value2>", "Comments to post as part of the review (specify either position or line, not both) (example: value1,value2)", (value) => value.split(','))
	
	.alias("create_pull_request_review")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
		if (cmdOpts.commit_id !== undefined) args.commit_id = cmdOpts.commit_id;
		if (cmdOpts.body !== undefined) args.body = cmdOpts.body;
		if (cmdOpts.event !== undefined) args.event = cmdOpts.event;
		if (cmdOpts.comments !== undefined) args.comments = cmdOpts.comments;
			const call = (proxy.createPullRequestReview as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.create_pull_request_review(...)")
	.addHelpText('afterAll', () => '\n' + "// optional (2): commit_id, comments" + '\n');

program
	.command("merge-pull-request")
	.summary("merge-pull-request --owner <owner> --repo <repo> --pull-number <pull-number:number> [--commit-title <commit-title>] [--commit-message <commit-message>] [--raw <json>]")
	.description("Merge a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--commit-title <commit-title>] [--commit-message <commit-message>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	.option("--commit-title <commit-title>", "Title for the automatic commit message")
	.option("--commit-message <commit-message>", "Extra detail to append to automatic commit message")
	.option("--merge-method <merge-method:merge|squash|rebase>", "Merge method to use (choices: merge, squash, rebase; example: merge)")
	
	.alias("merge_pull_request")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
		if (cmdOpts.commit_title !== undefined) args.commit_title = cmdOpts.commit_title;
		if (cmdOpts.commit_message !== undefined) args.commit_message = cmdOpts.commit_message;
		if (cmdOpts.merge_method !== undefined) args.merge_method = cmdOpts.merge_method;
			const call = (proxy.mergePullRequest as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.merge_pull_request(owner:, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (1): merge_method" + '\n');

program
	.command("get-pull-request-files")
	.summary("get-pull-request-files --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.description("Get the list of files changed in a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	
	.alias("get_pull_request_files")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
			const call = (proxy.getPullRequestFiles as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_pull_request_files(ow, ...)");

program
	.command("get-pull-request-status")
	.summary("get-pull-request-status --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.description("Get the combined status of all status checks for a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	
	.alias("get_pull_request_status")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
			const call = (proxy.getPullRequestStatus as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_pull_request_status(o, ...)");

program
	.command("update-pull-request-branch")
	.summary("update-pull-request-branch --owner <owner> --repo <repo> --pull-number <pull-number:number> [--expected-head-sha <expected-head-sha>] [--raw <json>]")
	.description("Update a pull request branch with the latest changes from the base branch")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--expected-head-sha <expected-head-sha>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	.option("--expected-head-sha <expected-head-sha>", "The expected SHA of the pull request's HEAD ref")
	
	.alias("update_pull_request_branch")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
		if (cmdOpts.expected_head_sha !== undefined) args.expected_head_sha = cmdOpts.expected_head_sha;
			const call = (proxy.updatePullRequestBranch as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.update_pull_request_branch(...)");

program
	.command("get-pull-request-comments")
	.summary("get-pull-request-comments --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.description("Get the review comments on a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	
	.alias("get_pull_request_comments")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
			const call = (proxy.getPullRequestComments as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_pull_request_comments(...)");

program
	.command("get-pull-request-reviews")
	.summary("get-pull-request-reviews --owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.description("Get the reviews on a pull request")
	.usage("--owner <owner> --repo <repo> --pull-number <pull-number:number> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--owner <owner>", "Repository owner (username or organization)")
	.requiredOption("--repo <repo>", "Repository name")
	.requiredOption("--pull-number <pull-number:number>", "Pull request number (example: 1)", (value) => parseFloat(value))
	
	.alias("get_pull_request_reviews")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.owner !== undefined) args.owner = cmdOpts.owner;
		if (cmdOpts.repo !== undefined) args.repo = cmdOpts.repo;
		if (cmdOpts.pull_number !== undefined) args.pull_number = cmdOpts.pull_number;
			const call = (proxy.getPullRequestReviews as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-github.get_pull_request_reviews(...)");

program
	.command('__mcporter_inspect', { hidden: true })
	.description('Internal metadata printer for mcporter inspect-cli.')
	.action(() => {
		const payload = buildMetadataPayload();
		console.log(JSON.stringify(payload, null, 2));
	});

configureToolCommandHelps();

const FORCE_COLOR = process.env.FORCE_COLOR?.toLowerCase();
const forceDisableColor = FORCE_COLOR === '0' || FORCE_COLOR === 'false';
const forceEnableColor = FORCE_COLOR === '1' || FORCE_COLOR === 'true' || FORCE_COLOR === '2' || FORCE_COLOR === '3';
const hasNoColor = process.env.NO_COLOR !== undefined;
const stdoutStream = process.stdout as NodeJS.WriteStream | undefined;
const supportsAnsiColor = !hasNoColor && (forceEnableColor || (!forceDisableColor && Boolean(stdoutStream?.isTTY)));

const tint = {
	bold(text: string): string {
		return supportsAnsiColor ? '[1m' + text + '[0m' : text;
	},
	dim(text: string): string {
		return supportsAnsiColor ? '[90m' + text + '[0m' : text;
	},
	extraDim(text: string): string {
		return supportsAnsiColor ? '[38;5;244m' + text + '[0m' : text;
	},
};

function configureGeneratedCommandHelp(command: Command): void {
	command.configureHelp({
		commandUsage(target) {
			const usage = (target.name() + ' ' + target.usage()).trim() || target.name();
			return supportsAnsiColor ? tint.bold(usage) : usage;
		},
		optionTerm(option) {
			const term = option.flags ?? '';
			return supportsAnsiColor ? tint.bold(term) : term;
		},
		optionDescription(option) {
			const description = option.description ?? '';
			return supportsAnsiColor ? tint.extraDim(description) : description;
		},
	});
}

function configureToolCommandHelps(): void {
	program.commands.forEach((cmd) => {
		if (cmd.name() === '__mcporter_inspect') {
			return;
		}
		configureGeneratedCommandHelp(cmd);
	});
}

function renderStandaloneHelp(): string {
	const colorfulTitle = tint.bold(embeddedName) + ' ' + tint.dim('— ' + embeddedDescription);
	const plainTitle = embeddedName + ' — ' + embeddedDescription;
	const title = supportsAnsiColor ? colorfulTitle : plainTitle;
	const lines = [title, '', 'Usage: ' + embeddedName + ' <command> [options]', ''];
	if (generatorTools) {
		lines.push(formatEmbeddedTools());
	}
	lines.push('', formatGlobalFlags(), '', formatQuickStart());
	if (generatorInfo) {
		lines.push('', tint.extraDim(generatorInfo));
	}
	return lines.join('\n');
}

program.helpInformation = () => renderStandaloneHelp();

function formatEmbeddedTools(): string {
	const header = supportsAnsiColor ? tint.bold('Embedded tools') : 'Embedded tools';
	if (!generatorTools.length) {
		return header;
	}
	const lines = [header];
	generatorTools.forEach((entry) => {
		const renderedDesc = entry.description
			? supportsAnsiColor
				? tint.extraDim(entry.description)
				: entry.description
			: undefined;
		const base = renderedDesc ? entry.name + ' - ' + renderedDesc : entry.name;
		lines.push('  ' + base);
		if (entry.flags) {
			const renderedFlags = supportsAnsiColor ? tint.extraDim(entry.flags) : entry.flags;
			lines.push('    ' + renderedFlags);
		}
		lines.push('');
	});
	if (lines[lines.length - 1] === '') {
		lines.pop();
	}
	return lines.join('\n');
}

function formatGlobalFlags(): string {
	const header = supportsAnsiColor ? tint.bold('Global flags') : 'Global flags';
	const entries = [
		['-t, --timeout <ms>', 'Call timeout in milliseconds'],
		['-o, --output <format>', 'text | markdown | json | raw (default text)'],
	];
	const formatted = entries.map(([flag, summary]) => '  ' + flag.padEnd(28) + summary);
	return [header, ...formatted].join('\n');
}

function formatQuickStart(): string {
  const header = supportsAnsiColor ? tint.bold('Quick start') : 'Quick start';
  const examples = quickStartExamples();
  if (!examples.length) {
    return header;
  }
  const formatted = examples.map(([cmd, note]) => '  ' + cmd + '\n    ' + tint.dim('# ' + note));
  return [header, ...formatted].join('\n');
}

function quickStartExamples(): Array<[string, string]> {
  const examples: Array<[string, string]> = [];
  const commandMap = new Map<string, string>();
  program.commands.forEach((cmd) => {
    const name = cmd.name();
    if (name !== '__mcporter_inspect') {
      commandMap.set(name, name);
    }
  });
  const embedded = Array.isArray(generatorTools) ? generatorTools : [];
  for (const entry of embedded.slice(0, 3)) {
    const commandName = commandMap.get(entry.name) ?? entry.name;
    const flags = entry.flags ? ' ' + entry.flags.replace(/<[^>]+>/g, '<value>') : '';
    examples.push([embeddedName + ' ' + commandName + flags, 'invoke ' + commandName]);
  }
  if (!examples.length) {
    examples.push([embeddedName + ' <tool> --key value', 'invoke a tool with flags']);
  }
  return examples;
}

function printResult(result: unknown, format: string) {
	const wrapped = createCallResult(result);
	switch (format) {
		case 'json': {
			const json = wrapped.json();
			if (json) {
				console.log(JSON.stringify(json, null, 2));
				return;
			}
			break;
		}
		case 'markdown': {
			const markdown = wrapped.markdown();
			if (markdown) {
				console.log(markdown);
				return;
			}
			break;
		}
		case 'raw': {
			console.log(JSON.stringify(wrapped.raw, null, 2));
			return;
		}
	}
	const text = wrapped.text();
	if (text) {
		console.log(text);
	} else {
		console.log(JSON.stringify(wrapped.raw, null, 2));
	}
}

function normalizeEmbeddedServer(server: typeof embeddedServer) {
	const base = { ...server } as Record<string, unknown>;
	if ((server.command as any).kind === 'http') {
		const urlRaw = (server.command as any).url;
		const urlValue = typeof urlRaw === 'string' ? urlRaw : String(urlRaw);
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				url: new URL(urlValue),
			},
		};
	}
	if ((server.command as any).kind === 'stdio') {
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				args: [ ...((server.command as any).args ?? []) ],
			},
		};
	}
	return base;
}

function determineArtifactKind(): 'template' | 'bundle' | 'binary' {
	const scriptPath = typeof process !== 'undefined' && Array.isArray(process.argv) ? process.argv[1] ?? '' : '';
	if (scriptPath.endsWith('.ts')) {
		return 'template';
	}
	if (scriptPath.endsWith('.js')) {
		return 'bundle';
	}
	return 'binary';
}

function resolveArtifactPath(): string {
	if (typeof process !== 'undefined' && Array.isArray(process.argv) && process.argv.length > 1) {
		const script = process.argv[1];
		if (script) {
			return script;
		}
	}
	return embeddedMetadata.artifact.path;
}

function buildMetadataPayload() {
	const invocation = { ...embeddedMetadata.invocation };
	const path = resolveArtifactPath();
	if (artifactKind === 'template' && path) {
		invocation.outputPath = invocation.outputPath ?? path;
	} else if (artifactKind === 'bundle' && path) {
		invocation.bundle = invocation.bundle ?? path;
	} else if (artifactKind === 'binary' && path) {
		invocation.compile = invocation.compile ?? path;
	}
	return {
		...embeddedMetadata,
		artifact: {
			path,
			kind: artifactKind,
		},
		invocation,
	};
}

async function ensureRuntime(): Promise<Awaited<ReturnType<typeof createRuntime>>> {
	return await createRuntime({
		servers: [normalizeEmbeddedServer(embeddedServer)],
	});
}

async function invokeWithTimeout<T>(call: Promise<T>, timeout: number): Promise<T> {
	if (!Number.isFinite(timeout) || timeout <= 0) {
		return await call;
	}
	let timer: ReturnType<typeof setTimeout> | undefined;
	try {
		return await Promise.race([
			call,
			new Promise<never>((_, reject) => {
				timer = setTimeout(() => {
					reject(new Error('Call timed out after ' + timeout + 'ms.'));
				}, timeout);
			}),
		]);
	} finally {
		if (timer) {
			clearTimeout(timer);
		}
	}
}

async function runCli(): Promise<void> {
	const args = process.argv.slice(2);
	if (args.length === 0) {
		program.outputHelp();
		return;
	}
	await program.parseAsync(process.argv);
}

if (process.env.MCPORTER_DISABLE_AUTORUN !== '1') {
	runCli().catch((error) => {
		const message = error instanceof Error ? error.message : String(error);
		console.error(message);
		process.exit(1);
	});
}
