#!/usr/bin/env bun
// @generated by mcporter@0.0.0 on 2025-11-27T09:09:04.861Z. DO NOT EDIT.
import { Command } from 'commander';
import { createRuntime, createServerProxy } from 'mcporter';
import { createCallResult } from 'mcporter';

const embeddedServer = {
  "name": "127",
  "description": "rmcp",
  "command": {
    "kind": "http",
    "url": "http://127.0.0.1:27495/mcp"
  }
} as const;
const embeddedSchemas = {
  "import_usage": {
    "type": "object",
    "properties": {
      "packages": {
        "items": {
          "additionalProperties": false,
          "properties": {
            "alias": {
              "type": "string"
            },
            "import_path": {
              "type": "string"
            },
            "name": {
              "type": "string"
            }
          },
          "required": [
            "import_path"
          ],
          "type": "object"
        },
        "minItems": 1,
        "type": "array"
      },
      "page": {
        "default": 1,
        "minimum": 1,
        "type": "integer"
      },
      "page_size": {
        "default": 50,
        "maximum": 200,
        "minimum": 1,
        "type": "integer"
      },
      "project_absolute_path": {
        "description": "Absolute path to the project root directory.",
        "type": "string"
      }
    },
    "required": [
      "project_absolute_path",
      "packages"
    ],
    "additionalProperties": false
  },
  "get_definition": {
    "type": "object",
    "properties": {
      "absolute_file_path": {
        "description": "Absolute file path to the file that contains the symbol usage. Example: /abs/path/to/src/main/java/com/example/User.java",
        "type": "string"
      },
      "line": {
        "description": "Exact line of code copied from the file (whitespace must match). Example: var name = user.getFirstName() + user.getLastName();",
        "type": "string"
      },
      "symbol_name": {
        "description": "Callable symbol to resolve (method/function name). Example: getFirstName",
        "type": "string"
      }
    },
    "required": [
      "absolute_file_path",
      "line",
      "symbol_name"
    ]
  },
  "read_definitions": {
    "type": "object",
    "properties": {
      "definitions": {
        "description": "Array of definition requests with names array and file path.",
        "items": {
          "additionalProperties": false,
          "properties": {
            "file_path": {
              "description": "Absolute or project-relative path to the file that contains the definitions. Example: src/main/java/com/example/User.java",
              "type": "string"
            },
            "names": {
              "description": "Array of exact identifier names to read from the same file. Must match symbol names exactly as they appear in code, without namespace prefixes or file extensions. Example: ['myFunction', 'MyClass'].",
              "items": {
                "type": "string"
              },
              "minItems": 1,
              "type": "array"
            }
          },
          "required": [
            "names",
            "file_path"
          ],
          "type": "object"
        },
        "type": "array"
      }
    },
    "required": [
      "definitions"
    ],
    "additionalProperties": false
  },
  "search_codebase_definitions": {
    "type": "object",
    "properties": {
      "page": {
        "default": 1,
        "description": "Page number starting from 1. If the response's next_page field is greater than 1, more results are available at that page. You can use this to retrieve more results if more context is needed.",
        "minimum": 1,
        "type": "number"
      },
      "project_absolute_path": {
        "description": "Absolute filesystem path to the project root directory where code definitions should be searched. You can use the list_projects tool to get the list of indexed projects.",
        "type": "string"
      },
      "search_terms": {
        "description": "List of definition names to search for. Can be names of functions, classes, constants, etc.",
        "items": {
          "type": "string"
        },
        "type": "array"
      }
    },
    "required": [
      "search_terms",
      "project_absolute_path"
    ]
  },
  "index_project": {
    "type": "object",
    "properties": {
      "project_absolute_path": {
        "description": "Absolute filesystem path to the project root directory to re-index. You can use the list_projects tool to get the list of indexed projects.",
        "type": "string"
      }
    },
    "required": [
      "project_absolute_path"
    ]
  },
  "list_projects": {
    "type": "object",
    "properties": {},
    "required": []
  },
  "get_references": {
    "type": "object",
    "properties": {
      "absolute_file_path": {
        "description": "Absolute file path to the file that contains the symbol usage. Example: /abs/path/to/src/main/java/com/example/User.java",
        "type": "string"
      },
      "definition_name": {
        "description": "The exact identifier name to search. Must match the symbol name exactly as it appears in code, without namespace prefixes or file extensions. Example: 'myFunction', 'MyClass'.",
        "type": "string"
      },
      "page": {
        "default": 1,
        "description": "Page number starting from 1. If the response's next_page field is greater than 1, more results are available at that page. You can use this to retrieve more results if more context is needed.",
        "minimum": 1,
        "type": "integer"
      }
    },
    "required": [
      "absolute_file_path",
      "definition_name"
    ],
    "additionalProperties": false
  },
  "repo_map": {
    "type": "object",
    "properties": {
      "depth": {
        "default": 1,
        "description": "Desired nesting depth for showing definition nodes for files under directories (advisory, included in output). 1 = top-level only. Maximum 3.",
        "maximum": 3,
        "minimum": 1,
        "type": "integer"
      },
      "page": {
        "default": 1,
        "description": "Page number starting from 1.",
        "minimum": 1,
        "type": "integer"
      },
      "page_size": {
        "default": 50,
        "description": "Number of definitions per page (global across all files).",
        "maximum": 200,
        "minimum": 1,
        "type": "integer"
      },
      "project_absolute_path": {
        "description": "Absolute path to the project root directory.",
        "type": "string"
      },
      "relative_paths": {
        "description": "Project-relative paths; each item may be a file or a directory under the project root. Directories are expanded recursively to files.",
        "items": {
          "type": "string"
        },
        "minItems": 1,
        "type": "array"
      },
      "show_definitions": {
        "default": true,
        "description": "Whether to include files and their definitions.",
        "type": "boolean"
      },
      "show_directories": {
        "default": true,
        "description": "Whether to include the directories list.",
        "type": "boolean"
      }
    },
    "required": [
      "project_absolute_path",
      "relative_paths"
    ],
    "additionalProperties": false
  }
} as const;
const embeddedName = "127";
const embeddedDescription = "rmcp";
const generatorInfo = "Generated by mcporter@0.0.0 — https://github.com/steipete/mcporter";
const generatorTools = [
  {
    "name": "import-usage",
    "description": "Analyze import usages across the project.\n\n- Returns imports that match the requested paths (with file/line locations)\n- Returns usages (call/reference sites) grouped by file with code snippets if found\n\nExamples:\n{\n  \"project_absolute_path\": \"/project/root\",\n  \"packages\": [\n    { \"import_path\": \"react\", \"name\": \"React\" },\n    { \"import_path\": \"@vue/runtime-core\" }\n  ],\n  \"page\": 1,\n  \"page_size\": 50\n}\n",
    "usage": "import-usage --packages <packages:value1,value2> [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> [--raw <json>]",
    "flags": "--packages <packages:value1,value2> [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> [--raw <json>]"
  },
  {
    "name": "get-definition",
    "description": "Go to definition for callable symbols (methods/functions) referenced on a specific line.\n\nBehavior:\n- Returns type \"Definition\" when the symbol is defined in the workspace.\n- Returns type \"ImportedSymbol\" when the symbol is external (best-matching import statement).\n\nRequirements:\n- Provide the exact line from the file (whitespace preserved).\n- Specify the callable symbol name you want to resolve.\n\nJava example:\nFile: src/main/java/com/example/User.java\nLine: var name = user.getFirstName() + user.getLastName();\nCall:\n{ \"absolute_file_path\": \"/abs/path/to/src/main/java/com/example/User.java\", \"line\": \"var name = user.getFirstName() + user.getLastName();\", \"symbol_name\": \"getFirstName\" }",
    "usage": "get-definition --absolute-file-path <absolute-file-path> --line <line> --symbol-name <symbol-name> [--raw <json>]",
    "flags": "--absolute-file-path <absolute-file-path> --line <line> --symbol-name <symbol-name> [--raw <json>]"
  },
  {
    "name": "read-definitions",
    "description": "Read the definition bodies for multiple definitions across the codebase.\n\nBehavior:\n- Takes an array of definition groups, where each group can contains multiple definition names for a single file\n- Returns the complete definition body/code for each found definition along with location information, fully qualified names, and definition types\n- Handles multiple definitions efficiently in a single request, optimizing token usage by grouping definitions by file\n\nRequirements:\n- Provide exact definition names as they appear in code (case-sensitive)\n- Specify absolute or project-relative file paths where definitions are expected to be found\n- Group multiple definition names per file to optimize token usage\n\nUse cases:\n- Reading multiple related definitions at once\n- Getting complete function/class/method/constant implementations\n- Code analysis, understanding, preparation for refactoring operations\n\nExample:\nDefinitions to read:\n- Functions `calculateTotal` and `formatCurrency` in `/project/src/utils/math.js`\n- Class `UserService` in `/project/src/services/user.js`\n\nCall:\n{\n  \"definitions\": [\n    {\n      \"names\": [\"calculateTotal\", \"formatCurrency\"],\n      \"file_path\": \"/project/src/utils/math.js\"\n    },\n    {\n      \"names\": [\"UserService\"], \n      \"file_path\": \"/project/src/services/user.js\"\n    }\n  ]\n}\n\nThis will return the complete code bodies for all definitions along with their metadata.\nTip: Use with `search_codebase_definitions` first to locate definitions, then use this tool to read their implementations.",
    "usage": "read-definitions --definitions <definitions:value1,value2> [--raw <json>]",
    "flags": "--definitions <definitions:value1,value2> [--raw <json>]"
  },
  {
    "name": "search-codebase-definitions",
    "description": "Searches for functions, classes, methods, constants, and interfaces in the codebase.\n\nBehavior:\n- Finds multiple code definitions using the search terms across all files in the specified project.\n- Supports exact and partial matching.\n- Returns signatures, locations and the definition type of the matching definitions.\n- Large result sets are paginated with the `page` parameter.\n\nRequirements:\n- Provide one or multiple search terms to locate the definitions.\n- Specify the absolute filesystem path to the project root directory.\n\nUse cases:\n- Finding function, class, method, constant, interface definitions across the codebase\n- Understanding code structure and architecture\n- Getting overview of available APIs and interfaces\n\nExample:\nSearching for multiple definitions in a React project:\nSearch terms: [\"useState\", \"ComponentProps\", \"handleSubmit\"]\nProject: \"/home/user/my-react-app\"\nPage: 1 (first page)\n\nCall:\n{\n  \"search_terms\": [\"useState\", \"ComponentProps\", \"handleSubmit\"],\n  \"project\": \"/home/user/my-react-app\",\n  \"page\": 1\n}\n\nThis will find all definitions matching those names throughout the codebase, returning their signatures and locations.\nTip: Use this tool in combination with get_references tool - first locate definitions with this tool, then use get_references tool to see where they're used throughout the codebase.",
    "usage": "search-codebase-definitions [--page <page:number>] --project-absolute-path <project-absolute-path> --search-terms <search-terms:value1,value2> [--raw <json>]",
    "flags": "[--page <page:number>] --project-absolute-path <project-absolute-path> --search-terms <search-terms:value1,value2> [--raw <json>]"
  },
  {
    "name": "index-project",
    "description": "Rebuild the Knowledge Graph index to reflect recent changes in the project.\n\nBehavior:\n- Scans the entire project and regenerates the Knowledge Graph from scratch.\n- Updates all file relationships, dependencies, and cross-references.\n\nRequirements:\n- Specify the absolute filesystem path to the project root directory.\n- The project must be indexed in the Knowledge Graph.\n\nWhen to use:\n- After substantial file modifications, additions, or deletions.\n- When the Knowledge Graph appears stale or incomplete.\n\nExample:\nCall:\n{ \"project\": \"/path/to/project\" }\n",
    "usage": "index-project --project-absolute-path <project-absolute-path> [--raw <json>]",
    "flags": "--project-absolute-path <project-absolute-path> [--raw <json>]"
  },
  {
    "name": "list-projects",
    "description": "Get a list of all projects indexed in the knowledge graph.\n\nUseful for:\n- You don't know the absolute filesystem path to the current project root directory.\n- You want to know the indexed projects in the Knowledge Graph.\n",
    "usage": "list-projects [--raw <json>]",
    "flags": "[--raw <json>]"
  },
  {
    "name": "get-references",
    "description": "Find all references to a code definition (function, class, constant, etc.) across the entire codebase.\n\nBehavior:\n- Searches for every location where a given symbol is called.\n- Returns file paths, line numbers, and context around each usage.\n- Large result sets are paginated with the `page` parameter.\n\nRequirements:\n- Provide the exact symbol name as it appears in code (case-sensitive).\n- Specify the absolute file path where the definition is declared.\n\nUse cases:\n- Impact analysis before refactoring\n- Finding all callers of a function\n- Dependency mapping\n\nExample:\nFunction definition: `export const = calculateTotal(param) => {...}` in `/project/src/utils/math.js`\nPage: 1 (first page)\nCall:\n{\n  \"definition_name\": \"calculateTotal\",\n  \"absolute_file_path\": \"/project/src/utils/math.js\",\n  \"page\": 1,\n}\n\nThis will find all places where `calculateTotal` is called throughout the codebase.\nTip: Use with `search_codebase_definitions` first to locate the definition, then use this tool to find all its references.",
    "usage": "get-references --absolute-file-path <absolute-file-path> --definition-name <definition-name> [--page <page>] [--raw <json>]",
    "flags": "--absolute-file-path <absolute-file-path> --definition-name <definition-name> [--page <page>] [--raw <json>]"
  },
  {
    "name": "repo-map",
    "description": "Generate a compact, API-style map for selected repository paths.\n\nUseful for:\n- Summarize a repository segment for LLMs or code review\n- Explore structure first (directories only), then fetch definitions\n- Useful for other tools, like get_references\n\nRecommendations:\n- Keep depth at 1–2 for large repos to control output size\n- Increase page_size or follow next-page if more results are needed\n",
    "usage": "repo-map [--depth <depth>] [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> --relative-paths <relative-paths:value1,value2> [--raw <json>]",
    "flags": "[--depth <depth>] [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> --relative-paths <relative-paths:value1,value2> [--raw <json>]"
  }
] as const;
const embeddedMetadata = {
  "schemaVersion": 1,
  "generatedAt": "2025-11-27T09:09:04.861Z",
  "generator": {
    "name": "mcporter",
    "version": "0.0.0"
  },
  "server": {
    "name": "127",
    "definition": {
      "name": "127",
      "description": "rmcp",
      "command": {
        "kind": "http",
        "url": "http://127.0.0.1:27495/mcp"
      }
    }
  },
  "artifact": {
    "path": "",
    "kind": "template"
  },
  "invocation": {
    "serverRef": "{\"name\":\"127\",\"command\":\"http://127.0.0.1:27495/mcp\"}",
    "runtime": "bun",
    "bundler": "bun",
    "timeoutMs": 30000,
    "minify": false
  }
} as const;
const artifactKind = determineArtifactKind();
const program = new Command();
program.name(embeddedName);
program.description(embeddedDescription);
program.option('-t, --timeout <ms>', 'Call timeout in milliseconds', (value) => parseInt(value, 10), 30000);
program.option('-o, --output <format>', 'Output format: text|markdown|json|raw', 'text');
const commandSignatures: Record<string, string> = {
  "import-usage": "function import_usage(packages: string[], page?: unknown, page_size?: unknown, project_absolute_path: string);",
  "get-definition": "function get_definition(absolute_file_path: string, line: string, symbol_name: string);",
  "read-definitions": "function read_definitions(definitions: string[]);",
  "search-codebase-definitions": "function search_codebase_definitions(page?: number, project_absolute_path: string, search_terms: string[]);",
  "index-project": "function index_project(project_absolute_path: string);",
  "list-projects": "function list_projects();",
  "get-references": "function get_references(absolute_file_path: string, definition_name: string, page?: unknown);",
  "repo-map": "function repo_map(depth?: unknown, page?: unknown, page_size?: unknown, project_absolute_path: string, relative_paths: string[]);"
};
program.configureHelp({
	commandTerm(cmd) {
		const term = cmd.name();
		return commandSignatures[term] ?? cmd.name();
	},
});
program.showSuggestionAfterError(true);

program
	.command("import-usage")
	.summary("import-usage --packages <packages:value1,value2> [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> [--raw <json>]")
	.description("Analyze import usages across the project.\n\n- Returns imports that match the requested paths (with file/line locations)\n- Returns usages (call/reference sites) grouped by file with code snippets if found\n\nExamples:\n{\n  \"project_absolute_path\": \"/project/root\",\n  \"packages\": [\n    { \"import_path\": \"react\", \"name\": \"React\" },\n    { \"import_path\": \"@vue/runtime-core\" }\n  ],\n  \"page\": 1,\n  \"page_size\": 50\n}\n")
	.usage("--packages <packages:value1,value2> [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--packages <packages:value1,value2>", "Set packages. (example: value1,value2)", (value) => value.split(','))
	.option("--page <page>", "Set page. (default: 1; example: 1)")
	.option("--page-size <page-size>", "Set page_size. (default: 50; example: 50)")
	.option("--project-absolute-path <project-absolute-path>", "Absolute path to the project root directory. (example: /path/to/file.md)")
	
	.alias("import_usage")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw) {
			if (cmdOpts.packages !== undefined) args.packages = cmdOpts.packages;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.page_size !== undefined) args.page_size = cmdOpts.page_size;
		if (cmdOpts.project_absolute_path !== undefined) args.project_absolute_path = cmdOpts.project_absolute_path;
			}
			const call = (proxy.importUsage as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.import_usage(packages: [\"value1\", \"value2\"], page: 1, pa, ...)");

program
	.command("get-definition")
	.summary("get-definition --absolute-file-path <absolute-file-path> --line <line> --symbol-name <symbol-name> [--raw <json>]")
	.description("Go to definition for callable symbols (methods/functions) referenced on a specific line.\n\nBehavior:\n- Returns type \"Definition\" when the symbol is defined in the workspace.\n- Returns type \"ImportedSymbol\" when the symbol is external (best-matching import statement).\n\nRequirements:\n- Provide the exact line from the file (whitespace preserved).\n- Specify the callable symbol name you want to resolve.\n\nJava example:\nFile: src/main/java/com/example/User.java\nLine: var name = user.getFirstName() + user.getLastName();\nCall:\n{ \"absolute_file_path\": \"/abs/path/to/src/main/java/com/example/User.java\", \"line\": \"var name = user.getFirstName() + user.getLastName();\", \"symbol_name\": \"getFirstName\" }")
	.usage("--absolute-file-path <absolute-file-path> --line <line> --symbol-name <symbol-name> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--absolute-file-path <absolute-file-path>", "Absolute file path to the file that contains the symbol usage. Example: /abs/path/to/src/main/java/com/example/User.java (example: /path/to/file.md)")
	.option("--line <line>", "Exact line of code copied from the file (whitespace must match). Example: var name = user.getFirstName() + user.getLastName();")
	.option("--symbol-name <symbol-name>", "Callable symbol to resolve (method/function name). Example: getFirstName")
	
	.alias("get_definition")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw) {
			if (cmdOpts.absolute_file_path !== undefined) args.absolute_file_path = cmdOpts.absolute_file_path;
		if (cmdOpts.line !== undefined) args.line = cmdOpts.line;
		if (cmdOpts.symbol_name !== undefined) args.symbol_name = cmdOpts.symbol_name;
			}
			const call = (proxy.getDefinition as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.get_definition(absolute_file_path: \"/path/to/file.md\", l, ...)");

program
	.command("read-definitions")
	.summary("read-definitions --definitions <definitions:value1,value2> [--raw <json>]")
	.description("Read the definition bodies for multiple definitions across the codebase.\n\nBehavior:\n- Takes an array of definition groups, where each group can contains multiple definition names for a single file\n- Returns the complete definition body/code for each found definition along with location information, fully qualified names, and definition types\n- Handles multiple definitions efficiently in a single request, optimizing token usage by grouping definitions by file\n\nRequirements:\n- Provide exact definition names as they appear in code (case-sensitive)\n- Specify absolute or project-relative file paths where definitions are expected to be found\n- Group multiple definition names per file to optimize token usage\n\nUse cases:\n- Reading multiple related definitions at once\n- Getting complete function/class/method/constant implementations\n- Code analysis, understanding, preparation for refactoring operations\n\nExample:\nDefinitions to read:\n- Functions `calculateTotal` and `formatCurrency` in `/project/src/utils/math.js`\n- Class `UserService` in `/project/src/services/user.js`\n\nCall:\n{\n  \"definitions\": [\n    {\n      \"names\": [\"calculateTotal\", \"formatCurrency\"],\n      \"file_path\": \"/project/src/utils/math.js\"\n    },\n    {\n      \"names\": [\"UserService\"], \n      \"file_path\": \"/project/src/services/user.js\"\n    }\n  ]\n}\n\nThis will return the complete code bodies for all definitions along with their metadata.\nTip: Use with `search_codebase_definitions` first to locate definitions, then use this tool to read their implementations.")
	.usage("--definitions <definitions:value1,value2> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--definitions <definitions:value1,value2>", "Array of definition requests with names array and file path. (example: value1,value2)", (value) => value.split(','))
	
	.alias("read_definitions")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw && cmdOpts.definitions !== undefined) args.definitions = cmdOpts.definitions;
			const call = (proxy.readDefinitions as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.read_definitions(definitions: [\"value1\", \"value2\"])");

program
	.command("search-codebase-definitions")
	.summary("search-codebase-definitions [--page <page:number>] --project-absolute-path <project-absolute-path> --search-terms <search-terms:value1,value2> [--raw <json>]")
	.description("Searches for functions, classes, methods, constants, and interfaces in the codebase.\n\nBehavior:\n- Finds multiple code definitions using the search terms across all files in the specified project.\n- Supports exact and partial matching.\n- Returns signatures, locations and the definition type of the matching definitions.\n- Large result sets are paginated with the `page` parameter.\n\nRequirements:\n- Provide one or multiple search terms to locate the definitions.\n- Specify the absolute filesystem path to the project root directory.\n\nUse cases:\n- Finding function, class, method, constant, interface definitions across the codebase\n- Understanding code structure and architecture\n- Getting overview of available APIs and interfaces\n\nExample:\nSearching for multiple definitions in a React project:\nSearch terms: [\"useState\", \"ComponentProps\", \"handleSubmit\"]\nProject: \"/home/user/my-react-app\"\nPage: 1 (first page)\n\nCall:\n{\n  \"search_terms\": [\"useState\", \"ComponentProps\", \"handleSubmit\"],\n  \"project\": \"/home/user/my-react-app\",\n  \"page\": 1\n}\n\nThis will find all definitions matching those names throughout the codebase, returning their signatures and locations.\nTip: Use this tool in combination with get_references tool - first locate definitions with this tool, then use get_references tool to see where they're used throughout the codebase.")
	.usage("[--page <page:number>] --project-absolute-path <project-absolute-path> --search-terms <search-terms:value1,value2> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--page <page:number>", "Page number starting from 1. If the response's next_page field is greater than 1, more results are available at that page. You can use this to retrieve more results if more context is needed. (default: 1; example: 1)", (value) => parseFloat(value))
	.option("--project-absolute-path <project-absolute-path>", "Absolute filesystem path to the project root directory where code definitions should be searched. You can use the list_projects tool to get the list of indexed projects. (example: /path/to/file.md)")
	.option("--search-terms <search-terms:value1,value2>", "List of definition names to search for. Can be names of functions, classes, constants, etc. (example: value1,value2)", (value) => value.split(','))
	
	.alias("search_codebase_definitions")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw) {
			if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.project_absolute_path !== undefined) args.project_absolute_path = cmdOpts.project_absolute_path;
		if (cmdOpts.search_terms !== undefined) args.search_terms = cmdOpts.search_terms;
			}
			const call = (proxy.searchCodebaseDefinitions as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.search_codebase_definitions(page: 1, project_absolute_pa, ...)");

program
	.command("index-project")
	.summary("index-project --project-absolute-path <project-absolute-path> [--raw <json>]")
	.description("Rebuild the Knowledge Graph index to reflect recent changes in the project.\n\nBehavior:\n- Scans the entire project and regenerates the Knowledge Graph from scratch.\n- Updates all file relationships, dependencies, and cross-references.\n\nRequirements:\n- Specify the absolute filesystem path to the project root directory.\n- The project must be indexed in the Knowledge Graph.\n\nWhen to use:\n- After substantial file modifications, additions, or deletions.\n- When the Knowledge Graph appears stale or incomplete.\n\nExample:\nCall:\n{ \"project\": \"/path/to/project\" }\n")
	.usage("--project-absolute-path <project-absolute-path> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--project-absolute-path <project-absolute-path>", "Absolute filesystem path to the project root directory to re-index. You can use the list_projects tool to get the list of indexed projects. (example: /path/to/file.md)")
	
	.alias("index_project")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw && cmdOpts.project_absolute_path !== undefined) args.project_absolute_path = cmdOpts.project_absolute_path;
			const call = (proxy.indexProject as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.index_project(project_absolute_path: \"/path/to/file.md\")");

program
	.command("list-projects")
	.summary("list-projects [--raw <json>]")
	.description("Get a list of all projects indexed in the knowledge graph.\n\nUseful for:\n- You don't know the absolute filesystem path to the current project root directory.\n- You want to know the indexed projects in the Knowledge Graph.\n")
	.usage("[--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	
	.alias("list_projects")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			
			const call = (proxy.listProjects as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.list_projects()");

program
	.command("get-references")
	.summary("get-references --absolute-file-path <absolute-file-path> --definition-name <definition-name> [--page <page>] [--raw <json>]")
	.description("Find all references to a code definition (function, class, constant, etc.) across the entire codebase.\n\nBehavior:\n- Searches for every location where a given symbol is called.\n- Returns file paths, line numbers, and context around each usage.\n- Large result sets are paginated with the `page` parameter.\n\nRequirements:\n- Provide the exact symbol name as it appears in code (case-sensitive).\n- Specify the absolute file path where the definition is declared.\n\nUse cases:\n- Impact analysis before refactoring\n- Finding all callers of a function\n- Dependency mapping\n\nExample:\nFunction definition: `export const = calculateTotal(param) => {...}` in `/project/src/utils/math.js`\nPage: 1 (first page)\nCall:\n{\n  \"definition_name\": \"calculateTotal\",\n  \"absolute_file_path\": \"/project/src/utils/math.js\",\n  \"page\": 1,\n}\n\nThis will find all places where `calculateTotal` is called throughout the codebase.\nTip: Use with `search_codebase_definitions` first to locate the definition, then use this tool to find all its references.")
	.usage("--absolute-file-path <absolute-file-path> --definition-name <definition-name> [--page <page>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--absolute-file-path <absolute-file-path>", "Absolute file path to the file that contains the symbol usage. Example: /abs/path/to/src/main/java/com/example/User.java (example: /path/to/file.md)")
	.option("--definition-name <definition-name>", "The exact identifier name to search. Must match the symbol name exactly as it appears in code, without namespace prefixes or file extensions. Example: 'myFunction', 'MyClass'.")
	.option("--page <page>", "Page number starting from 1. If the response's next_page field is greater than 1, more results are available at that page. You can use this to retrieve more results if more context is needed. (default: 1; example: 1)")
	
	.alias("get_references")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw) {
			if (cmdOpts.absolute_file_path !== undefined) args.absolute_file_path = cmdOpts.absolute_file_path;
		if (cmdOpts.definition_name !== undefined) args.definition_name = cmdOpts.definition_name;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
			}
			const call = (proxy.getReferences as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.get_references(absolute_file_path: \"/path/to/file.md\", d, ...)");

program
	.command("repo-map")
	.summary("repo-map [--depth <depth>] [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> --relative-paths <relative-paths:value1,value2> [--raw <json>]")
	.description("Generate a compact, API-style map for selected repository paths.\n\nUseful for:\n- Summarize a repository segment for LLMs or code review\n- Explore structure first (directories only), then fetch definitions\n- Useful for other tools, like get_references\n\nRecommendations:\n- Keep depth at 1–2 for large repos to control output size\n- Increase page_size or follow next-page if more results are needed\n")
	.usage("[--depth <depth>] [--page <page>] [--page-size <page-size>] --project-absolute-path <project-absolute-path> --relative-paths <relative-paths:value1,value2> [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.option("--depth <depth>", "Desired nesting depth for showing definition nodes for files under directories (advisory, included in output). 1 = top-level only. Maximum 3. (default: 1; example: 1)")
	.option("--page <page>", "Page number starting from 1. (default: 1; example: 1)")
	.option("--page-size <page-size>", "Number of definitions per page (global across all files). (default: 50; example: 50)")
	.option("--project-absolute-path <project-absolute-path>", "Absolute path to the project root directory. (example: /path/to/file.md)")
	.option("--relative-paths <relative-paths:value1,value2>", "Project-relative paths; each item may be a file or a directory under the project root. Directories are expanded recursively to files. (example: value1,value2)", (value) => value.split(','))
	.option("--show-definitions <show-definitions:true|false>", "Whether to include files and their definitions. (default: true; example: true)", (value) => value !== 'false')
	.option("--show-directories <show-directories:true|false>", "Whether to include the directories list. (default: true; example: true)", (value) => value !== 'false')
	
	.alias("repo_map")	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (!cmdOpts.raw) {
			if (cmdOpts.depth !== undefined) args.depth = cmdOpts.depth;
		if (cmdOpts.page !== undefined) args.page = cmdOpts.page;
		if (cmdOpts.page_size !== undefined) args.page_size = cmdOpts.page_size;
		if (cmdOpts.project_absolute_path !== undefined) args.project_absolute_path = cmdOpts.project_absolute_path;
		if (cmdOpts.relative_paths !== undefined) args.relative_paths = cmdOpts.relative_paths;
		if (cmdOpts.show_definitions !== undefined) args.show_definitions = cmdOpts.show_definitions;
		if (cmdOpts.show_directories !== undefined) args.show_directories = cmdOpts.show_directories;
			}
			const call = (proxy.repoMap as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call 127.repo_map(depth: 1, page: 1, page_size: 50, project_absol, ...)")
	.addHelpText('afterAll', () => '\n' + "// optional (2): show_definitions, show_directories" + '\n');

program
	.command('__mcporter_inspect', { hidden: true })
	.description('Internal metadata printer for mcporter inspect-cli.')
	.action(() => {
		const payload = buildMetadataPayload();
		console.log(JSON.stringify(payload, null, 2));
	});

configureToolCommandHelps();

const FORCE_COLOR = process.env.FORCE_COLOR?.toLowerCase();
const forceDisableColor = FORCE_COLOR === '0' || FORCE_COLOR === 'false';
const forceEnableColor = FORCE_COLOR === '1' || FORCE_COLOR === 'true' || FORCE_COLOR === '2' || FORCE_COLOR === '3';
const hasNoColor = process.env.NO_COLOR !== undefined;
const stdoutStream = process.stdout as NodeJS.WriteStream | undefined;
const supportsAnsiColor = !hasNoColor && (forceEnableColor || (!forceDisableColor && Boolean(stdoutStream?.isTTY)));

const tint = {
	bold(text: string): string {
		return supportsAnsiColor ? '[1m' + text + '[0m' : text;
	},
	dim(text: string): string {
		return supportsAnsiColor ? '[90m' + text + '[0m' : text;
	},
	extraDim(text: string): string {
		return supportsAnsiColor ? '[38;5;244m' + text + '[0m' : text;
	},
};

function configureGeneratedCommandHelp(command: Command): void {
	command.configureHelp({
		commandUsage(target) {
			const usage = (target.name() + ' ' + target.usage()).trim() || target.name();
			return supportsAnsiColor ? tint.bold(usage) : usage;
		},
		optionTerm(option) {
			const term = option.flags ?? '';
			return supportsAnsiColor ? tint.bold(term) : term;
		},
		optionDescription(option) {
			const description = option.description ?? '';
			return supportsAnsiColor ? tint.extraDim(description) : description;
		},
	});
}

function configureToolCommandHelps(): void {
	program.commands.forEach((cmd) => {
		if (cmd.name() === '__mcporter_inspect') {
			return;
		}
		configureGeneratedCommandHelp(cmd);
	});
}

function renderStandaloneHelp(): string {
	const colorfulTitle = tint.bold(embeddedName) + ' ' + tint.dim('— ' + embeddedDescription);
	const plainTitle = embeddedName + ' — ' + embeddedDescription;
	const title = supportsAnsiColor ? colorfulTitle : plainTitle;
	const lines = [title, '', 'Usage: ' + embeddedName + ' <command> [options]', ''];
	if (generatorTools) {
		lines.push(formatEmbeddedTools());
	}
	lines.push('', formatGlobalFlags(), '', formatQuickStart());
	if (generatorInfo) {
		lines.push('', tint.extraDim(generatorInfo));
	}
	return lines.join('\n');
}

program.helpInformation = () => renderStandaloneHelp();

function formatEmbeddedTools(): string {
	const header = supportsAnsiColor ? tint.bold('Embedded tools') : 'Embedded tools';
	if (!generatorTools.length) {
		return header;
	}
	const lines = [header];
	generatorTools.forEach((entry) => {
		const renderedDesc = entry.description
			? supportsAnsiColor
				? tint.extraDim(entry.description)
				: entry.description
			: undefined;
		const base = renderedDesc ? entry.name + ' - ' + renderedDesc : entry.name;
		lines.push('  ' + base);
		if (entry.flags) {
			const renderedFlags = supportsAnsiColor ? tint.extraDim(entry.flags) : entry.flags;
			lines.push('    ' + renderedFlags);
		}
		lines.push('');
	});
	if (lines[lines.length - 1] === '') {
		lines.pop();
	}
	return lines.join('\n');
}

function formatGlobalFlags(): string {
	const header = supportsAnsiColor ? tint.bold('Global flags') : 'Global flags';
	const entries = [
		['-t, --timeout <ms>', 'Call timeout in milliseconds'],
		['-o, --output <format>', 'text | markdown | json | raw (default text)'],
	];
	const formatted = entries.map(([flag, summary]) => '  ' + flag.padEnd(28) + summary);
	return [header, ...formatted].join('\n');
}

function formatQuickStart(): string {
  const header = supportsAnsiColor ? tint.bold('Quick start') : 'Quick start';
  const examples = quickStartExamples();
  if (!examples.length) {
    return header;
  }
  const formatted = examples.map(([cmd, note]) => '  ' + cmd + '\n    ' + tint.dim('# ' + note));
  return [header, ...formatted].join('\n');
}

function quickStartExamples(): Array<[string, string]> {
  const examples: Array<[string, string]> = [];
  const commandMap = new Map<string, string>();
  program.commands.forEach((cmd) => {
    const name = cmd.name();
    if (name !== '__mcporter_inspect') {
      commandMap.set(name, name);
    }
  });
  const embedded = Array.isArray(generatorTools) ? generatorTools : [];
  for (const entry of embedded.slice(0, 3)) {
    const commandName = commandMap.get(entry.name) ?? entry.name;
    const flags = entry.flags ? ' ' + entry.flags.replace(/<[^>]+>/g, '<value>') : '';
    examples.push([embeddedName + ' ' + commandName + flags, 'invoke ' + commandName]);
  }
  if (!examples.length) {
    examples.push([embeddedName + ' <tool> --key value', 'invoke a tool with flags']);
  }
  return examples;
}

function printResult(result: unknown, format: string) {
	const wrapped = createCallResult(result);
	switch (format) {
		case 'json': {
			const json = wrapped.json();
			if (json) {
				console.log(JSON.stringify(json, null, 2));
				return;
			}
			break;
		}
		case 'markdown': {
			const markdown = wrapped.markdown();
			if (markdown) {
				console.log(markdown);
				return;
			}
			break;
		}
		case 'raw': {
			console.log(JSON.stringify(wrapped.raw, null, 2));
			return;
		}
	}
	const text = wrapped.text();
	if (text) {
		console.log(text);
	} else {
		console.log(JSON.stringify(wrapped.raw, null, 2));
	}
}

function normalizeEmbeddedServer(server: typeof embeddedServer) {
	const base = { ...server } as Record<string, unknown>;
	if ((server.command as any).kind === 'http') {
		const urlRaw = (server.command as any).url;
		const urlValue = typeof urlRaw === 'string' ? urlRaw : String(urlRaw);
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				url: new URL(urlValue),
			},
		};
	}
	if ((server.command as any).kind === 'stdio') {
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				args: [ ...((server.command as any).args ?? []) ],
			},
		};
	}
	return base;
}

function determineArtifactKind(): 'template' | 'bundle' | 'binary' {
	const scriptPath = typeof process !== 'undefined' && Array.isArray(process.argv) ? process.argv[1] ?? '' : '';
	if (scriptPath.endsWith('.ts')) {
		return 'template';
	}
	if (scriptPath.endsWith('.js')) {
		return 'bundle';
	}
	return 'binary';
}

function resolveArtifactPath(): string {
	if (typeof process !== 'undefined' && Array.isArray(process.argv) && process.argv.length > 1) {
		const script = process.argv[1];
		if (script) {
			return script;
		}
	}
	return embeddedMetadata.artifact.path;
}

function buildMetadataPayload() {
	const invocation = { ...embeddedMetadata.invocation };
	const path = resolveArtifactPath();
	if (artifactKind === 'template' && path) {
		invocation.outputPath = invocation.outputPath ?? path;
	} else if (artifactKind === 'bundle' && path) {
		invocation.bundle = invocation.bundle ?? path;
	} else if (artifactKind === 'binary' && path) {
		invocation.compile = invocation.compile ?? path;
	}
	return {
		...embeddedMetadata,
		artifact: {
			path,
			kind: artifactKind,
		},
		invocation,
	};
}

async function ensureRuntime(): Promise<Awaited<ReturnType<typeof createRuntime>>> {
	return await createRuntime({
		servers: [normalizeEmbeddedServer(embeddedServer)],
	});
}

async function invokeWithTimeout<T>(call: Promise<T>, timeout: number): Promise<T> {
	if (!Number.isFinite(timeout) || timeout <= 0) {
		return await call;
	}
	let timer: ReturnType<typeof setTimeout> | undefined;
	try {
		return await Promise.race([
			call,
			new Promise<never>((_, reject) => {
				timer = setTimeout(() => {
					reject(new Error('Call timed out after ' + timeout + 'ms.'));
				}, timeout);
			}),
		]);
	} finally {
		if (timer) {
			clearTimeout(timer);
		}
	}
}

async function runCli(): Promise<void> {
	const args = process.argv.slice(2);
	if (args.length === 0) {
		program.outputHelp();
		return;
	}
	await program.parseAsync(process.argv);
}

if (process.env.MCPORTER_DISABLE_AUTORUN !== '1') {
	runCli().catch((error) => {
		const message = error instanceof Error ? error.message : String(error);
		console.error(message);
		process.exit(1);
	});
}
