#!/usr/bin/env bun
// @generated by mcporter@0.0.0 on 2025-11-27T04:07:47.123Z. DO NOT EDIT.
import { Command } from 'commander';
import { createRuntime, createServerProxy } from 'mcporter';
import { createCallResult } from 'mcporter';

const embeddedServer = {
  "name": "modelcontextprotocol-server-sequential-thinking",
  "command": {
    "kind": "stdio",
    "command": "npx",
    "args": [
      "-y",
      "@modelcontextprotocol/server-sequential-thinking"
    ]
  },
  "source": {
    "kind": "local",
    "path": "<adhoc>"
  },
  "description": "sequential-thinking-server"
} as const;
const embeddedSchemas = {
  "sequentialthinking": {
    "type": "object",
    "properties": {
      "thought": {
        "description": "Your current thinking step",
        "type": "string"
      },
      "nextThoughtNeeded": {
        "description": "Whether another thought step is needed",
        "type": "boolean"
      },
      "thoughtNumber": {
        "description": "Current thought number (numeric value, e.g., 1, 2, 3)",
        "type": "integer",
        "minimum": 1,
        "maximum": 9007199254740991
      },
      "totalThoughts": {
        "description": "Estimated total thoughts needed (numeric value, e.g., 5, 10)",
        "type": "integer",
        "minimum": 1,
        "maximum": 9007199254740991
      },
      "isRevision": {
        "description": "Whether this revises previous thinking",
        "type": "boolean"
      },
      "revisesThought": {
        "description": "Which thought is being reconsidered",
        "type": "integer",
        "minimum": 1,
        "maximum": 9007199254740991
      },
      "branchFromThought": {
        "description": "Branching point thought number",
        "type": "integer",
        "minimum": 1,
        "maximum": 9007199254740991
      },
      "branchId": {
        "description": "Branch identifier",
        "type": "string"
      },
      "needsMoreThoughts": {
        "description": "If more thoughts are needed",
        "type": "boolean"
      }
    },
    "required": [
      "thought",
      "nextThoughtNeeded",
      "thoughtNumber",
      "totalThoughts"
    ],
    "$schema": "http://json-schema.org/draft-07/schema#"
  }
} as const;
const embeddedName = "modelcontextprotocol-server-sequential-thinking";
const embeddedDescription = "sequential-thinking-server";
const generatorInfo = "Generated by mcporter@0.0.0 — https://github.com/steipete/mcporter";
const generatorTools = [
  {
    "name": "sequentialthinking",
    "description": "A detailed tool for dynamic and reflective problem-solving through thoughts.\nThis tool helps analyze problems through a flexible thinking process that can adapt and evolve.\nEach thought can build on, question, or revise previous insights as understanding deepens.\n\nWhen to use this tool:\n- Breaking down complex problems into steps\n- Planning and design with room for revision\n- Analysis that might need course correction\n- Problems where the full scope might not be clear initially\n- Problems that require a multi-step solution\n- Tasks that need to maintain context over multiple steps\n- Situations where irrelevant information needs to be filtered out\n\nKey features:\n- You can adjust total_thoughts up or down as you progress\n- You can question or revise previous thoughts\n- You can add more thoughts even after reaching what seemed like the end\n- You can express uncertainty and explore alternative approaches\n- Not every thought needs to build linearly - you can branch or backtrack\n- Generates a solution hypothesis\n- Verifies the hypothesis based on the Chain of Thought steps\n- Repeats the process until satisfied\n- Provides a correct answer\n\nParameters explained:\n- thought: Your current thinking step, which can include:\n  * Regular analytical steps\n  * Revisions of previous thoughts\n  * Questions about previous decisions\n  * Realizations about needing more analysis\n  * Changes in approach\n  * Hypothesis generation\n  * Hypothesis verification\n- nextThoughtNeeded: True if you need more thinking, even if at what seemed like the end\n- thoughtNumber: Current number in sequence (can go beyond initial total if needed)\n- totalThoughts: Current estimate of thoughts needed (can be adjusted up/down)\n- isRevision: A boolean indicating if this thought revises previous thinking\n- revisesThought: If is_revision is true, which thought number is being reconsidered\n- branchFromThought: If branching, which thought number is the branching point\n- branchId: Identifier for the current branch (if any)\n- needsMoreThoughts: If reaching end but realizing more thoughts needed\n\nYou should:\n1. Start with an initial estimate of needed thoughts, but be ready to adjust\n2. Feel free to question or revise previous thoughts\n3. Don't hesitate to add more thoughts if needed, even at the \"end\"\n4. Express uncertainty when present\n5. Mark thoughts that revise previous thinking or branch into new paths\n6. Ignore information that is irrelevant to the current step\n7. Generate a solution hypothesis when appropriate\n8. Verify the hypothesis based on the Chain of Thought steps\n9. Repeat the process until satisfied with the solution\n10. Provide a single, ideally correct answer as the final output\n11. Only set next_thought_needed to false when truly done and a satisfactory answer is reached",
    "usage": "sequentialthinking --thought <thought> --next-thought-needed <next-thought-needed:true|false> --thought-number <thought-number> --total-thoughts <total-thoughts> [--is-revision <is-revision:true|false>] [--raw <json>]",
    "flags": "--thought <thought> --next-thought-needed <next-thought-needed:true|false> --thought-number <thought-number> --total-thoughts <total-thoughts> [--is-revision <is-revision:true|false>] [--raw <json>]"
  }
] as const;
const embeddedMetadata = {
  "schemaVersion": 1,
  "generatedAt": "2025-11-27T04:07:47.123Z",
  "generator": {
    "name": "mcporter",
    "version": "0.0.0"
  },
  "server": {
    "name": "modelcontextprotocol-server-sequential-thinking",
    "source": {
      "kind": "local",
      "path": "<adhoc>"
    },
    "definition": {
      "name": "modelcontextprotocol-server-sequential-thinking",
      "description": "sequential-thinking-server",
      "command": {
        "kind": "stdio",
        "command": "npx",
        "args": [
          "-y",
          "@modelcontextprotocol/server-sequential-thinking"
        ]
      }
    }
  },
  "artifact": {
    "path": "",
    "kind": "template"
  },
  "invocation": {
    "serverRef": "{\"name\":\"modelcontextprotocol-server-sequential-thinking\",\"command\":{\"kind\":\"stdio\",\"command\":\"npx\",\"args\":[\"-y\",\"@modelcontextprotocol/server-sequential-thinking\"]},\"source\":{\"kind\":\"local\",\"path\":\"<adhoc>\"}}",
    "configPath": "<adhoc>",
    "runtime": "bun",
    "bundler": "bun",
    "timeoutMs": 30000,
    "minify": false
  }
} as const;
const artifactKind = determineArtifactKind();
const program = new Command();
program.name(embeddedName);
program.description(embeddedDescription);
program.option('-t, --timeout <ms>', 'Call timeout in milliseconds', (value) => parseInt(value, 10), 30000);
program.option('-o, --output <format>', 'Output format: text|markdown|json|raw', 'text');
const commandSignatures: Record<string, string> = {
  "sequentialthinking": "function sequentialthinking(thought: string, nextThoughtNeeded: boolean, thoughtNumber: unknown, totalThoughts: unknown, isRevision?: boolean): object;"
};
program.configureHelp({
	commandTerm(cmd) {
		const term = cmd.name();
		return commandSignatures[term] ?? cmd.name();
	},
});
program.showSuggestionAfterError(true);

program
	.command("sequentialthinking")
	.summary("sequentialthinking --thought <thought> --next-thought-needed <next-thought-needed:true|false> --thought-number <thought-number> --total-thoughts <total-thoughts> [--is-revision <is-revision:true|false>] [--raw <json>]")
	.description("A detailed tool for dynamic and reflective problem-solving through thoughts.\nThis tool helps analyze problems through a flexible thinking process that can adapt and evolve.\nEach thought can build on, question, or revise previous insights as understanding deepens.\n\nWhen to use this tool:\n- Breaking down complex problems into steps\n- Planning and design with room for revision\n- Analysis that might need course correction\n- Problems where the full scope might not be clear initially\n- Problems that require a multi-step solution\n- Tasks that need to maintain context over multiple steps\n- Situations where irrelevant information needs to be filtered out\n\nKey features:\n- You can adjust total_thoughts up or down as you progress\n- You can question or revise previous thoughts\n- You can add more thoughts even after reaching what seemed like the end\n- You can express uncertainty and explore alternative approaches\n- Not every thought needs to build linearly - you can branch or backtrack\n- Generates a solution hypothesis\n- Verifies the hypothesis based on the Chain of Thought steps\n- Repeats the process until satisfied\n- Provides a correct answer\n\nParameters explained:\n- thought: Your current thinking step, which can include:\n  * Regular analytical steps\n  * Revisions of previous thoughts\n  * Questions about previous decisions\n  * Realizations about needing more analysis\n  * Changes in approach\n  * Hypothesis generation\n  * Hypothesis verification\n- nextThoughtNeeded: True if you need more thinking, even if at what seemed like the end\n- thoughtNumber: Current number in sequence (can go beyond initial total if needed)\n- totalThoughts: Current estimate of thoughts needed (can be adjusted up/down)\n- isRevision: A boolean indicating if this thought revises previous thinking\n- revisesThought: If is_revision is true, which thought number is being reconsidered\n- branchFromThought: If branching, which thought number is the branching point\n- branchId: Identifier for the current branch (if any)\n- needsMoreThoughts: If reaching end but realizing more thoughts needed\n\nYou should:\n1. Start with an initial estimate of needed thoughts, but be ready to adjust\n2. Feel free to question or revise previous thoughts\n3. Don't hesitate to add more thoughts if needed, even at the \"end\"\n4. Express uncertainty when present\n5. Mark thoughts that revise previous thinking or branch into new paths\n6. Ignore information that is irrelevant to the current step\n7. Generate a solution hypothesis when appropriate\n8. Verify the hypothesis based on the Chain of Thought steps\n9. Repeat the process until satisfied with the solution\n10. Provide a single, ideally correct answer as the final output\n11. Only set next_thought_needed to false when truly done and a satisfactory answer is reached")
	.usage("--thought <thought> --next-thought-needed <next-thought-needed:true|false> --thought-number <thought-number> --total-thoughts <total-thoughts> [--is-revision <is-revision:true|false>] [--raw <json>]")
	.option('--raw <json>', 'Provide raw JSON arguments to the tool, bypassing flag parsing.')

	.requiredOption("--thought <thought>", "Your current thinking step")
	.requiredOption("--next-thought-needed <next-thought-needed:true|false>", "Whether another thought step is needed (example: true)", (value) => value !== 'false')
	.requiredOption("--thought-number <thought-number>", "Current thought number (numeric value, e.g., 1, 2, 3)")
	.requiredOption("--total-thoughts <total-thoughts>", "Estimated total thoughts needed (numeric value, e.g., 5, 10)")
	.option("--is-revision <is-revision:true|false>", "Whether this revises previous thinking (example: true)", (value) => value !== 'false')
	.option("--revises-thought <revises-thought>", "Which thought is being reconsidered")
	.option("--branch-from-thought <branch-from-thought>", "Branching point thought number")
	.option("--branch-id <branch-id>", "Branch identifier (example: example-id)")
	.option("--needs-more-thoughts <needs-more-thoughts:true|false>", "If more thoughts are needed (example: true)", (value) => value !== 'false')
	.action(async (cmdOpts) => {
		const globalOptions = program.opts();
		const runtime = await ensureRuntime();
		const serverName = embeddedName;
		const proxy = createServerProxy(runtime, serverName, {
			initialSchemas: embeddedSchemas,
		});
		try {
			const args = cmdOpts.raw ? JSON.parse(cmdOpts.raw) : ({} as Record<string, unknown>);
			if (cmdOpts.thought !== undefined) args.thought = cmdOpts.thought;
		if (cmdOpts.nextThoughtNeeded !== undefined) args.nextThoughtNeeded = cmdOpts.nextThoughtNeeded;
		if (cmdOpts.thoughtNumber !== undefined) args.thoughtNumber = parseInt(cmdOpts.thoughtNumber, 10);
		if (cmdOpts.totalThoughts !== undefined) args.totalThoughts = parseInt(cmdOpts.totalThoughts, 10);
		if (cmdOpts.isRevision !== undefined) args.isRevision = cmdOpts.isRevision;
		if (cmdOpts.revisesThought !== undefined) args.revisesThought = parseInt(cmdOpts.revisesThought, 10);
		if (cmdOpts.branchFromThought !== undefined) args.branchFromThought = parseInt(cmdOpts.branchFromThought, 10);
		if (cmdOpts.branchId !== undefined) args.branchId = cmdOpts.branchId;
		if (cmdOpts.needsMoreThoughts !== undefined) args.needsMoreThoughts = cmdOpts.needsMoreThoughts;
			const call = (proxy.sequentialthinking as any)(args);
			const result = await invokeWithTimeout(call, globalOptions.timeout || 30000);
			printResult(result, globalOptions.output ?? 'text');
		} finally {
			await runtime.close(serverName).catch(() => {});
		}
	})
	.addHelpText('after', () => '\nExample:\n  ' + "mcporter call modelcontextprotocol-server-sequential-thinking.sequentialthinking(...)")
	.addHelpText('afterAll', () => '\n' + "// optional (4): revisesThought, branchFromThought, branchId, needsMoreThoughts" + '\n');

program
	.command('__mcporter_inspect', { hidden: true })
	.description('Internal metadata printer for mcporter inspect-cli.')
	.action(() => {
		const payload = buildMetadataPayload();
		console.log(JSON.stringify(payload, null, 2));
	});

configureToolCommandHelps();

const FORCE_COLOR = process.env.FORCE_COLOR?.toLowerCase();
const forceDisableColor = FORCE_COLOR === '0' || FORCE_COLOR === 'false';
const forceEnableColor = FORCE_COLOR === '1' || FORCE_COLOR === 'true' || FORCE_COLOR === '2' || FORCE_COLOR === '3';
const hasNoColor = process.env.NO_COLOR !== undefined;
const stdoutStream = process.stdout as NodeJS.WriteStream | undefined;
const supportsAnsiColor = !hasNoColor && (forceEnableColor || (!forceDisableColor && Boolean(stdoutStream?.isTTY)));

const tint = {
	bold(text: string): string {
		return supportsAnsiColor ? '[1m' + text + '[0m' : text;
	},
	dim(text: string): string {
		return supportsAnsiColor ? '[90m' + text + '[0m' : text;
	},
	extraDim(text: string): string {
		return supportsAnsiColor ? '[38;5;244m' + text + '[0m' : text;
	},
};

function configureGeneratedCommandHelp(command: Command): void {
	command.configureHelp({
		commandUsage(target) {
			const usage = (target.name() + ' ' + target.usage()).trim() || target.name();
			return supportsAnsiColor ? tint.bold(usage) : usage;
		},
		optionTerm(option) {
			const term = option.flags ?? '';
			return supportsAnsiColor ? tint.bold(term) : term;
		},
		optionDescription(option) {
			const description = option.description ?? '';
			return supportsAnsiColor ? tint.extraDim(description) : description;
		},
	});
}

function configureToolCommandHelps(): void {
	program.commands.forEach((cmd) => {
		if (cmd.name() === '__mcporter_inspect') {
			return;
		}
		configureGeneratedCommandHelp(cmd);
	});
}

function renderStandaloneHelp(): string {
	const colorfulTitle = tint.bold(embeddedName) + ' ' + tint.dim('— ' + embeddedDescription);
	const plainTitle = embeddedName + ' — ' + embeddedDescription;
	const title = supportsAnsiColor ? colorfulTitle : plainTitle;
	const lines = [title, '', 'Usage: ' + embeddedName + ' <command> [options]', ''];
	if (generatorTools) {
		lines.push(formatEmbeddedTools());
	}
	lines.push('', formatGlobalFlags(), '', formatQuickStart());
	if (generatorInfo) {
		lines.push('', tint.extraDim(generatorInfo));
	}
	return lines.join('\n');
}

program.helpInformation = () => renderStandaloneHelp();

function formatEmbeddedTools(): string {
	const header = supportsAnsiColor ? tint.bold('Embedded tools') : 'Embedded tools';
	if (!generatorTools.length) {
		return header;
	}
	const lines = [header];
	generatorTools.forEach((entry) => {
		const renderedDesc = entry.description
			? supportsAnsiColor
				? tint.extraDim(entry.description)
				: entry.description
			: undefined;
		const base = renderedDesc ? entry.name + ' - ' + renderedDesc : entry.name;
		lines.push('  ' + base);
		if (entry.flags) {
			const renderedFlags = supportsAnsiColor ? tint.extraDim(entry.flags) : entry.flags;
			lines.push('    ' + renderedFlags);
		}
		lines.push('');
	});
	if (lines[lines.length - 1] === '') {
		lines.pop();
	}
	return lines.join('\n');
}

function formatGlobalFlags(): string {
	const header = supportsAnsiColor ? tint.bold('Global flags') : 'Global flags';
	const entries = [
		['-t, --timeout <ms>', 'Call timeout in milliseconds'],
		['-o, --output <format>', 'text | markdown | json | raw (default text)'],
	];
	const formatted = entries.map(([flag, summary]) => '  ' + flag.padEnd(28) + summary);
	return [header, ...formatted].join('\n');
}

function formatQuickStart(): string {
  const header = supportsAnsiColor ? tint.bold('Quick start') : 'Quick start';
  const examples = quickStartExamples();
  if (!examples.length) {
    return header;
  }
  const formatted = examples.map(([cmd, note]) => '  ' + cmd + '\n    ' + tint.dim('# ' + note));
  return [header, ...formatted].join('\n');
}

function quickStartExamples(): Array<[string, string]> {
  const examples: Array<[string, string]> = [];
  const commandMap = new Map<string, string>();
  program.commands.forEach((cmd) => {
    const name = cmd.name();
    if (name !== '__mcporter_inspect') {
      commandMap.set(name, name);
    }
  });
  const embedded = Array.isArray(generatorTools) ? generatorTools : [];
  for (const entry of embedded.slice(0, 3)) {
    const commandName = commandMap.get(entry.name) ?? entry.name;
    const flags = entry.flags ? ' ' + entry.flags.replace(/<[^>]+>/g, '<value>') : '';
    examples.push([embeddedName + ' ' + commandName + flags, 'invoke ' + commandName]);
  }
  if (!examples.length) {
    examples.push([embeddedName + ' <tool> --key value', 'invoke a tool with flags']);
  }
  return examples;
}

function printResult(result: unknown, format: string) {
	const wrapped = createCallResult(result);
	switch (format) {
		case 'json': {
			const json = wrapped.json();
			if (json) {
				console.log(JSON.stringify(json, null, 2));
				return;
			}
			break;
		}
		case 'markdown': {
			const markdown = wrapped.markdown();
			if (markdown) {
				console.log(markdown);
				return;
			}
			break;
		}
		case 'raw': {
			console.log(JSON.stringify(wrapped.raw, null, 2));
			return;
		}
	}
	const text = wrapped.text();
	if (text) {
		console.log(text);
	} else {
		console.log(JSON.stringify(wrapped.raw, null, 2));
	}
}

function normalizeEmbeddedServer(server: typeof embeddedServer) {
	const base = { ...server } as Record<string, unknown>;
	if ((server.command as any).kind === 'http') {
		const urlRaw = (server.command as any).url;
		const urlValue = typeof urlRaw === 'string' ? urlRaw : String(urlRaw);
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				url: new URL(urlValue),
			},
		};
	}
	if ((server.command as any).kind === 'stdio') {
		return {
			...base,
			command: {
				...(server.command as Record<string, unknown>),
				args: [ ...((server.command as any).args ?? []) ],
			},
		};
	}
	return base;
}

function determineArtifactKind(): 'template' | 'bundle' | 'binary' {
	const scriptPath = typeof process !== 'undefined' && Array.isArray(process.argv) ? process.argv[1] ?? '' : '';
	if (scriptPath.endsWith('.ts')) {
		return 'template';
	}
	if (scriptPath.endsWith('.js')) {
		return 'bundle';
	}
	return 'binary';
}

function resolveArtifactPath(): string {
	if (typeof process !== 'undefined' && Array.isArray(process.argv) && process.argv.length > 1) {
		const script = process.argv[1];
		if (script) {
			return script;
		}
	}
	return embeddedMetadata.artifact.path;
}

function buildMetadataPayload() {
	const invocation = { ...embeddedMetadata.invocation };
	const path = resolveArtifactPath();
	if (artifactKind === 'template' && path) {
		invocation.outputPath = invocation.outputPath ?? path;
	} else if (artifactKind === 'bundle' && path) {
		invocation.bundle = invocation.bundle ?? path;
	} else if (artifactKind === 'binary' && path) {
		invocation.compile = invocation.compile ?? path;
	}
	return {
		...embeddedMetadata,
		artifact: {
			path,
			kind: artifactKind,
		},
		invocation,
	};
}

async function ensureRuntime(): Promise<Awaited<ReturnType<typeof createRuntime>>> {
	return await createRuntime({
		servers: [normalizeEmbeddedServer(embeddedServer)],
	});
}

async function invokeWithTimeout<T>(call: Promise<T>, timeout: number): Promise<T> {
	if (!Number.isFinite(timeout) || timeout <= 0) {
		return await call;
	}
	let timer: ReturnType<typeof setTimeout> | undefined;
	try {
		return await Promise.race([
			call,
			new Promise<never>((_, reject) => {
				timer = setTimeout(() => {
					reject(new Error('Call timed out after ' + timeout + 'ms.'));
				}, timeout);
			}),
		]);
	} finally {
		if (timer) {
			clearTimeout(timer);
		}
	}
}

async function runCli(): Promise<void> {
	const args = process.argv.slice(2);
	if (args.length === 0) {
		program.outputHelp();
		return;
	}
	await program.parseAsync(process.argv);
}

if (process.env.MCPORTER_DISABLE_AUTORUN !== '1') {
	runCli().catch((error) => {
		const message = error instanceof Error ? error.message : String(error);
		console.error(message);
		process.exit(1);
	});
}
