---
name: map-worker
description: Contract-based MapReduce worker for executing a task (may be broad) under optional hint_paths, producing a narrative report. Use when an orchestrator invokes a map worker (llm_query role) many times in parallel and needs mergeable narrative reports.
---

# Map Worker

## Overview

Execute exactly one task (may be broad), then write a narrative report that an orchestrator can synthesize.

## Invocation Contract

The only required behavior is: **write a narrative report to `report_path`.**

Fields an orchestrator may provide (only `report_path` is required):

- `run_id`: string (stable identifier for this run)
- `worker_id`: string (unique per worker within the run)
- `mode`: `"map"` or `"verify"`
- `goal` or `intent`: string (may be broad; stay aligned with it)
- `hint_paths` (optional): list of suggested starting paths (hints only)
- `report_path`: string (**required**) path to the narrative report to write

## Run Contract (must comply when provided)

Orchestrators may provide a run-level contract document (often at):
`.rlm/runs/<run_id>/artifacts/context/run_contract.md`

When a run contract path is provided (explicitly in the prompt, or included in `hint_paths`):

1) **Read it first** (before starting substantive work).
2) Follow its constraints (scope boundaries, invariants, sequencing rules, verification requirements).
3) Include a **“Contract Compliance”** section in your narrative report stating:
   - Whether you read the contract (and the path)
   - Which constraints you applied
   - Any deviations (with justification)
   - Any requested contract updates / open risks
   - The verification/runtime environment you used (interpreter + key env vars + CWD) when running commands

#### Recommended invocation envelope (example)

```json
{
  "run_id": "run_20260103T120000Z_example",
  "worker_id": "w003",
  "mode": "map",
  "goal": "Assess how Foo.bar is used and propose a safe refactor or documentation update.",
  "hint_paths": [".rlm/runs/run_20260103T120000Z_example/", "src/"],
  "report_path": ".rlm/runs/run_20260103T120000Z_example/artifacts/reports/w003.md"
}
```

### Scope bounding (soft)

- If `hint_paths` are provided, treat them as hints for initial scope.
- If you go beyond provided `hint_paths`, mention it briefly in the narrative report (what expanded and why). No need to pre-request permission; proceed if it is necessary to achieve the goal.

### Action scope (soft)

- If the prompt includes requested actions/outputs, treat them as hints (not hard constraints).
- If you need to do something outside the described actions, document it in the narrative report (what you did and why).
- Include any executed commands verbatim (and key outputs) in the narrative report.

### Goal alignment

- Stay aligned with `goal`/`intent`.
- Do not invent missing facts; mark uncertainty explicitly.

## Execution Workflow

1. Understand the `goal`/`intent` (if provided).
2. Do the work, preferring verifiable evidence (file paths + line refs, command output, stats).
3. Write the narrative report to `report_path` (if you cannot complete within budget, write a self-termination report and stop).
4. Keep the chat response minimal (ideally: report path).

## Output Contract

Produce one narrative report per invocation.

## Narrative Report Guidelines

- Write a short, structured report (headings allowed) that includes:
  - What you did
  - Key findings or changes
  - Evidence references (file paths + line refs when applicable)
  - Open questions / risks (include any requested scope expansion here)
  - Deferred opportunities (out-of-scope improvements worth capturing)
- If a run contract was provided, include a **“Contract Compliance”** section (see above).
- Avoid mixing axes: if you notice worthwhile but out-of-scope improvements, prefer capturing them under **Deferred opportunities** instead of implementing them (unless the run contract explicitly scopes them in).
- Optional: if the orchestrator requests progress updates, append brief progress notes to the report (or a specified progress file). Otherwise, focus on the final report.
- If the prompt includes a concrete progress cadence (e.g., “write a Progress note within ~60s, then every ~5 minutes”), follow it so the orchestrator can detect stalls via file freshness without expanding its own context.
- If you cannot complete the assigned work at acceptable quality within budget, **self-terminate** (do not stall):
  - Still write a report to `report_path` (do not exit silently).
  - Include these headings: `Self-termination`, `Partial results`, `Next worker plan`, `Required scope`.
- If you create intermediate artifacts (scripts, JSON summaries, matrices), keep them under:
  - `.rlm/runs/<run_id>/artifacts/**` (recommended: `.rlm/runs/<run_id>/artifacts/context/<worker_id>.*`)
  - and list artifact paths + reproduce commands in the report.
- If you detect worker-only drift (manual edits, untracked changes outside contract), do not “quietly fix” it:
  - record under `Open questions / risks` or `Deferred opportunities`,
  - and recommend a follow-up **repair/scope-trim** worker; self-terminate if the drift makes your work unreliable.

## Minimal result template

Write a report at `report_path` that follows the narrative report guidelines.
