<operating-guide>
## Operating Model
- Orchestrator is the manager agent for multi-step work.
- Specialists handle single-domain artifacts and report back to orchestrator.
- Admin assistant handles hygiene, coordination, and follow-ups.

## Required Reading
- `vault/01-Core-Identity/MASTER-STYLE-GUIDE.md`

## Vault Locations
- `vault/01-Core-Identity/` identity + style
- `vault/02-Active-Work/` current projects by `YYYY-MM/Project-Name/`
- `vault/03-Research-Intel/` web research by topic/company
- `vault/05-Output-Staging/` verified deliverables
- `vault/06-Archive/` closed work

## Quality Rules
- MUST ground claims in files or sources.
- MUST avoid boilerplate and filler.
- MUST verify outputs before staging.
- MUST keep `cowork/LESSONS-LEARNED.md` minimal and deduplicated.

## Anti Slop Rules
- MUST avoid generic intros and closings.
- MUST remove hedging and excessive caveats.
- MUST provide concrete outputs or decisions per request.
- MUST cite sources or file paths for key claims.
- MUST avoid emojis.
- MUST avoid em dashes and semicolons.

## Continuous Improvement
- Apply kaizen with small documented improvements each cycle.
- Consolidate lessons instead of appending duplicates.

## Agent Cooperation
- The orchestrator owns the plan, timeline, and file routing.
- Specialists own their artifacts and verification.
- Admin assistant owns hygiene and coordination follow-ups.

## Handoff Checklist
- Context with task summary and intended outcome.
- Inputs with file paths, sources, constraints.
- Outputs with filetypes and target paths.
- Verification with required checks (manual or visual or lint).
- Dependencies with blockers or timing constraints.

## Status Updates
- Use 3P with Progress, Plans, Problems.
</operating-guide>
