# Brand Guidelines Reference

## Quick Reference Card

### Must-Have Elements
✅ Company logo on first page/slide
✅ Correct brand colors (no variations)
✅ Approved fonts only
✅ Consistent formatting throughout
✅ Professional tone of voice

### Never Use
❌ Competitor logos or references
❌ Unapproved colors or gradients
❌ Decorative or script fonts
❌ Pixelated or stretched logos
❌ Informal language or slang

## Color Codes Reference

### For Digital (RGB/Hex)
| Color Name | Hex Code | RGB | Usage |
|------------|----------|-----|-------|
| Acme Blue | #0066CC | 0, 102, 204 | Primary headers, CTAs |
| Acme Navy | #003366 | 0, 51, 102 | Body text, secondary |
| Success Green | #28A745 | 40, 167, 69 | Positive values |
| Warning Amber | #FFC107 | 255, 193, 7 | Warnings, attention |
| Error Red | #DC3545 | 220, 53, 69 | Errors, negative |
| Neutral Gray | #6C757D | 108, 117, 125 | Muted text |
| Light Gray | #F8F9FA | 248, 249, 250 | Backgrounds |

### For Print (CMYK)
| Color Name | CMYK | Pantone |
|------------|------|---------|
| Acme Blue | 100, 50, 0, 20 | 2935 C |
| Acme Navy | 100, 50, 0, 60 | 2965 C |

## Document Templates

### Email Signature
```
[Name]
[Title]
Acme Corporation | Innovation Through Excellence
[Phone] | [Email]
www.acmecorp.example
```

### Slide Footer
```
© 2025 Acme Corporation | Confidential | Page [X]
```

### Report Header
```
[Logo]     [Document Title]     Page [X] of [Y]
```

## Accessibility Standards

### Color Contrast
- Text on white background: Use Acme Navy (#003366)
- Text on blue background: Use white (#FFFFFF)
- Minimum contrast ratio: 4.5:1 for body text
- Minimum contrast ratio: 3:1 for large text

### Font Sizes
- Minimum body text: 11pt (print), 14px (digital)
- Minimum caption text: 9pt (print), 12px (digital)

## File Naming Conventions

### Standard Format
```
YYYY-MM-DD_DocumentType_Version_Status.ext
```

### Examples
- `2025-01-15_QuarterlyReport_v2_FINAL.pptx`
- `2025-01-15_BudgetAnalysis_v1_DRAFT.xlsx`
- `2025-01-15_Proposal_v3_APPROVED.pdf`

## Common Mistakes to Avoid

1. **Wrong Blue**: Using generic blue instead of Acme Blue #0066CC
2. **Stretched Logo**: Always maintain aspect ratio
3. **Too Many Colors**: Stick to the approved palette
4. **Inconsistent Fonts**: Don't mix font families
5. **Missing Logo**: Always include on first page
6. **Wrong Date Format**: Use "Month DD, YYYY"
7. **Decimal Places**: Be consistent (currency: 2, percentage: 1)

## Department-Specific Guidelines

### Finance
- Always right-align numbers in tables
- Use parentheses for negative values: ($1,234)
- Include data source citations

### Marketing
- Can use full secondary color palette
- May include approved imagery
- Follow social media specific guidelines when applicable

### Legal
- Use numbered sections (1.0, 1.1, 1.2)
- Include document control information
- Apply "Confidential" watermark when needed

## International Considerations

### Date Formats by Region
- **US**: Month DD, YYYY (January 15, 2025)
- **UK**: DD Month YYYY (15 January 2025)
- **ISO**: YYYY-MM-DD (2025-01-15)

### Currency Display
- **USD**: $1,234.56
- **EUR**: €1.234,56
- **GBP**: £1,234.56

## Version History

| Version | Date | Changes |
|---------|------|---------|
| 2.0 | Jan 2025 | Added digital color codes |
| 1.5 | Oct 2024 | Updated font guidelines |
| 1.0 | Jan 2024 | Initial brand guidelines |

## Contact for Questions

**Brand Team**
Email: brand@acmecorp.example
Slack: #brand-guidelines

**For Exceptions**
Submit request to brand team with business justification