---
name: codex
description: Get alternative perspectives via OpenAI Codex on complex design decisions, architecture trade-offs, stuck debugging, or approach evaluation.
user-invocable: true
---

# Codex Dialogue

異なるAIモデル（OpenAI Codex）の視点を得て、思考の精度を高めるためのスキル。

## いつ使うか

以下の状況で自動的に発動する：

1. **設計判断で迷いがある時**
   - 複数のアプローチがあり、どれが最適か判断が難しい
   - トレードオフの評価に自信がない

2. **問題が難航している時**
   - デバッグが行き詰まっている
   - 原因の特定に時間がかかっている
   - 試したアプローチが全て失敗した

3. **重要な決定をする時**
   - アーキテクチャの選定
   - 破壊的変更の判断
   - セキュリティに関わる実装

## 使い方

### 1. 問題を明確に言語化する

Codexに渡すプロンプトには以下を含める：

- 現在の状況・コンテキスト
- 試したこと・考えたこと
- 具体的に意見が欲しい点

### 2. Codexセッションを開始

```
mcp__codex__codex({
  prompt: "問題の説明と質問",
  cwd: "作業ディレクトリ",
  sandbox: "read-only"  // 基本はread-only
})
```

### 3. 両方の視点を統合

Codexの回答を受け取ったら：
- Claude Codeの考えと比較
- 共通点と相違点を分析
- 最終的な判断を導出

## プロンプトテンプレート

### 設計判断

```
現在、[機能名]の実装を検討しています。

コンテキスト:
- [技術スタック、制約条件]

検討中のアプローチ:
A) [アプローチA]
B) [アプローチB]

私の現時点での考え:
- [Claude Codeとしての分析]

以下の観点で意見をください:
- 見落としているリスクはないか
- より良いアプローチはないか
- 長期的な保守性の観点
```

### 難航している問題

```
以下の問題で行き詰まっています。

症状:
- [エラーメッセージ、挙動]

試したこと:
1. [試行1] → [結果]
2. [試行2] → [結果]

関連コード:
[コードスニペット]

別の角度からの調査アプローチを提案してください。
```

## 注意

- Codexの意見は参考情報として扱う
- 最終判断はClaude Codeが行う
- 両者の意見が異なる場合は、その理由を分析してユーザーに提示する
