# API Design Review

## 検出条件

- `src/api/` ディレクトリが存在
- `src/api/routes/` ディレクトリが存在
- `app/api/` ディレクトリが存在

## 対象ファイル

- `src/api/routes/*.ts`
- `src/api/middlewares/*.ts`
- `src/api/app.ts`

## レビュー観点

### ルート設計

- RESTful な命名規則に従っているか
- エンドポイントの粒度が適切か
- リソース指向の設計になっているか

### エラーハンドリング

- 一貫したエラーレスポンス形式か
- 適切な HTTP ステータスコードを使用しているか
- エラーメッセージが有用か

### バリデーション

- 入力バリデーションが適切か
- Zod などのスキーマバリデーションを使用しているか
- バリデーションエラーのレスポンスが明確か

### 認証・認可

- 認証ミドルウェアが適切に適用されているか
- 認可チェックが適切か
- 機密エンドポイントが保護されているか

### レスポンス形式

- 一貫したレスポンス構造か
- 型安全性が確保されているか
- 必要な情報が含まれているか

## 出力ファイル

`.claude/notes/reviews/api-design.md`
