# Components Review

## 検出条件

- `src/components/` ディレクトリが存在

## 対象ファイル

- `src/components/**/*.tsx`
- `src/components/ui/*.tsx`

## レビュー観点

### 責務分離

- 単一責任原則に従っているか
- ビジネスロジックと UI が分離されているか
- 適切な粒度でコンポーネントが分割されているか

### Props 設計

- Props の型定義が明確か
- オプショナルな Props が適切に設計されているか
- コールバック Props の命名が一貫しているか

### 再利用性

- 汎用コンポーネントが適切に抽出されているか
- ハードコードされた値がないか
- 設定可能な部分が Props で公開されているか

### 状態管理

- ローカル状態とグローバル状態の使い分けが適切か
- 不要な再レンダリングが発生していないか
- 状態のリフトアップが適切か

### アクセシビリティ

- セマンティックな HTML を使用しているか
- ARIA 属性が適切に設定されているか
- キーボード操作に対応しているか

## 出力ファイル

`.claude/notes/reviews/components.md`
