# Tests Review

## 検出条件

- `tests/` ディレクトリが存在
- `src/**/*.test.{ts,tsx}` が存在
- `vitest.config.ts` または `playwright.config.ts` が存在

## 対象ファイル

- `tests/` ディレクトリ
- `src/**/*.test.{ts,tsx}`
- `vitest.config.ts`
- `playwright.config.ts`

## レビュー観点

### テスト構成

- テストランナーの選定が適切か
- 設定ファイルが正しく構成されているか
- テストの分類（ユニット、統合、E2E）が明確か

### カバレッジ

- 主要な機能がテストされているか
- API ルートにテストがあるか
- コアロジック（認証、投稿など）がカバーされているか

### テスト品質

- 正常系・異常系・境界値がテストされているか
- テスト名が意図を明確に示しているか
- モックの使用が適切か

### コンポーネントテスト

- Testing Library のベストプラクティスに従っているか
- ユーザーインタラクションがテストされているか
- アクセシビリティを考慮したセレクタを使用しているか

### E2Eテスト

- ユーザーストーリーに沿っているか
- セレクタが安定しているか（data-testid の使用）
- テストの独立性が保たれているか

## 出力ファイル

`.claude/notes/reviews/tests.md`
