# アプリケーション関連

振る舞い・ユースケースのファイル群。

## policies/permissions.md

認証/認可のルール。

書くこと:

- 権限マトリクス（操作 × ロール）
- 権限設計の理由
- 認証ルール（招待制、パスワードポリシー等）

## policies/{policy}.md

横断的な制約やルール。制約の種類ごとにファイルを作成。

例:

- security.md - セキュリティルール
- data-retention.md - データ保持ポリシー
- notification.md - 通知ルール
- rate-limits.md - レート制限
- content-limits.md - コンテンツ制限

## services/{aggregate}.md

集約ごとのサービス。操作対象（集約）で分類する。

各ユースケースに書くこと:

- 何ができるか（機能）
- 制約（事前条件、ビジネスルール）
- 副作用（通知、イベント発火など）

制約の書き分け:

- ユースケース固有の制約 → そのユースケース内に書く
- 複数ユースケースに共通する制約 → policies/{policy}.md に書く

## services/workflows.md（任意）

複数サービスにまたがるワークフロー。横断フローが3つ以上、または複雑な場合に作成。

## processes.md

バックグラウンド処理。定期ジョブ、自動処理など。
