# experience/

ユーザー体験関連のファイル群。

**Web のみ / Web + API で作成する。API のみでは作成しない。**

API のみの製品は開発者向けであり、エンドユーザーのペルソナやストーリーは通常不要。

## personas.md

ユーザーのペルソナ定義。「誰のために作るか」を明確にする。

## stories/{story}.md

ユーザーの体験フロー。動作確認やE2Eテストのシナリオとして使用可能な粒度で記述する。

### 作成方針

2つの観点からストーリーを作成する:

**ペルソナベース**

各ペルソナの典型的な行動をストーリー化。FrontMatterに `persona:` を記載。

例:
- チケット購入フロー
- 子連れでの来園計画
- 多言語での情報確認
- 団体申込み

**テスト観点**

品質保証の観点からストーリーを作成。FrontMatterに `test-aspect:` を記載。

例:
- 多言語切り替え
- エラーハンドリング（API障害、404）
- ナビゲーション（ヘッダー、パンくず、フッター）
- 営業情報確認

### フォーマット

```markdown
---
updated-at: YYYY-MM-DD
persona: ペルソナ名（またはtest-aspect: 観点名）
---

# ストーリー名

ストーリーの目的を1文で。

## フロー

ユーザーの行動と心理を記述。

## 設計意図

なぜこのフローにしたか。

## 動作確認ステップ

### 前提条件

- テストに必要なアカウントやデータの条件

### ステップ

- 操作と期待結果を箇条書きで記述
- 1行1操作
- ユーザーが見える言葉で書く
```

### 書くこと

- ユーザーの行動フロー（心理の変化を含む）
- 設計意図（なぜこのフローにしたか）
- 動作確認ステップ（agent-browser で実行可能な粒度）
- 期待される結果
- ページ遷移やUI要素の確認ポイント

### 書かないこと

- 実装の詳細
- テストコード
- CSS セレクタや API パス
