# glossary.md

製品・事業のドメイン用語（ユビキタス言語）とコードの対応表。

## 記載する内容

ビジネス・ドメインの用語のみ:

- 製品固有の概念（プレミアムパス、やんばる など）
- 業務用語（チケット、アトラクション、予約 など）
- ユーザーが使う言葉
- ステークホルダーとの共通言語

## 記載しない内容

技術用語は含めない:

- フレームワーク用語（SSR、ルーティング など）
- ファイル命名規則
- コーディング規約
- API 仕様

これらは `architecture/` に記載する。

## フォーマット

見出しに「日本語名 - PascalCase」、本文に説明。

```markdown
## プレミアムパス - PremiumPass

アトラクションの優先入場権。通常チケットとは別に購入する。
```

## なぜテーブルではなく見出しか

- 検索しやすい
- 説明を複数行書ける
- 拡張しやすい

## 用語集の位置付け

コードと完全に一致しなくてもいい。用語集が正で、コードを合わせる。
