# インフラストラクチャ関連

DB設計・外部連携・運用のファイル群。

## database.md

スキーマ設計の意図。

書くこと:

- 正規化/非正規化の判断理由
- インデックス戦略
- パーティション/シャーディング戦略

スキーマ自体はコードから読めるので、「なぜ」を中心に書く。

## operations.md

運用に関する設計意図。

書くこと:

- 監視戦略（何を監視するか、なぜそのメトリクスか）
- アラート設計（閾値の根拠、エスカレーション）
- デプロイ戦略（Blue-Green、カナリア等の選定理由）
- 障害対応フロー（なぜこの手順か）

具体的な設定値や手順書はコードやRunbookに書く。ここには「なぜ」を書く。

## integrations/{service}.md

外部サービスとの連携。サービスごとに1ファイル。

書くこと:

- どの機能を利用しているか
- 選定理由
- 設定や注意点

例: stripe.md, sendgrid.md, aws-s3.md
