# インターフェース関連

画面・機能・API のファイル群。

## sitemap.md

サイトマップ。全ルートをフラットな箇条書きで記載する。

書くこと:

- 全ルートをフラットに列挙（主要ルートだけでなく全て）
- 各ルートに簡潔な説明（ハイフン区切り）

フォーマット:

```
- /path - 説明
- /path/child - 説明
```

ルートの書き方:

- 多言語プレフィックスは `/$lang` として変数化
- 動的パラメータは `/$id` や `/$postId` のように変数化
- 404などの特殊ルートも含める
- 木構造の記号（├──、└──）は使わない

書かないこと:

- ナビゲーション設計（グローバルナビ、パンくずなど）
- 画面構成の方針や導線設計
- 多言語対応の説明（変数化で十分）

## api.md

API設計の意図。

書くこと:

- エンドポイントの構造方針
- なぜそのURL設計か
- リソースの分割方針

エンドポイント一覧はコードから読めるので、「なぜ」を中心に書く。

## features/{feature}.md

機能ごとの概要・目的。1機能1ファイル。

書くこと:

- 機能の目的（なぜこの機能があるか）
- 機能の概要（箇条書き）

フォーマット: `- 機能名 - 説明`

## pages/{route}.md

画面ごとの設計意図。TanStack Router のフラットルート形式でファイル名を付ける。

重要: 全ルートファイルに対応するドキュメントを作成すること。

ファイル名の例:

- `index.md` - トップページ
- `posts.md` - 投稿一覧
- `posts.$postId.md` - 投稿詳細
- `admin.users.md` - 管理画面 > ユーザー管理

### フォーマット

```markdown
---
updated-at: YYYY-MM-DD
---

# ページ名

ページの目的を1-2文で書く。

- 機能や構成要素を箇条書きで列挙
- コードを読めばわかる内容は最小限に

## 注意事項のタイトル

コードから読み取れない注意事項があれば、それぞれ見出しにして書く。

---

[^1]: YYYY-MM-DD - 開発の背景や判断理由
```

### 書くこと

- ページの目的（見出し1の直下に）
- 機能・構成の概要（箇条書き）
- コードから読み取れない注意事項（個別の見出しで）
- 開発の背景・判断理由（脚注）

### 書かないこと

- データソース（コードから読める）
- 詳細な実装内容（コードから読める）
- 「目的」「概要」などの冗長な見出し
