# tests/

手動テスト仕様のファイル群。`.docs/tests/` に配置する。

**Web アプリケーションで作成する。**

テスト仕様書は人間のテスターがブラウザで実行する手順書。UIラベル・ボタン名・ナビゲーション名は実際のコードと完全に一致させる。

## tests/{category}.md

機能カテゴリごとのテスト仕様。1カテゴリ1ファイル。

### 作成方針

以下の観点でカテゴリを分ける:

- 認証・権限 (auth-and-permissions.md)
- コア機能 (core-features.md)
- 管理機能 (admin-management.md)
- セキュリティ (visibility.md など)

### フォーマット

```markdown
---
updated-at: YYYY-MM-DD
priority: high | medium | low
category: security | functional | ...
---

# カテゴリ名 動作確認

目的を1文で。

## テストアカウント

| 名前 | ログイン | ロール |
|---|---|---|
| ... | ... | ... |

## テスト1: テスト名

- 操作手順を箇条書き
- 1行1操作
- ボタン名は実際のUI表示と完全一致させる
- 期待結果は「〜が表示される」「〜が表示されないことを確認する」

### 期待結果

期待結果の要約。
```

### 書くこと

- テストアカウント情報
- 操作手順（1行1操作、ユーザーが見える言葉で）
- 期待結果
- 前提条件（テストデータの準備手順）

### 書かないこと

- CSS セレクタやコードの参照
- API エンドポイント
- 実装の詳細

### UIラベル同期ルール

テスト仕様書のボタン名・メニュー名・バッジ名は、実際のコンポーネントの表示テキストと完全に一致させる。コード変更でUIラベルが変わったら、テスト仕様書も必ず更新する。

確認対象:

- ボタンのラベル（投稿ボタン、公開範囲ボタンなど）
- サイドバーのナビゲーション名
- バッジの表示テキスト
- ダイアログのタイトル・ボタン
- ポート番号（開発サーバーの設定と一致させる）

### E2Eテストとの同期

`.docs/tests/` の手動テスト仕様と `tests/` の E2E テストコードで、ボタン名やセレクタが一致していることを確認する。E2E テストの `getByRole("button", { name: "..." })` のラベルは手動テスト仕様のボタン名と同じであること。
