# ルール

## メタ情報を書かない

```markdown
# Bad
このドキュメントは〇〇を記録する。

# Good
（本文から始める）
```

## コードから読める情報を書かない

```markdown
# Bad
| 属性 | 型 |
| department | string? |

# Good
### 所属を任意にした理由
派遣社員や兼務者など、明確な所属がない人もいる。
```

## 「なぜ」を中心に書く

ルール、設計判断、技術選定には必ず理由を書く。

## 関連ファイルへのリンクを書かない

他のファイルへのリンクは禁止。メンテナンスコストが上がるため。

```markdown
# Bad
→ [services/post.md](application/services/post.md)

# Bad
## 関連サービス
- services/user.md

# Good
（書かない。構成は SKILL.md に定義済み）
```

## 冗長な見出しを使わない

```markdown
# Bad
## なぜこの順番か
## なぜ2ロールか

# Good
## 設計意図
（本文で自然に説明する）
```

## 文章と脚注

本文は自然な文章で決定事項を書く。設計判断の経緯は脚注で記録する。

脚注は常にファイル末尾に `---` で区切ってまとめて書く。

```markdown
## CreatePost - 投稿を作成する

従業員と管理者が投稿を作成できる。タイプ選択を最初にすることで投稿の目的を明確にする[^1]。

---

[^1]: 2024-01-15 - 自動分類を検討したが精度問題で却下
```

脚注のフォーマット: `YYYY-MM-DD - 理由`
