---
name: gemini
description: Get alternative perspectives via Google Gemini on complex design decisions, architecture trade-offs, stuck debugging, or approach evaluation.
user-invocable: true
---

# Gemini Dialogue

異なるAIモデル（Google Gemini）の視点を得て、思考の精度を高めるためのスキル。

## 前提条件 (Prerequisites)

このスキルを実行するには、以下の環境が整っている必要があります：

- 環境パス（PATH）に `gemini` CLIツールがインストールされていること
- 適切なAPIキーまたは認証情報が設定済みで、CLIが実行可能な状態であること

## いつ使うか

以下の状況で自動的に発動する：

- 設計判断で迷いがある時（複数アプローチのトレードオフ評価）
- 問題が難航している時（デバッグの行き詰まり、原因特定の困難）
- 重要な決定をする時（アーキテクチャ選定、破壊的変更、セキュリティ実装）

## 使い方

### Geminiへの相談

基本コマンド：

```bash
gemini "プロンプト"
```

### コードコンテキストの渡し方（重要）

Geminiにコードを読ませる場合は、以下の方法を使用する。シェルでのエスケープエラーを防ぐため、**パイプ入力**や**ファイル指定オプション**を優先する。

**1. パイプ入力（推奨：エスケープ問題を回避）**
ファイルの中身を標準入力として渡す：

```bash
cat src/feature.ts | gemini "このコードの潜在的なバグを指摘して"
```

**2. コンテキストオプション（CLIがサポートしている場合）**
ファイルパスを明示的に指定する：

```bash
gemini "リファクタリング案を出して" --context src/App.tsx
```

**3. コマンド置換（短いテキストのみ）**
```bash
gemini "次の設定値の意味を教えて: $(cat config.json)"
```

### オプション

- `-m gemini-2.5-pro` - モデル指定（デフォルトは2.5 Flash）
- `--include-directories ../lib` - ディレクトリごとコンテキストに追加（トークン量に注意）

### セッション引き継ぎ

継続的な議論が必要な場合、前回のセッションを引き継げる：

```bash
gemini -r latest "フォローアップの質問"
```

セッション一覧を確認する場合：

```bash
gemini --list-sessions
```

## 注意事項

- **対話モード禁止**: `-i` フラグは使用しない。Bashツールがタイムアウトするため、常にワンショットで実行する。
- **シェルエスケープ**: プロンプト文字列内に `"`（ダブルクォート）や `$`、バッククォートが含まれるとBashが誤解釈する可能性がある。複雑なプロンプトは外部ファイルに保存してから読み込ませるか、パイプ入力を活用する。
- **機密情報**: `--include-directories` を使用する際は、`.env` ファイルや認証情報が含まれないよう注意する。

## プロンプト構成

Geminiに渡すプロンプトには以下を含める：

- 現在の状況・コンテキスト
- 試したこと・考えたこと
- 具体的に意見が欲しい点

### 回答の統合

Geminiの回答を受け取ったら：

- Claude Codeの考えと比較
- 共通点と相違点を分析
- 最終的な判断を導出

## プロンプトテンプレート

### 設計判断

```
現在、[機能名]の実装を検討しています。

コンテキスト:
- [技術スタック、制約条件]

検討中のアプローチ:
A) [アプローチA]
B) [アプローチB]

私の現時点での考え:
- [Claude Codeとしての分析]

以下の観点で意見をください:
- 見落としているリスクはないか
- より良いアプローチはないか
- 長期的な保守性の観点
```

### 難航している問題

```
以下の問題で行き詰まっています。

症状:
- [エラーメッセージ、挙動]

試したこと:
1. [試行1] → [結果]
2. [試行2] → [結果]

関連コード:
[コードスニペット または ファイル内容]

別の角度からの調査アプローチを提案してください。
```

## 運用ルール

- Geminiの意見は参考情報として扱う
- 最終判断はClaude Codeが行う
- 両者の意見が異なる場合は、その理由を分析してユーザーに提示する
