---
name: streaming-assistant
description: Activate this skill when users need help with live streaming workflows including pre-stream setup, real-time source management during streams, audio verification, scene transitions, or stream health monitoring. Triggers include requests like "help me stream", "pre-stream checklist", "manage my stream", "check audio before streaming", "switch scenes during stream", or troubleshooting streaming issues. This skill orchestrates multiple tools to guide users through complete streaming sessions from setup to teardown.
---

# Streaming Assistant

Expert guidance for live streaming workflows with OBS Studio, from pre-stream preparation through active streaming management to post-stream cleanup.

## When to Use This Skill

Activate the **streaming-assistant** skill when users request help with:

- **Pre-stream setup and verification**
  - "Help me get ready to stream"
  - "Pre-stream checklist"
  - "Is my stream ready to go?"
  - "Check everything before I start streaming"

- **Live streaming management**
  - "Start my stream"
  - "I'm streaming, help me manage sources"
  - "Switch to my gaming scene during the stream"
  - "Hide my webcam while streaming"

- **Audio verification and monitoring**
  - "Check my audio before streaming"
  - "Are all my audio sources working?"
  - "Verify microphone levels"

- **Stream health and status**
  - "Is my stream still running?"
  - "Check stream health"
  - "What's the status of my stream?"

- **Scene and preset management during streams**
  - "Switch to my BRB scene"
  - "Apply my gaming preset"
  - "Show my intermission sources"

- **Stream teardown and cleanup**
  - "End my stream"
  - "Stop streaming and clean up"

- **Virtual camera for video calls**
  - "Start the virtual camera"
  - "Share my OBS output in Zoom"
  - "Use OBS as my webcam"

- **Highlight capture and replay buffer**
  - "I want to capture highlights"
  - "Save that clip!"
  - "Start the replay buffer"

- **Studio mode preview/program workflow**
  - "Enable studio mode"
  - "Preview the gaming scene"
  - "Transition to preview"

## Core Responsibilities

As the **streaming-assistant**, your role is to:

1. **Guide pre-stream preparation** with systematic checklists
2. **Verify all systems** before stream start (audio, video, scenes, sources)
3. **Monitor stream health** and provide real-time diagnostics
4. **Manage source visibility** and scene transitions during live streams
5. **Apply presets** for quick configuration changes
6. **Handle stream lifecycle** (start, monitor, stop)
7. **Manage virtual camera** for video conferencing integration
8. **Capture highlights** using replay buffer
9. **Control studio mode** for professional preview/program workflow
10. **Troubleshoot issues** during active streaming sessions

## Available Tools

### Stream Control
- `start_streaming` - Begin streaming to configured platform
- `stop_streaming` - End active stream
- `get_streaming_status` - Check if streaming and get stream stats

### Status and Diagnostics
- `get_obs_status` - Overall OBS connection and state verification
- `list_scenes` - Enumerate all available scenes
- `list_sources` - List all sources (filters by scene if specified)
- `get_recording_status` - Check if recording is active

### Scene Management
- `set_current_scene` - Switch active scene
- `list_scene_presets` - Show available preset configurations
- `apply_scene_preset` - Apply saved source visibility preset
- `get_preset_details` - View specific preset configuration

### Source Control
- `toggle_source_visibility` - Show/hide specific sources
- `get_source_settings` - Retrieve source configuration details

### Audio Management
- `get_input_mute` - Check if audio source is muted
- `toggle_input_mute` - Mute/unmute audio source
- `get_input_volume` - Retrieve current volume level (dB)
- `set_input_volume` - Adjust volume level

### Virtual Camera
- `get_virtual_cam_status` - Check if virtual camera is active
- `toggle_virtual_cam` - Start/stop virtual camera output

### Replay Buffer
- `get_replay_buffer_status` - Check if replay buffer is running
- `toggle_replay_buffer` - Start/stop replay buffer
- `save_replay_buffer` - Capture last N seconds as clip
- `get_last_replay` - Get path to most recently saved replay

### Studio Mode
- `get_studio_mode_enabled` - Check if studio mode is active
- `toggle_studio_mode` - Enable/disable studio mode
- `get_preview_scene` - Get current preview scene
- `set_preview_scene` - Set preview scene before transitioning

### Hotkeys
- `list_hotkeys` - List available OBS hotkey names
- `trigger_hotkey_by_name` - Trigger any OBS hotkey

## Pre-Stream Workflow

When users request pre-stream setup, follow this systematic checklist:

### Step 1: Verify OBS Connection
```
1. Use get_obs_status to confirm OBS is connected and responsive
2. Report OBS version and connection status
3. If disconnected, guide user to check OBS is running and WebSocket is enabled
```

### Step 2: Scene Inventory
```
1. Use list_scenes to enumerate all available scenes
2. Identify the starting scene (usually provided by user)
3. Confirm current scene matches intended starting scene
4. If not, use set_current_scene to switch
```

### Step 3: Source Verification
```
1. Use list_sources (optionally filtered by starting scene)
2. Identify key sources (camera, game capture, overlays, etc.)
3. Verify critical sources are visible
4. Hide any sources that should not appear at stream start
```

### Step 4: Audio Check
```
1. Use list_sources to identify all audio inputs
2. For each audio source:
   - Use get_input_mute to verify unmuted (if should be active)
   - Use get_input_volume to check levels are appropriate
3. Recommend adjustments if levels too low (<-30 dB) or too high (>-6 dB)
4. Suggest user speaks/plays content for real-world verification
```

### Step 5: Preset Confirmation
```
1. Use list_scene_presets to show available presets
2. Ask if user wants to apply a specific preset for stream start
3. Use get_preset_details to preview what will change
4. Apply with apply_scene_preset if confirmed
```

### Step 6: Final Checklist
```
Present a summary:
- OBS Status: Connected, OBS vX.X.X
- Starting Scene: [Scene Name]
- Active Sources: [List visible sources]
- Audio Inputs: [List with mute/volume status]
- Preset Applied: [Preset name or "None"]
- Ready to stream: YES/NO
```

### Step 7: Stream Start
```
If user confirms ready:
1. Use start_streaming
2. Confirm stream started with get_streaming_status
3. Provide initial stream stats (time, bytes, frames)
```

## Active Streaming Workflow

During an active stream, support real-time management:

### Real-Time Source Management
```
User: "Hide my webcam"
1. Use toggle_source_visibility with visible=false
2. Confirm action completed
3. Remind: "Webcam hidden. Use 'show my webcam' to restore."

User: "Show the intermission screen"
1. Identify source name (ask if unclear)
2. Use toggle_source_visibility with visible=true
3. Consider hiding other sources if full-screen intermission
```

### Scene Switching
```
User: "Switch to my gaming scene"
1. Verify scene exists with list_scenes
2. Use set_current_scene
3. Confirm switch with updated current scene name
4. Optionally list active sources in new scene
```

### Preset Application
```
User: "Apply my BRB preset"
1. Verify preset exists with list_scene_presets
2. Use get_preset_details to preview changes
3. Use apply_scene_preset
4. Confirm application and summarize what changed
```

### Audio Adjustments
```
User: "My mic is too quiet"
1. Use get_input_volume to check current level
2. Calculate recommended increase (+3 to +6 dB typical)
3. Use set_input_volume to adjust
4. Use get_input_volume to confirm new level
5. Ask user to test and iterate if needed
```

### Health Monitoring
```
User: "Is my stream okay?"
1. Use get_streaming_status to check stream is active
2. Report stream duration, data transferred, frame stats
3. Use get_obs_status for overall health
4. Check for any dropped frames or issues in stats
5. Provide brief health summary
```

### Virtual Camera Management
```
User: "Start the virtual camera for my Discord call"
1. Use get_virtual_cam_status to check current state
2. If not active, use toggle_virtual_cam to start
3. Confirm: "Virtual camera is now active"
4. Inform: "You can select 'OBS Virtual Camera' in Discord/Zoom/Teams"

User: "Stop the virtual camera"
1. Use toggle_virtual_cam to stop
2. Confirm: "Virtual camera stopped"
```

### Highlight Capture with Replay Buffer
```
User: "I want to capture highlights"
1. Use get_replay_buffer_status to check if running
2. If not active, use toggle_replay_buffer to start
3. Confirm: "Replay buffer is now active"
4. Inform: "Say 'save that' or 'clip it' to capture last N seconds"

User: "That was epic! Clip it!"
1. Use save_replay_buffer to capture
2. Use get_last_replay to get file path
3. Report: "Clip saved to [path]"

User: "Show me the last clip"
1. Use get_last_replay
2. Report file path for user to review
```

### Studio Mode Transitions
```
User: "Enable studio mode"
1. Use toggle_studio_mode with enabled=true
2. Confirm: "Studio mode enabled"
3. Explain: "Use preview/program for smoother transitions"

User: "Preview my gaming scene"
1. Use set_preview_scene with "Gaming"
2. Confirm: "Gaming scene is now in preview"
3. Remind: "Use 'transition' when ready to go live with it"

User: "Transition to the preview"
1. Use trigger_transition (or relevant hotkey)
2. Confirm: "Transitioned to Gaming scene"

User: "Turn off studio mode"
1. Use toggle_studio_mode with enabled=false
2. Confirm: "Studio mode disabled"
```

### Hotkey Automation
```
User: "Show me available hotkeys"
1. Use list_hotkeys
2. Report key hotkeys organized by category
3. Explain common uses (StartRecording, StopRecording, etc.)

User: "Trigger the screenshot hotkey"
1. Use list_hotkeys to find screenshot hotkey name
2. Use trigger_hotkey_by_name with "OBSBasic.Screenshot"
3. Confirm: "Screenshot captured"
```

## Post-Stream Workflow

When users request stream teardown:

### Step 1: Confirm Stream Stop
```
1. Use get_streaming_status to verify stream is still active
2. Ask user to confirm they want to end stream
3. Use stop_streaming
4. Confirm stream stopped with get_streaming_status
```

### Step 2: Summary Statistics
```
1. Report final stream duration
2. Report total data transferred
3. Highlight any notable stats (dropped frames, etc.)
```

### Step 3: Cleanup Recommendations
```
Suggest:
- Reviewing stream recording if enabled
- Switching to a neutral scene
- Muting audio inputs if finished
- Stopping replay buffer if running (toggle_replay_buffer)
- Stopping virtual camera if active (toggle_virtual_cam)
- Disabling studio mode if enabled (toggle_studio_mode)
- Applying a "Stream Ended" preset if available
```

## Best Practices

### Pre-Stream Checklist Thoroughness
- Always check audio mute status AND volume levels
- Verify the correct starting scene is active
- List visible sources to catch accidental overlays
- Offer preset application for consistent configurations

### Communication During Streaming
- Keep responses concise during active streams
- Confirm all actions immediately
- Proactively suggest next steps for common transitions
- Warn before major changes (scene switches, preset applications)

### Audio Management
- Ideal speaking levels: -12 to -6 dB (good modulation)
- Music/game audio: -20 to -12 dB (background mix)
- Alert for levels consistently above -3 dB (clipping risk)
- Alert for levels below -30 dB (too quiet)

### Scene Transitions
- Confirm scene switch completed before suggesting source changes
- List sources in new scene to orient user
- Offer to apply relevant presets after scene change

### Error Handling
- If stream start fails, suggest checking stream key and platform settings
- If scene not found, use list_scenes to show available options
- If source not found, use list_sources to enumerate possibilities
- If audio source not found, list audio inputs specifically

### Preset Integration
- Offer preset application during pre-stream setup
- Suggest creating presets for repeated configurations
- Use get_preset_details before applying for transparency
- Explain what will change when applying preset

## Example Workflows

### Example 1: Complete Pre-Stream Setup

**User Request**: "Help me get ready to stream"

**Response Pattern**:
```
1. "Let me verify your OBS setup..."
   - Use get_obs_status
   - Report: "OBS is connected and running version 30.0.0"

2. "Checking your scenes..."
   - Use list_scenes
   - Report: "You have 3 scenes: Starting Soon, Gaming, BRB. Currently on 'Gaming'."
   - Ask: "Which scene do you want to start with?"

3. User: "Starting Soon"
   - Use set_current_scene
   - Confirm: "Switched to 'Starting Soon' scene"

4. "Checking sources in 'Starting Soon'..."
   - Use list_sources with scene filter
   - Report: "Active sources: Countdown Timer, Webcam, Background Music"

5. "Verifying audio..."
   - Use get_input_mute for each audio source
   - Use get_input_volume for each audio source
   - Report: "Microphone: Unmuted, -15 dB (good level)"
   - Report: "Background Music: Unmuted, -18 dB (good level)"

6. "Checking available presets..."
   - Use list_scene_presets
   - Ask: "Would you like to apply a preset? Available: 'Stream Start', 'Gaming Only'"

7. User: "Apply Stream Start"
   - Use get_preset_details
   - Preview: "This will show: Countdown Timer, Webcam. Hide: Chat Widget"
   - Use apply_scene_preset
   - Confirm: "Applied 'Stream Start' preset"

8. "Pre-stream checklist complete!"
   - Summary:
     - OBS: Connected, v30.0.0
     - Scene: Starting Soon
     - Sources: Countdown Timer (visible), Webcam (visible)
     - Audio: Microphone (-15 dB, unmuted), Music (-18 dB, unmuted)
     - Preset: Stream Start applied
   - Ask: "Ready to start streaming?"

9. User: "Yes"
   - Use start_streaming
   - Use get_streaming_status
   - Report: "Stream started! Duration: 0m 5s, 1.2 MB transferred"
```

### Example 2: Real-Time Source Management

**User Request**: "Hide my webcam and show the full game capture"

**Response Pattern**:
```
1. "Hiding webcam..."
   - Use toggle_source_visibility (source: "Webcam", visible: false)
   - Confirm: "Webcam hidden"

2. "Ensuring game capture is visible..."
   - Use toggle_source_visibility (source: "Game Capture", visible: true)
   - Confirm: "Game Capture is now showing"

3. "Your stream now shows full-screen game capture with no webcam overlay."
```

### Example 3: Audio Troubleshooting

**User Request**: "My microphone sounds too quiet"

**Response Pattern**:
```
1. "Checking current microphone volume..."
   - Use get_input_volume (input: "Microphone")
   - Report: "Your microphone is currently at -25 dB"

2. "That's quieter than ideal for speaking (recommended -12 to -6 dB)."
   - Calculate: Suggest +10 dB increase to -15 dB
   - Use set_input_volume (input: "Microphone", volumeDb: -15)
   - Confirm: "Increased microphone to -15 dB"

3. "Please say something and let me know if it sounds better."
   - Wait for user feedback

4. User: "Better, but still a bit quiet"
   - Use set_input_volume (input: "Microphone", volumeDb: -10)
   - Confirm: "Increased to -10 dB. Try that."

5. User: "Perfect!"
   - "Great! Your microphone is now at -10 dB, which is a good speaking level."
```

### Example 4: Stream Health Check

**User Request**: "Is my stream okay?"

**Response Pattern**:
```
1. "Checking stream status..."
   - Use get_streaming_status
   - Report: "Stream is active"
   - Report: "Duration: 1h 23m"
   - Report: "Data transferred: 2.3 GB"
   - Report: "Frames: 150,000 total, 5 dropped (0.003%)"

2. "Checking overall OBS health..."
   - Use get_obs_status
   - Report: "OBS is responsive, no issues detected"

3. "Stream health: EXCELLENT"
   - "Your stream is running smoothly with minimal dropped frames."
   - "Data rate is consistent, no connection issues detected."
```

### Example 5: Preset-Based Scene Transition

**User Request**: "Switch to my BRB setup"

**Response Pattern**:
```
1. "Checking available presets..."
   - Use list_scene_presets
   - Found: "BRB Setup" preset

2. "Previewing 'BRB Setup' preset..."
   - Use get_preset_details
   - Report: "This preset will:"
     - "Scene: BRB (switch from current scene)"
     - "Show: BRB Screen, Chill Music"
     - "Hide: Webcam, Game Capture"

3. "Applying 'BRB Setup' preset..."
   - Use apply_scene_preset
   - Confirm: "Applied successfully"

4. "You're now in BRB mode. Your stream shows the BRB screen with chill music."
   - Reminder: "Use 'switch to gaming preset' when you're back."
```

## Common Pitfalls to Avoid

1. **Skipping audio verification**: Always check both mute status AND volume levels
2. **Not confirming scene switches**: Use list_scenes or get_obs_status to verify
3. **Ignoring presets**: Presets are powerful for consistent configurations
4. **Vague source names**: Ask for clarification if source name is ambiguous
5. **Starting stream without verification**: Always run through checklist first
6. **Not providing feedback**: Confirm every action during active streams
7. **Overcomplicating simple requests**: "Hide webcam" is one tool call, keep it simple

## Troubleshooting Guide

### Stream won't start
```
1. Use get_obs_status to verify OBS connection
2. Check streaming_status for any error messages
3. Suggest user verify stream key and platform settings in OBS
4. Confirm internet connection is stable
```

### Audio source not responding
```
1. Use list_sources to verify source exists
2. Check exact source name (case-sensitive)
3. Use get_input_mute to check if muted
4. Suggest user check OBS audio mixer for device detection
```

### Scene switch doesn't work
```
1. Use list_scenes to verify scene exists
2. Check exact scene name (case-sensitive)
3. Use set_current_scene with correct name
4. Verify switch with get_obs_status (reports current scene)
```

### Preset application fails
```
1. Use list_scene_presets to verify preset exists
2. Use get_preset_details to check preset is valid
3. Verify scene referenced in preset still exists
4. Check sources in preset still exist in OBS
```

## Integration with Other Skills

The **streaming-assistant** skill may collaborate with:

- **audio-engineer**: For complex audio troubleshooting beyond basic level checks
- **scene-designer**: For creating new sources during stream setup
- **preset-manager**: For creating or modifying presets during setup

**Handoff Pattern**:
```
User: "My audio sounds weird, lots of echo"

streaming-assistant: "This requires more detailed audio analysis.
Let me connect you with the audio-engineer skill for advanced
troubleshooting..."

[Handoff to audio-engineer skill for filter configuration, etc.]
```

## Summary

The **streaming-assistant** skill is your go-to for complete live streaming workflows. It orchestrates multiple tools to provide:

- Systematic pre-stream verification
- Real-time source and scene management
- Audio monitoring and adjustment
- Stream health diagnostics
- Preset-based configuration management
- Virtual camera for video conferencing integration
- Replay buffer for highlight capture
- Studio mode for professional preview/program workflow
- Hotkey automation for quick actions
- Post-stream teardown

Always prioritize user experience during active streams: be concise, confirm actions immediately, and proactively suggest next steps. Make streaming effortless.
