name: beads
description: "Beads (bd) distributed Dolt-backed (Git-like) issue tracker for AI agents: hash-based IDs, dependency graphs, worktrees, molecules, Dolt sync, GitLab/Linear/Jira. Keywords: bd, beads, issue tracker, dolt, git-like, dependencies, molecules, worktree, sync, AI agents."
version: "0.56.1"
release_date: "2026-02-23"

---

# Beads (bd)

Distributed, Dolt-backed (Git-like) graph issue tracker for AI coding agents. Persistent memory with dependency-aware task tracking.

## Quick Start

Install: `brew install steveyegge/beads/bd` or use the install script from the [GitHub repo](https://github.com/steveyegge/beads).

```bash
# Initialize in repo (humans run once)
bd init

# Tell your agent
echo "Use 'bd' for task tracking" >> AGENTS.md
```

## When to Use

- AI agent needs persistent task memory across sessions
- Tracking dependencies between tasks (`blocks:`, `depends_on:`)
- Multi-agent/multi-branch workflows (hash-based IDs prevent conflicts)
- Incremental delivery with molecules/gates
- Sync issues with GitLab, Linear, Jira, GitHub

## Essential Commands

| Command                       | Action                                |
| ----------------------------- | ------------------------------------- |
| `bd ready`                    | List tasks with no open blockers      |
| `bd ready --gated`            | Tasks waiting at gate checkpoints     |
| `bd create "Title" -p 0`      | Create P0 task                        |
| `bd show <id>`                | View task details and audit trail     |
| `bd update <id> --status=X`   | Update status (open/in_progress/done) |
| `bd close <id>`               | Close task                            |
| `bd dep add <child> <parent>` | Link tasks (blocks, related, parent)  |
| `bd list`                     | List issues (default: 50, non-closed) |
| `bd dolt pull`                | Pull latest issue DB changes          |
| `bd dolt commit`              | Commit issue DB changes               |
| `bd dolt push`                | Push issue DB changes                 |
| `bd kv set <key> <value>`     | Store key-value pair                  |
| `bd kv get <key>`             | Retrieve stored value                 |
| `bd dolt show`                | Show Dolt connection/remote settings  |
| `bd gitlab sync`              | Sync with GitLab                      |

## Hash-Based IDs

Issues use hash-based IDs like `bd-a1b2` to prevent merge conflicts:

```bash
bd create "Fix login bug" -p 1
# Created: bd-x7k3

bd show bd-x7k3
```

### Hierarchical IDs

```
bd-a3f8      (Epic)
bd-a3f8.1    (Task)
bd-a3f8.1.1  (Sub-task)
```

Use `bd children <id>` to view hierarchy.

## References

| File                                    | Purpose                               |
| --------------------------------------- | ------------------------------------- |
| [workflow.md](references/workflow.md)   | Daily operations, status flow, sync   |
| [authoring.md](references/authoring.md) | Writing quality issues, EARS patterns |
| [molecules.md](references/molecules.md) | Molecules, gates, formulas, compounds |
| [sync.md](references/sync.md)           | Dolt sync, upgrades, and integrations |

## Key Concepts

### Dolt as Database

Beads stores issues in a Dolt database. Team synchronization happens via Dolt-style
`pull`/`push`, not by committing JSONL files into your repo history.

### Dependency Graph

```bash
bd dep add bd-child bd-parent --blocks   # child blocks parent
bd dep add bd-a bd-b --related           # related items
bd ready                                 # only shows unblocked work
```

### Molecules (Advanced)

Molecules group related issues with gates for incremental delivery:

```bash
bd mol create "Feature X" --steps=3      # Create 3-step molecule
bd mol progress bd-xyz                   # Check progress
bd mol burn bd-xyz                       # Complete molecule
```

### Stealth Mode

Use Beads locally without committing to repo:

```bash
bd init --stealth
```

### Contributor vs Maintainer

```bash
# Contributor (forked repos) — separate planning repo
bd init --contributor

# Maintainer auto-detected via SSH/HTTPS credentials
```

## Configuration

Config stored in `.beads/config.yaml`:

The exact schema evolves between releases. Prefer using CLI helpers to inspect
and validate your current setup:

- `bd dolt show` to see current Dolt connection/remote settings
- `bd dolt test` to validate connectivity
- `bd doctor --server` when upgrading or diagnosing server-mode issues

## Storage Backend (Dolt SQL Server Required)

As of v0.56, Beads requires Dolt SQL server mode (embedded Dolt mode was removed).
Use `bd dolt test` and `bd doctor --server` to confirm the server is reachable.

## Agent Integration

### Tell Agent About Beads

Add to `AGENTS.md`:

```markdown
## Task Tracking

Use `bd` for task tracking. Run `bd ready` to find work.
```

### Agent-Optimized Output

```bash
BD_AGENT_MODE=1 bd list --json  # Ultra-compact JSON output
bd list --json                   # Standard JSON output
```

### MCP Plugin

Beads includes Claude Code MCP plugin for direct integration.

## Critical Commands

```bash
# What to work on
bd ready                    # Unblocked tasks
bd ready --pretty           # Formatted output

# Create with dependencies
bd create "Task B" --blocks bd-a1b2

# Doctor (fix issues)
bd doctor                   # Check health
bd doctor --fix             # Auto-fix problems

bd dolt pull                # Pull latest changes
bd dolt commit              # Commit local changes
bd dolt push                # Push to remote

# Note: `bd sync` is deprecated (no-op) in v0.56+.
```

## Anti-patterns

| ❌ Wrong                | ✅ Correct                  |
| ----------------------- | --------------------------- |
| `priority: high`        | `-p 1` (P0-P4 numeric)      |
| Manual JSON editing     | Use `bd` commands           |
| Ignoring `bd ready`     | Always check blockers first |
| Skipping `bd dolt pull` | Pull before starting work   |
| Skipping `bd dolt push` | Push when you want to share |
| Creating without deps   | Declare `--blocks` upfront  |

## Links

- [Releases](https://github.com/steveyegge/beads/releases)
- [Documentation](https://github.com/steveyegge/beads#readme)
- [Community Tools](https://github.com/steveyegge/beads/blob/main/docs/COMMUNITY_TOOLS.md)
