# Project Context

> This document accumulates important decisions, learnings, and context throughout project development.

## Document Purpose

This file serves as a living record of:
- Important decisions and their rationale
- Learnings discovered during development
- Context that future developers need
- Changes to initial assumptions

## Key Decisions

### [YYYY-MM-DD] — [Decision Title]

**Context**: [What led to this decision]

**Decision**: [What was decided]

**Rationale**: [Why this choice was made]

**Consequences**: [Expected outcomes]

**Alternatives Considered**:
- [Alternative 1]: [Why rejected]
- [Alternative 2]: [Why rejected]

---

## Learnings & Discoveries

### [Area/Topic]

- [Learning 1]
- [Learning 2]

---

## Assumption Changes

| Original Assumption | Changed To | Date | Reason |
|--------------------|------------|------|--------|
| [Original] | [New] | [Date] | [Why] |

---

## External Dependencies Notes

### [Dependency Name]

- **Quirks**: [Known issues or behaviors]
- **Workarounds**: [Solutions found]
- **Documentation gaps**: [What's not documented]

---

## Team Knowledge

### Onboarding Notes

[Important things new team members should know]

### Domain-Specific Terms

| Term | Definition |
|------|------------|
| [Term] | [Definition] |

---

## Performance Baselines

| Metric | Baseline | Date | Notes |
|--------|----------|------|-------|
| [Metric] | [Value] | [Date] | [Notes] |

---

## Integration Notes

### [Integration Name]

- **Setup**: [How to set up]
- **Gotchas**: [Common pitfalls]
- **Test accounts**: [Reference to secure location]

---

## Future Considerations

- [ ] [Item to address later]
- [ ] [Technical debt item]
- [ ] [Enhancement idea]
