# About.md Guide

## Purpose

The `about.md` file is the foundational document that describes what the project is, why it exists, and who it serves.

## Creation Workflow

### Phase 1: Initial Questions

Start with broad questions to understand the project:

1. **What is this project?**
   - Ask for a brief description in user's own words
   - Offer to help structure the description
   - Suggest clearer formulations if needed

2. **What problem does it solve?**
   - Help user articulate the pain points
   - Ask about current alternatives and their limitations
   - Probe for specific examples of the problem

3. **Who will use this?**
   - Identify primary and secondary users
   - Create user personas together
   - Understand user needs and expectations

### Phase 2: Deep Dive Questions

4. **What makes this unique?**
   - Competitive differentiation
   - Key value proposition
   - Why users would choose this over alternatives

5. **What are the goals?**
   - Short-term objectives
   - Long-term vision
   - Measurable success criteria

6. **What's in and out of scope?**
   - Core features for MVP
   - Features for later phases
   - Explicit exclusions

### Phase 3: Constraints & Context

7. **What are the constraints?**
   - Timeline
   - Budget
   - Technical limitations
   - Team size and skills

8. **Who are the stakeholders?**
   - Decision makers
   - Contributors
   - External dependencies

## Iteration Approach

After each section:
1. Present the draft
2. Ask for feedback
3. Offer alternative formulations
4. Revise based on input
5. Confirm before moving on

## Completion Criteria

Document is ready when user confirms:
- [ ] Project description is accurate
- [ ] Problem statement is clear
- [ ] Target audience is well-defined
- [ ] Goals and success metrics are established
- [ ] Scope boundaries are set
- [ ] Constraints are documented

## Common Pitfalls

- **Too vague**: "A web app for managing things" — push for specifics
- **Too technical**: Focus on value, not implementation details
- **Missing why**: Always explain the problem being solved
- **No boundaries**: Scope must have explicit limits

## Sample Questions to Ask

- "Can you describe your project in one sentence?"
- "What frustration does this solve for users?"
- "If you could only build 3 features, what would they be?"
- "How will you know if the project is successful?"
- "What will this project definitely NOT do?"
- "Who absolutely needs to be involved?"
