# Platform Templates

Quick-copy templates for each platform.

---

## X/Twitter (280 chars)

### Standard Post

```
{{HOOK}}

{{MAIN_POINT}}

{{CTA/QUESTION}}
```

### Announcement

```
{{SHIPPED/LAUNCHED}} {{WHAT}}

{{WHY_IT_MATTERS}}

{{LINK}}
```

### Thread Opener

```
{{HOOK_STATEMENT}}

A thread on {{TOPIC}} 🧵
```

---

## LinkedIn (3000 chars)

### Professional Update

```
{{PROFESSIONAL_HOOK}}

{{CONTEXT}}

{{KEY_POINTS}}
- Point 1
- Point 2
- Point 3

{{INSIGHT/TAKEAWAY}}

{{CTA_QUESTION}}

#hashtag1 #hashtag2 #hashtag3
```

### Announcement

```
{{NEWS_HOOK}}

{{WHAT_HAPPENED}}

{{WHY_IT_MATTERS}}

Key highlights:
• {{HIGHLIGHT_1}}
• {{HIGHLIGHT_2}}
• {{HIGHLIGHT_3}}

{{NEXT_STEPS}}

{{LINK}}

#hashtag1 #hashtag2 #hashtag3
```

---

## Threads (500 chars)

### Conversational Post

```
{{CASUAL_HOOK}}

{{MAIN_THOUGHT}}

{{YOUR_TAKE}}
```

### Reply/Reaction

```
{{CONTEXT_REFERENCE}}

{{YOUR_PERSPECTIVE}}

{{QUESTION_TO_COMMUNITY}}
```

---

## Instagram (2200 chars)

### Standard Caption

```
{{HOOK_LINE}}

{{MAIN_MESSAGE}}

{{DETAILS}}

{{CTA}}

.
.
.
#hashtag1 #hashtag2 #hashtag3 #hashtag4 #hashtag5
#hashtag6 #hashtag7 #hashtag8 #hashtag9 #hashtag10
```

### Story Prompt

```
{{QUESTION_OR_POLL}}

[Use interactive stickers]
```

---

## Facebook (under 250 chars optimal)

### Engagement Post

```
{{CONVERSATIONAL_OPENING}}

{{MAIN_MESSAGE}}

{{QUESTION_TO_AUDIENCE}}

#hashtag1 #hashtag2
```

### Event/Announcement

```
{{EXCITING_NEWS}}

{{EVENT_DETAILS}}
📅 {{DATE}}
📍 {{LOCATION/LINK}}

{{CTA}}

#hashtag1 #hashtag2
```

---

## Template Variables

| Variable         | Description                  |
| ---------------- | ---------------------------- |
| `{{HOOK}}`       | First-line attention grabber |
| `{{MAIN_POINT}}` | Core message                 |
| `{{CTA}}`        | Call to action               |
| `{{LINK}}`       | URL if applicable            |
| `{{KEY_POINTS}}` | Bullet points                |
| `{{INSIGHT}}`    | Your unique perspective      |
| `{{QUESTION}}`   | Engagement prompt            |

---

## Platform Specs Quick Reference

| Platform  | Chars | Hashtags | Optimal   |
| --------- | ----- | -------- | --------- |
| X         | 280   | 1-2      | 180-250   |
| LinkedIn  | 3000  | 3-5      | 1200-1500 |
| Threads   | 500   | 0        | 150-300   |
| Instagram | 2200  | 5-15     | 1000-1500 |
| Facebook  | 63206 | 2-3      | under 250 |

---

## Adaptation Workflow

1. **Start with X** - Force concision
2. **Expand to LinkedIn** - Add professional context
3. **Simplify to Threads** - Conversational tone, no hashtags
4. **Visualize for Instagram** - Caption + image concept
5. **Personalize for Facebook** - Community engagement angle

**Rule:** Same message, platform-native execution.
