# AI Writing Avoidance

**Critical reference.** Patterns to avoid so content sounds human, not AI-generated.

## The Core Problem

In 2025, "AI slop" became Merriam-Webster's Word of the Year. Readers and algorithms spot AI patterns instantly. Content that reads as AI-generated loses credibility.

**The test:** If you can swap out the subject, names, and locations and the content remains equally valid, it's slop.

---

## Banned Words (Complete List)

Never use these. They appear disproportionately in AI text.

### Verbs

| Word          | Why Banned                   | Alternative     |
| ------------- | ---------------------------- | --------------- |
| delve         | ChatGPT's signature word     | explore, look at|
| embark        | "Beginning a journey" cliché | start, begin    |
| unleash       | Hyperbolic                   | release, enable |
| harness       | Tech buzzword                | use             |
| unlock        | "Unlock the secrets" pattern | enable, open    |
| navigate      | "Navigate the landscape"     | work with, handle|
| revolutionize | Hyperbolic                   | change          |
| foster        | Corporate-speak              | build, support  |
| elevate       | Vague improvement            | improve         |
| leverage      | Business jargon              | use             |
| underscore    | Overly formal                | highlight, show |
| showcase      | Exhibition language          | show, demo      |
| streamline    | Process cliché               | simplify        |
| spearhead     | Leadership cliché            | lead            |
| facilitate    | Academic                     | help, enable    |
| illuminate    | Academic                     | explain, clarify|
| bolster       | Academic                     | support         |
| refine        | Academic (sometimes OK)      | improve         |

### Adjectives

| Word           | Why Banned                   | Alternative     |
| -------------- | ---------------------------- | --------------- |
| vibrant        | Empty descriptor             | (be specific)   |
| bustling       | Scene-setting cliché         | busy            |
| intricate      | Complexity without specifics | detailed        |
| pivotal        | Overused importance marker   | important, key  |
| crucial        | Overused importance marker   | important       |
| cutting-edge   | Tech buzzword                | advanced, new   |
| robust         | Engineering buzzword         | solid, strong   |
| seamless       | UX buzzword                  | smooth          |
| meticulous     | Precision cliché             | careful         |
| groundbreaking | Hyperbolic                   | new             |
| comprehensive  | Scope claim                  | full, complete  |
| innovative     | Empty marketing              | new (or cut)    |
| dynamic        | Vague energy claim           | (be specific)   |
| holistic       | Buzzword                     | complete, full  |
| nuanced        | Ironic lack of nuance        | detailed        |
| transformative | Buzzword                     | impactful       |
| scalable       | Tech buzzword                | expandable      |

### Nouns

| Word         | Why Banned               | Alternative   |
| ------------ | ------------------------ | ------------- |
| tapestry     | "Rich tapestry" cliché   | (be specific) |
| realm        | Fantasy-speak in tech    | area, field   |
| landscape    | "Navigate the landscape" | field, space  |
| paradigm     | Academic buzzword        | model, pattern|
| synergy      | Corporate buzzword       | (cut it)      |
| beacon       | Guidance metaphor        | guide         |
| testament    | Evidence cliché          | proof, sign   |
| game-changer | Hyperbolic impact        | big change    |
| cornerstone  | Foundation cliché        | foundation    |
| catalyst     | Change metaphor          | trigger       |
| ecosystem    | Tech buzzword            | system        |
| deep dive    | Exploration cliché       | look, analysis|

---

## Banned Phrases

### Opening Clichés (Never Start With)

- "In today's fast-paced world..."
- "In today's digital age..."
- "In the ever-evolving landscape of..."
- "In the realm of..."
- "Have you ever wondered..."
- "At its core..."
- "To put it simply..."
- "From a broader perspective..."

### Emphasis Patterns (Hedging)

- "It's important to note that..."
- "It's worth noting that..."
- "It's essential to remember..."
- "Arguably..."
- "To some extent..."
- "Generally speaking..."
- "Typically..."
- "Tends to..."
- "Broadly speaking..."
- "This underscores the importance of..."
- "A key takeaway is..."

### Transitions (Use Sparingly or Avoid)

- "Furthermore..."
- "Moreover..."
- "Additionally..."
- "That being said..." → use "however" or "even so"
- "With that in mind..."

### Closing Clichés (Never End With)

- "In conclusion..."
- "To summarize..."
- "All in all..."
- "At the end of the day..."

### Reframing Cliché

- "It's not X, it's about Y..." — overused AI pattern

---

## Banned Punctuation

### Em-Dash (—): BANNED ENTIRELY

Em-dashes are **the** signature of AI writing. GPT-4 uses ~10x more em-dashes than GPT-3.5.

| Character | Name    | Status    |
| --------- | ------- | --------- |
| -         | Hyphen  | ✅ OK     |
| –         | En-dash | ✅ OK     |
| —         | Em-dash | ❌ BANNED |

**Instead use:**

- Commas for mild pauses
- Parentheses for asides
- Periods for separate sentences
- Colons for explanations
- Semicolons for related clauses

**Before (AI):**

> The system processes requests in real-time—analyzing patterns, executing tools, and returning results—all within milliseconds.

**After (human):**

> The system processes requests in real-time. It analyzes patterns, executes tools, and returns results, all within milliseconds.

---

## Structural Patterns to Avoid

### Uniform Sentence Length

**Problem:** AI generates sentences averaging 25-30 words with minimal variation.

**Fix:** Deliberately vary length. Some 5 words. Some 40.

**Before (AI):**

> The model processes input through multiple layers of transformation. Each layer applies attention mechanisms to understand context. The final layer produces output tokens sequentially.

All sentences ~10 words. Mechanical rhythm.

**After (human):**

> The model processes input through multiple layers. Each layer? Attention mechanisms that build context understanding. The final layer produces tokens one by one, which is why responses stream rather than appear all at once. Simple concept, but the implications are massive.

Sentence lengths: 7, 7, 19, 8 words. Natural rhythm.

### Immediate Jump to Lists

**Problem:** AI immediately structures into bullet points without narrative.

**Fix:** Build tension with prose first. Use lists sparingly.

### Excessive Parallelism

**Problem:** AI loves "It's not X, it's Y" repeated.

**Before (AI):**

> It's not about the tools, it's about the outcomes. It's not about complexity, it's about simplicity.

**After (human):**

> Tools don't matter. Outcomes do. Stop adding complexity. Ship something simple that users actually want.

---

## Tone Patterns to Avoid

### Excessive Hedging

**Red flags:** might, may, could, arguably, perhaps, typically, generally, often, sometimes

**Before (AI):**

> This approach might be beneficial for some teams, particularly those who may be experiencing scalability challenges. It could potentially reduce costs.

**After (human):**

> This approach works for teams hitting scale problems. It cuts costs. Not for everyone, but if you're processing more than 10K requests daily, pay attention.

### Artificial Balance

**Problem:** AI presents artificially balanced "both sides" even when one side is clearly correct.

**Fix:** Take a stance.

### Generic Tone

**Problem:** AI writing lacks personality. Every piece sounds the same.

**Fix:** Develop recognizable voice. Include opinions, preferences, personality.

---

## Content Deficiencies

### Lack of Specificity

**Before (AI):**

> Many companies have adopted this approach with significant results. Industry experts recommend this methodology.

**After (human):**

> Stripe adopted this in 2022. Their API latency dropped 40%. When Guillermo Rauch talked about it at Vercel Conf, he said it changed how they think about edge computing.

### Missing Personal Experience

**Fix:** Include specific experiences, lessons learned, personal context.

---

## Human Touch Checklist

### Voice & Personality

- [ ] Sounds like a specific person wrote it?
- [ ] Contains opinions, not just facts?
- [ ] Has personality in word choices?

### Specificity

- [ ] Has specific names, numbers, dates?
- [ ] Examples are concrete, not hypothetical?
- [ ] Contains real anecdotes or experiences?

### Structure

- [ ] Sentence length varies dramatically?
- [ ] Short punchy sentences mixed with longer ones?
- [ ] Avoids immediate bullet-point lists?

### Word Choice

- [ ] Zero words from banned list?
- [ ] Zero em-dashes (—)?
- [ ] No "In conclusion" or "It's important to note"?

### Stance

- [ ] Takes clear positions?
- [ ] Minimal hedging language?
- [ ] No artificial "both sides" balance?

---

## Summary

**Core principles:**

1. **Be specific.** Names, numbers, dates, concrete examples.
2. **Be opinionated.** Take stances. Avoid hedge words.
3. **Be personal.** Include anecdotes, lessons learned, your perspective.
4. **Be varied.** Mix sentence lengths and structures.
5. **Be imperfect.** Natural writing has rough edges.

**The test:** Would a reader finish this and feel they gained genuine insight that only a thoughtful human could provide?
