# Facebook

Best practices for Facebook content.

## Platform Specifications

| Spec            | Value                          |
| --------------- | ------------------------------ |
| Character limit | 63,206 (unlimited practically) |
| Best engagement | Under 250 characters           |
| Hashtags        | 2-3 max                        |
| Best times      | Tue-Thu 9 AM-12 PM             |

## Core Principles

- **Conversational:** Community-focused, friendly
- **Concise:** Under 250 chars for best engagement
- **Visual:** Images/videos boost reach significantly
- **Interactive:** Ask questions, encourage comments

## Post Structure

```
[Engaging opening - hook]

[Main message]

[Detailed description if needed]

[Event details if applicable]

[Call-to-action]

#hashtag1 #hashtag2
```

## Formatting Rules

- Conversational tone
- Keep posts concise
- Use compelling visuals or videos
- Ask questions to encourage comments
- 2-3 hashtags maximum
- Tag relevant pages or people
- Use emojis to add personality
- Include links when driving traffic

## Content Types

### Standard Post

```
[Engaging opening]

[Main message - keep it short]

[Question or CTA]

#Hashtag1 #Hashtag2
```

### Event Promotion

Use Facebook Events feature directly for event promotion—better visibility and RSVP tracking.

### Community Engagement

```
We want to hear from you!

[Question about topic relevant to audience]

Drop your answer in the comments 👇
```

## Best Practices

- Post 1-2 times per day
- Use video (highest engagement)
- Go live when possible
- Respond to comments quickly
- Use Facebook Stories for casual content
- Create polls for engagement

## What to Avoid

- Over-posting (quality > quantity)
- Link-only posts (add context)
- Engagement bait that feels forced
- Overly promotional content

## Algorithm Priorities

1. **Meaningful interactions** (comments, shares)
2. **Video content** (especially live)
3. **Recency**
4. **Content from friends/family** (over pages)

## Facebook vs Other Platforms

| Aspect     | Facebook                          |
| ---------- | --------------------------------- |
| Audience   | Broad, 30+ demographic            |
| Tone       | Community, friendly               |
| Content    | Mixed, visual preferred           |
| Engagement | Comments, shares, reactions       |
| Best for   | Local business, events, community |
