# Hook Patterns

The hook is everything on X. You have ~1 second to stop the scroll. These patterns are proven to capture attention.

## Hook Testing Framework

Before posting, verify your hook:

1. **Scroll-stop**: Would YOU stop scrolling for this?
2. **Specificity**: Is it concrete or vague?
3. **Promise**: Is the value proposition clear?
4. **Curiosity**: Does it create an information gap?
5. **Believability**: Bold enough to intrigue, believable enough to trust?

**Weak:** "Here's some advice on growing on X."
**Strong:** "I grew from 0 to 25K followers in 90 days. Here's the exact playbook (no fluff):"

---

## Bold Claim Hooks

Make a statement so bold readers must understand how it's true.

**Pattern:** "[Surprising claim that seems too good/bad to be true]"

**Examples:**

- "I went from 0 to 10,000 followers in 57 days without posting a single thread."
- "One cold email changed my entire career."
- "I made more in 30 days than I did in a year at my job."
- "The best marketing strategy costs $0."
- "I built a $100K business with a skill I learned in a weekend."

**Why it works:** The gap between claim and believability forces readers to seek explanation.

---

## Transformation Hooks

Show dramatic before/after contrast.

**Pattern:** "[Past state] → [Current state] + [Timeframe or method tease]"

**Examples:**

- "6 months ago I was broke. Today I turned down a $200K offer. Here's what changed:"
- "From rejected by 50 companies to 3 competing offers in 8 weeks."
- "0 followers → 50K in 6 months. No ads. No luck. Just this:"
- "Burned out employee → thriving founder. The pivot that changed everything:"

**Why it works:** Transformation stories are inherently compelling. Readers want the roadmap.

---

## Contrarian Hooks

Challenge what everyone believes.

**Pattern:** "[Popular belief] is wrong/dead/overrated. Here's why:"

**Examples:**

- "Unpopular opinion: Networking events are useless."
- "Stop setting goals. Seriously. Here's what to do instead:"
- "The 'rise and grind' mentality is destroying your career."
- "Your resume doesn't matter anymore. Here's what does:"
- "Most productivity advice is garbage. Here's what actually works:"

**Why it works:** Challenges create cognitive dissonance. Readers need resolution.

---

## Curiosity Gap Hooks

Tease information without revealing it.

**Pattern:** "[Intriguing setup] + [Incomplete information]"

**Examples:**

- "The CEO said 3 words that changed how I think about leadership forever."
- "I asked 100 millionaires one question. The answers shocked me."
- "There's one thing every successful person does that nobody talks about."
- "I made one change to my morning routine. Everything improved."
- "My mentor's advice sounded crazy at first. Then I tried it."

**Why it works:** The brain craves closure. Incomplete information compels clicks.

---

## List Promise Hooks

Promise specific, valuable information.

**Pattern:** "[Number] [things/tips/lessons/mistakes] + [outcome/topic]"

**Examples:**

- "7 lessons from building a $1M business (that I wish I knew at 25):"
- "5 habits that seem lazy but actually make you more productive:"
- "10 things I'd tell my younger self about career growth:"
- "8 books that changed how I think about money:"
- "6 mistakes I made hiring my first 10 employees:"

**Why it works:** Numbers create specificity. Lists promise organized, digestible value.

---

## Question Hooks

Open with a provocative question.

**Pattern:** "[Question that challenges or resonates deeply]?"

**Examples:**

- "Why do smart people make terrible decisions?"
- "What's the one skill nobody talks about but everyone needs?"
- "Are you building a career or just collecting paychecks?"
- "What if everything you know about success is wrong?"
- "Why are the busiest people often the least productive?"

**Why it works:** Questions activate different brain patterns. Readers naturally seek to answer.

---

## Story Hooks

Start in the middle of action.

**Pattern:** "[Dramatic moment or dialogue that drops reader into scene]"

**Examples:**

- "The investor looked at me and said, 'This will never work.'"
- "I was 30 seconds from quitting when everything changed."
- "My phone rang at 3am. It was the call that changed everything."
- "I stared at my bank account: $47. I had a decision to make."
- "'You're fired.' Two words. One moment. Everything shifted."

**Why it works:** Stories create immediate emotional engagement.

---

## Data Hooks

Lead with surprising statistics or results.

**Pattern:** "[Specific number/stat] + [unexpected context]"

**Examples:**

- "I analyzed 1,000 viral threads. 90% follow this exact pattern:"
- "After 500 cold emails, I learned one thing that 10x'd my response rate."
- "I tracked my time for 30 days. The results were embarrassing."
- "87% of people make this mistake in negotiations. Here's the fix:"
- "I interviewed 50 founders. They all said the same thing about failure:"

**Why it works:** Specific numbers create credibility. Data implies proven insights.

---

## Thread-Specific Techniques

### Open Loop

End tweet 1 with incomplete information resolved in tweet 2:

- "Here's what happened next:"
- "But here's the thing nobody tells you:"

### Cliffhanger

Use at end of middle tweets to maintain momentum:

- "And then it got worse."
- "But that wasn't the real lesson."

### Pattern Interrupt

Break expected flow to recapture attention:

- "Stop."
- "Read that again."
- "This is the part most people skip."
