# LinkedIn

Professional content guidelines for LinkedIn posts.

## Platform Specifications

| Spec              | Value                        |
| ----------------- | ---------------------------- |
| Character limit   | 3,000 chars                  |
| "See more" cutoff | ~140 chars in feed           |
| Ideal length      | 1,300 chars                  |
| Hashtags          | 3-5 max                      |
| Best times        | Tue-Thu, 8-10 AM, 12-1 PM ET |

## Core Principles

- **Hook early:** First 2 lines show in feed—make them count
- **Professional but authentic:** Not corporate-speak
- **Value-driven:** Tell stories, share insights
- **Use data:** Statistics and metrics boost credibility
- **Engage back:** Comment on posts in your niche

## Post Structure

```
[Hook line that creates curiosity]

[Personal context or story - 2-3 short paragraphs]

[Key insight or lesson - bulleted if multiple points]

[Call-to-action or engaging question]

#relevanthashtags (3-5 max)
```

## Formatting Rules

- Short paragraphs (1-2 sentences each)
- Line breaks between paragraphs for mobile readability
- Emojis: use sparingly, professionally
- Bullet points for key information
- Bold using Unicode (if needed)

## Content That Works

### Thought Leadership

```
Most AI features never make it to production.

Not because the models aren't good enough.

Because teams build for demos, not for users.

After shipping 50+ AI features, here's what actually matters:

→ Start with the simplest possible implementation
→ Measure what users do, not what they say
→ Treat AI like any other code: test it, monitor it, iterate

What's the biggest lesson you've learned shipping AI?
```

### Technical Deep-Dive

```
[Professional Hook - Problem Statement]

[Solution Introduction]

**What we built:**
• [Technical detail 1]
• [Technical detail 2]
• [Technical detail 3]

**The impact:**
[Metric 1]: [Before] → [After] ([Percentage] improvement)

**How it works:**
1. [Step 1]
2. [Step 2]
3. [Step 3]

This is what AI-native [domain] looks like: [insight].

**Thoughts?** [Open-ended question for discussion]

#AI #Engineering #ProductDevelopment
```

## Algorithm Priorities (2025)

1. **Dwell time** (how long users read your post)
2. **Engagement** (likes, comments, shares)
3. **Relevance** (to user's network and interests)
4. **Personal connections** (1st-degree prioritized)

## What to Avoid

- Overly promotional content
- Hashtag overuse (>5)
- Weekends and late evenings
- Corporate buzzwords
- Engagement bait

## Best Practices

- Post 2-5x per week
- Tag relevant companies/people
- Ask for opinions (drives engagement)
- Tell stories, share insights
- Respond to comments quickly

## LinkedIn vs X Comparison

| Aspect   | LinkedIn         | X           |
| -------- | ---------------- | ------------------- |
| Tone     | Professional     | Casual              |
| Length   | Longer, detailed | Short, punchy       |
| Hashtags | 3-5              | 1-2 or none         |
| Audience | B2B, executives  | Tech community      |
| Content  | Career, industry | Ideas, observations |
