# Style Guide

Voice, tone, and formatting rules for social media writing.

## Voice & Tone

### Direct, Zero Fluff

Get to the point in the first line. No warm-up. No "Hey everyone!"

**Do:**

- "Shipped curation today. Discovery is the hard part."
- "Agent conversations can't be described like app features."

### Confident Without Hedging

State what you did, learned, or believe. Don't apologize or over-qualify.

- ✓ "Here's what I learned:"
- ✗ "I think I maybe learned something interesting..."

### Personal But Work-Focused

Share actual work and learnings, not feelings about work.

- ✓ "Workflow DevKit saves weeks of dev time"
- ✗ "Feeling productive today!"

### Warm Skepticism

Challenge assumptions briefly and specifically.

- "Everyone talks about AI authenticity. Few build quality gates."

---

## Readability & Formatting

### Visual Structure

**Hook first, always.** First line IS the post.

Common hooks:

- "How to [X]"
- "Why [X] doesn't work"
- "[X] is [Y]"
- "Shipped [X]"
- "Here's what I learned:"

**One sentence per line.** Creates natural rhythm.

**Use lists for complexity:**

- Bullet points for steps/ideas
- Numbered lists for sequences
- People skim and grab main points

**White space = readability.** Space between lines gives eyes room.

### Language Simplification

Write like a mentor talking to students. Simple words, not jargon.

**Common simplifications:**

- "use" not "utilize"
- "help" not "facilitate"
- "get better" not "optimize performance"
- "speed up" not "accelerate velocity"

**The 14-year-old test:** If a smart 14-year-old couldn't follow it, simplify more.

---

## Sentence-Level Rules

| Rule                  | Example                                               |
| --------------------- | ----------------------------------------------------- |
| Short sentences       | 10-15 words max                                       |
| Active, present tense | "Building" not "I built"                              |
| Specific > generic    | "30 minutes to ship" not "Way faster"                 |
| No italics on X       | Formatting breaks; use words: "literally," "actually" |

### Casing Options

**Lowercase preference** (casual X style):

- Use lowercase for most words, including sentence starts
- ✓ "january '25: showed devs at an @automattic meetup"

**Always capitalize:**

- Personal names: "Rich Tabor"
- WordPress (the brand)
- Product names (proper nouns)
- Proper @mentions
- Proper @ mentions

---

## What to Include

- **Tools you use:** Name specific tools via @mentions
- **Numbers that prove:** Time saved, metrics, engagement
- **Real projects:** Specificity builds credibility
- **Your role:** When relevant for context
- **Genuine surprise:** "Wild." "Pretty cool."

---

## What to Avoid

### Never Say

- "Game-changer" / "Revolutionary" / "Unlock"
- "Dive in" / "Deep dive"
- "Thoughts?" (too generic)
- "Hot take:" / "Unpopular opinion:" (just state it)
- "Let that sink in"
- "This is the way"
- Excessive emojis (0-1 max)
- Corporate speak ("leverage," "synergy," "utilize")
- Vague adjectives without specifics

### Don't

- Hype your own stuff excessively
- Subtweet or be passive-aggressive
- Engage in ratio-bait drama
- Share without adding your angle
- Apologize for posting

---

## Signature Patterns

### Opening Patterns

| Opening                   | Usage             |
| ------------------------- | ----------------- |
| "Shipped [X]"             | Project updates   |
| "Here's what I learned:"  | Insight posts     |
| "[X] is [Y]"              | Direct statements |
| "Wild how..."             | Genuine surprise  |
| "Most people [X]. But..." | Challenge pattern |
| "How to [X]"              | Tutorial posts    |

### Closing Patterns

| Closing                 | Usage            |
| ----------------------- | ---------------- |
| "More on this soon."    | Teaser           |
| "What's your approach?" | Question         |
| "Pretty cool."          | Understated      |
| "That's it."            | Hard stop        |
| No closing              | Let insight land |

---

## The Formula

For most posts:

**[Specific action/observation] + [Why it matters] + [Your take/learning]**

Examples:

```
Shipped curation for agents.foo.
Discovery is way harder than app stores.
Agents are conversations, not static downloads.
Totally different problem.
```

```
[Tool] cut dev time from days to hours.
Not because it writes better code.
Because it handles the boring parts automatically.
```

---

## Voice Checklist

Before posting:

- [ ] Did I get to the point in line 1?
- [ ] Is this specific? (names, numbers, examples)
- [ ] Would I actually say this out loud?
- [ ] Does it sound like a person, not AI?
- [ ] Did I use any banned phrases?
- [ ] If it's a reaction, did I add MY angle?

---

## Quick Reference

| Element     | Approach                          |
| ----------- | --------------------------------- |
| Length      | 180-250 chars (X)                 |
| Paragraphs  | Line breaks for emphasis          |
| Opening     | Hook = first line                 |
| Closing     | Question (70%) or hard stop (30%) |
| Tone        | Direct, confident, specific       |
| Voice       | First-person, present tense       |
| Credibility | Name your projects, tools, role   |
| Language    | Simple, conversational, concrete  |

**The essence:** Shipped X. Learned Y. Here's why it matters. No fluff.
