# Threads & Instagram

Guidelines for Meta platforms: Threads and Instagram.

## Threads

### Platform Specifications

| Spec                        | Value                              |
| --------------------------- | ---------------------------------- |
| Standard post               | 500 characters                     |
| Long-form (with attachment) | 10,000 chars                       |
| "Read more" appears         | ~500 chars                         |
| Hashtags                    | **None** (algorithm ignores them)  |
| Best times                  | Mon-Fri 9-11 AM, 1-3 PM, 7-9 PM ET |

### Formatting

✅ Bold, italic, underline, strikethrough
✅ Emojis (count toward limit)
✅ Bullet points (• or -)
✅ Line breaks
❌ **No hashtags** (they don't work on Threads)
❌ No clickable links in body (use link preview)

### Algorithm Priorities (2025)

1. **Engagement (40%):** Likes, comments, shares, reply views
2. **Recency (30%):** Fresh content gets priority
3. **Interest/Relevance (20%):** Based on user's past interactions
4. **Profile Visits (10%):** Likelihood user will click profile

### What Works on Threads

- Conversational, authentic tone (not corporate)
- Open-ended questions
- Discussions, not announcements
- Consistent posting (1-3x daily)
- Visuals (images/videos boost engagement)
- Responding to comments within 1 hour

### What to Avoid

- Direct cross-posts from Instagram/X
- Promotional language
- Hashtags (they don't work)
- Corporate speak

### Content Types

- Behind-the-scenes insights
- Quick tips and tricks
- Relatable experiences
- Open-ended questions
- Industry discussions
- Memes (if relevant)

### Template

```
[Hook Question]

[Product/Topic] [Key Update]:

✅ [Feature 1]: [Benefit]
✅ [Feature 2]: [Benefit]
✅ [Feature 3]: [Benefit]

[CTA/Command]

[Link]

[Conversation Hook/Question]
```

---

## Instagram

### Platform Specifications

| Spec          | Value                      |
| ------------- | -------------------------- |
| Caption limit | 2,200 characters           |
| Ideal length  | Varies (visual-first)      |
| Hashtags      | 5-15 relevant              |
| Best times    | Mon-Fri 11 AM-1 PM, 7-9 PM |

### Formatting

✅ Emojis
✅ Line breaks for readability
✅ Hashtags (end of caption or first comment)
✅ Location tags
❌ Links in body don't work (use "link in bio")

### Best Practices

- **Visual-first:** Image/video matters most
- **Hook in first line:** Appears before "more"
- **Line breaks:** For readability
- **Hashtags:** 5-15 relevant, can be in first comment
- **Encourage engagement:** Ask questions

### Caption Structure

```
[Hook - first line visible]

[Detailed description]

[Call-to-action]

.
.
.

#hashtag1 #hashtag2 #hashtag3 (5-15 hashtags)
```

### Content That Works

- Visual-focused content
- Behind-the-scenes
- User-generated content
- Stories for time-sensitive content
- Reels for reach

---

## Threads vs Instagram Comparison

| Aspect   | Threads           | Instagram           |
| -------- | ----------------- | ------------------- |
| Focus    | Text conversation | Visual content      |
| Hashtags | None              | 5-15                |
| Tone     | Authentic, casual | Polished, aesthetic |
| Links    | Preview only      | Bio only            |
| Best for | Discussion        | Brand building      |
