# X Threads

Frameworks and structure for multi-tweet threads.

## When to Thread vs Single Tweet

**Use threads (2-5 tweets) when:**

- Narrative with steps ("How we built X")
- Multiple related insights ("3 learnings about X")
- Before/after story ("Tried X, failed, here's what worked")

**Use single tweets when:**

- One clear insight
- Quick updates
- Strong observations
- Tool recommendations

**Default to single tweets.** Only thread when story requires it.

## Thread Structure

```
Tweet 1: [Hook with main insight - MOST important] 👇

Tweet 2: [Context or setup]

Tweets 3-N: [Build argument with specifics]

Final tweet: [Land with question or strong statement]
```

**Rules:**

- Each tweet must stand alone
- Use N/M numbering for clarity (e.g., 1/7, 2/7... 7/7)
- First tweet MUST end with 👇 or 🧵 to signal thread
- Max 5-7 tweets (longer = blog post)
- Anyone should be able to RT any single tweet

## Thread Frameworks

### Framework 1: Storytelling

Best for: Personal experiences, case studies

```
1/ [Hook - outcome or surprising moment]

2/ [Set the scene - context]

3/ [The challenge/conflict]

4/ [The journey - what happened]

5/ [The turning point]

6/ [The lesson]

7/ [CTA - question or follow prompt]
```

### Framework 2: How-To

Best for: Step-by-step guides

```
1/ [Hook - result they'll get]

2/ [Context/why this matters]

3-N/ [Step-by-step process]

Final/ [Summary + CTA]
```

### Framework 3: Listicle

Best for: Tips, tools, resources

```
1/ [Hook - what they'll learn, e.g., "10 lessons from..."]

2-N/ [One item per tweet]

Final/ [Summary + CTA]
```

### Framework 4: Contrarian

Best for: Thought leadership, hot takes

```
1/ [Bold contrarian statement]

2/ [What everyone believes]

3/ [Why they're wrong]

4/ [Your counter-argument]

5/ [Evidence/experience]

6/ [The nuanced truth]

7/ [Engagement question]
```

### Framework 5: Case Study

Best for: Success stories, breakdowns

```
1/ [Hook - the result achieved]

2/ [Who/what this is about]

3/ [The starting point/problem]

4-N/ [What was done]

N-1/ [Results + key takeaway]

Final/ [CTA]
```

### Framework 6: Problem-Solution

Best for: Educational content

```
1/ [Hook - the problem everyone faces]

2/ [Agitate - why it's painful]

3/ [Solution intro]

4/ [Step 1]

5/ [Step 2]

6/ [Step 3]

7/ [Results + CTA]
```

## Thread Techniques

### Open Loop

End tweet 1 with incomplete information resolved in tweet 2:

- "Here's what happened next:"
- "But here's the thing nobody tells you:"
- "The real story is more interesting:"

### Cliffhanger

Use at end of tweets 2-5 to maintain momentum:

- "And then it got worse."
- "But that wasn't the real lesson."
- "Here's where it gets interesting:"

### Pattern Interrupt

Break expected flow to recapture attention:

- "Stop."
- "Read that again."
- "This is the part most people skip."

## Full Thread Example

### Storytelling Thread

```
1/7 I got fired on my birthday.

No warning. No severance. Just a box and a security escort.

Here's what happened next: 👇

2/7 Some context:

I'd been at the company for 3 years.
Good reviews. Promotions. Everything seemed fine.

Then new leadership came in and cleaned house.

3/7 The first week was brutal.

I applied to 50 jobs. Got 2 responses.
Both rejections.

I started questioning everything about my career.

4/7 Then I did something different.

Instead of applying to more jobs, I reached out to 10 people I admired and asked:

"If you were starting over today, what would you do differently?"

5/7 8 out of 10 said some version of:

"I would have bet on myself sooner."

They'd all spent years building someone else's dream before building their own.

6/7 That's when it clicked.

Getting fired wasn't a setback.
It was a forced decision I'd been too scared to make.

7/7 I started freelancing that month.

First client: $500.
By month 6: $10K/month.
By year 2: More than my old salary.

What's a setback that turned into your biggest breakthrough?
```

## Thread Quality Checklist

- [ ] First tweet ends with 👇 or 🧵?
- [ ] Hook creates immediate curiosity?
- [ ] Each tweet numbered (N/M format)?
- [ ] Each tweet uses most of 280 chars? (230+)
- [ ] One idea per tweet?
- [ ] Smooth flow between tweets?
- [ ] Each tweet could be RT'd standalone?
- [ ] Clear payoff for reading?
- [ ] Has engagement opportunity at end?

## What Makes Threads Shareable

**People RT threads with:**

- Specificity (concrete details vs vague claims)
- Insights (non-obvious learnings)
- Utility (actionable knowledge)
- Relatability (shared struggles + specific solutions)

**People reply when you:**

- Ask specific questions
- Make specific, debatable claims
- Show genuine curiosity
- Leave room for others to add perspective
