import type { HeaderParsedForm } from "./types/jmap-mail.ts";
/**
 * Generate a key to retrieve a header field
 *
 * @example
 * ```ts
 * headerField("Some-Header", "Addresses") // "header:Some-Header:asAddresses"
 * ```
 */
export declare function headerField<Name extends string, Form extends keyof HeaderParsedForm>(name: Name, form: Form): `header:${Name}:as${Form}`;
export declare function allHeaderFields<Name extends string, Form extends keyof HeaderParsedForm>(name: Name, form: Form): `header:${Name}:as${Form}:all`;
//# sourceMappingURL=utils.d.ts.map