---
name: tech-debt-analysis
description: Analyze and address technical debt in codebases.
---

# Tech Debt Analysis Skill

This skill enables you to analyze codebases for technical debt and provide actionable insights to improve code quality and maintainability.

## When to Use This Skill

Use this skill when you need to:
- Assess the health of a codebase and identify areas of technical debt.
- Provide recommendations for refactoring and improving code quality.
- Create a plan to address and reduce technical debt over time.

## How to Use This Skill

To effectively analyze and address technical debt in codebases, follow these steps:

1. **Identify Technical Debt**:
   - Review the codebase for common signs of technical debt, such as:
     - Code smells (e.g., duplicated code, long methods, large classes)
     - Outdated dependencies or libraries
     - Lack of documentation or comments
     - Poor test coverage
     - Inconsistent coding style
     - Commit history indicating quick fixes or workarounds
     - Architectural issues, such as tight coupling or lack of modularity

2. **Prioritize Issues**:
   - Categorize identified technical debt based on its impact on the project:
     - High Impact: Issues that significantly affect performance, security, or maintainability.
     - Medium Impact: Issues that affect development speed or introduce minor bugs.
     - Low Impact: Cosmetic issues or those with minimal effect on functionality.

3. **Create a Remediation Plan**:
   - Develop a plan to address the prioritized technical debt:
     - Set clear goals and timelines for remediation.
     - Allocate resources and assign responsibilities to team members.
     - Consider refactoring code, updating dependencies, improving documentation, and increasing test coverage.

4. **Report Findings**:
   - Prepare markdown file named `TECHNICAL_DEBT_REPORT.md` summarizing findings and recommendations for stakeholders.
   - Document the identified technical debt, its impact, and the proposed remediation plan. 