---
name: ai-writing-detox
description: Eliminate AI-generated writing patterns that erode reader trust. Activate when writing articles, documentation, press releases, or any content where AI patterns would undermine credibility. Essential for journalists using AI assistance who need human-sounding output.
---

# AI writing detox

Good writing is invisible. If readers notice the writing style, it's distracting from the content. AI patterns are noticeable—they break trust.

## When to use

- Writing or editing any journalism content
- Creating press releases or media advisories
- Drafting documentation or reports
- Writing social media posts
- Reviewing any AI-assisted text before publication

## Banned words (delete or replace)

| Word | Why it's bad | Alternative |
|------|--------------|-------------|
| delve | AI signature word | explore, examine, look at |
| realm | Pretentious | area, field |
| tapestry | Purple prose | (delete entirely) |
| landscape | Corporate speak | situation, environment |
| leverage | Jargon | use |
| utilize | Jargon | use |
| robust | Meaningless | strong, reliable |
| seamless | Almost always false | smooth, easy |
| comprehensive | Rarely necessary | full, complete |
| cutting-edge | Cliché | modern, new |
| holistic | Corporate | complete, full |
| synergy | Corporate | (delete, rewrite) |
| paradigm | Overused | model, approach |
| empower | Vague | (be specific about what capability) |
| innovative | Empty praise | (describe what's new) |
| transformative | Hyperbolic | changed, improved |
| rich | (as modifier) | (delete or be specific) |

## Banned phrases

### Throat-clearing (delete entirely)

- "It's important to note that..."
- "In today's [X] landscape..."
- "Let's dive/delve into..."
- "Without further ado..."
- "In this article, we will..."
- "It's worth mentioning that..."
- "It goes without saying..."
- "As we all know..."

### Empty hedges

- "To be fair..." / "To be honest..."
- "At the end of the day..."
- "When it comes to..."
- "In terms of..."
- "With respect to..."

### AI enthusiasm

- "This is a game-changer"
- "...and that's a good thing!"
- "Here's the thing:"
- "...and that's okay!"
- "...and I'm here for it"

### Corporate buzzwords

- "Moving forward..."
- "Going forward..."
- "At this point in time..."
- "Due to the fact that..."
- "In order to..."

## Banned structures

### Don't start sentences with:

- "So," or "Well,"
- "Now," (when not about time)
- "Look," or "Listen,"
- "Basically," or "Essentially,"

### Don't end sentences with:

- "...right?"
- "...you know?"
- "...if you will"

## The substitution table

| If you wrote | Write instead |
|--------------|---------------|
| utilize | use |
| facilitate | help |
| implement | build, add, create |
| leverage | use |
| functionality | feature |
| methodology | method |
| in order to | to |
| due to the fact that | because |
| at this point in time | now |
| a large number of | many |
| in the event that | if |
| prior to | before |
| subsequent to | after |
| in close proximity to | near |
| has the ability to | can |

## Case sensitivity

**Always use sentence case for headings, not title case.**

| Wrong | Right |
|-------|-------|
| Getting Started With Your Project | Getting started with your project |
| How To Use The Tool | How to use the tool |
| Best Practices For Journalism | Best practices for journalism |

## Journalism-specific patterns to avoid

### "Not just X—it's Y" pattern

❌ "This isn't just a news story—it's a wake-up call"
❌ "This wasn't just a press conference—it was a turning point"

✅ State the thing directly without dramatic framing

### "Fundamentally transforms" pattern

❌ "This fundamentally transforms how newsrooms operate"
❌ "This represents a fundamental shift in journalism"

✅ Describe the actual change without hyperbole

### Inflated claims in reporting

❌ "A bombshell revelation"
❌ "A major milestone"
❌ "A groundbreaking investigation"

✅ Let the facts speak. Readers judge significance.

### Empty transitions

❌ "With that in mind..."
❌ "Building on this foundation..."
❌ "Taking this a step further..."

✅ Just make the next point

## Before and after examples

### Example 1: General prose

**AI slop:**
> In today's rapidly evolving media landscape, it's crucial to understand the multifaceted nature of AI tools. Let's delve into how these robust solutions can help journalists leverage cutting-edge technology.

**Human writing:**
> AI tools do three things well: drafting, research, and analysis. Here's when to use each.

### Example 2: News lede

**AI slop:**
> The city council meeting was a comprehensive and transformative discussion that fundamentally addressed key issues affecting residents in a meaningful way.

**Human writing:**
> The city council voted 5-2 Tuesday to raise property taxes by 3 percent.

### Example 3: Feature intro

**AI slop:**
> In the rich tapestry of American journalism, few stories are as compelling as the one about to unfold. This isn't just a profile—it's a journey into the heart of what makes local news truly matter.

**Human writing:**
> Maria Rodriguez has published a newspaper for 47 years. She's never missed an issue.

### Example 4: Analysis piece

**AI slop:**
> Moving forward, stakeholders must leverage innovative approaches to navigate the challenging landscape of digital transformation in the journalism ecosystem.

**Human writing:**
> Local papers that want to survive need to find digital revenue. Most haven't.

## The verbal tic test

Read your text aloud. Does it sound like:
- A TED talk introduction? **Rewrite.**
- A LinkedIn post? **Rewrite.**
- A press release? **Rewrite.**
- Corporate communications? **Rewrite.**
- How you'd explain it to a colleague? **Keep it.**

## Quick self-check before publishing

Search your text for:
1. "delve" → delete or replace
2. "landscape" → delete or replace
3. "crucial" → is it actually crucial?
4. "robust" → what does this mean here?
5. "leverage" → just say "use"
6. "comprehensive" → is this word doing any work?
7. Starting "So," → delete

Found any? Your writing needs another pass.

## Red flags in technical/analysis writing

1. **Lists of near-synonyms**: "comprehensive, sophisticated, and robust" (pick one or none)
2. **Excessive hedging**: "may potentially be able to possibly..."
3. **Noun stacking**: "production-ready deployment system infrastructure"
4. **Passive voice hiding agency**: "It was determined that..." (by whom?)
5. **Circular definitions**: "The system enables users to use the functionality"

## The ultimate test

Before accepting any AI-assisted text, ask:

1. Can I delete this word/phrase without losing meaning? → Delete it
2. Is this the simplest way to say this? → Simplify
3. Would I say this out loud to a colleague? → If not, rewrite
4. Does this add information or just sound impressive? → If the latter, cut it

**Remember:** If readers think "AI wrote this," you've already lost their trust.

---

*Good writing is invisible. If readers notice the writing, it's getting in the way of the content.*
