---
name: interview-prep
description: Prepare for journalism interviews with research checklists, question frameworks, and attribution guidelines. Use when preparing to interview sources, planning follow-up questions, or managing interview logistics. Covers consent, recording laws, and professional protocols.
---

# Interview preparation

Interviews fail in the preparation, not the conversation. This skill covers pre-interview research, question design, logistics, and follow-up.

## When to use

- Preparing to interview a source
- Developing question frameworks for recurring interview types
- Managing interview logistics and consent
- Planning follow-up after initial interviews
- Training new reporters on interview technique

## Pre-interview research checklist

### Background research

```markdown
## Source background check

### Public records
- [ ] Professional licenses verified
- [ ] Court records checked (civil/criminal)
- [ ] Business registrations confirmed
- [ ] Property records (if relevant)
- [ ] Campaign finance (if political figure)
- [ ] SEC filings (if corporate)

### Professional background
- [ ] LinkedIn profile reviewed
- [ ] Current employer confirmed
- [ ] Previous employers noted
- [ ] Published work reviewed
- [ ] Conference appearances checked
- [ ] Professional associations

### Social media audit
- [ ] All platforms identified (Twitter, Facebook, Instagram, etc.)
- [ ] Post history reviewed
- [ ] Connections/followers analyzed
- [ ] Previous statements on topic found
- [ ] Any deleted content recovered?

### Media appearances
- [ ] Previous interviews found
- [ ] Statements consistent with current position?
- [ ] Other journalists' assessments
- [ ] Any retractions or corrections involving them?
```

### Context research

```markdown
## Topic preparation

### Essential knowledge
- [ ] Key facts about the topic confirmed
- [ ] Timeline of events established
- [ ] Other stakeholders identified
- [ ] Conflicting accounts noted
- [ ] Documents/data reviewed

### What to know before you dial
- [ ] How do they fit into the story?
- [ ] What do I NEED from this interview?
- [ ] What might they be reluctant to discuss?
- [ ] What have they said publicly before?
```

## Question framework

### The essential questions

Every interview should be built to answer:
1. **What happened?** (Facts)
2. **Why did it happen?** (Causes)
3. **What did you do/decide/see?** (Actions)
4. **What does it mean?** (Significance)
5. **What's next?** (Implications)

### Question types

| Type | Purpose | Example |
|------|---------|---------|
| **Open-ended** | Get the full story | "Walk me through what happened that day." |
| **Clarifying** | Pin down details | "When you say 'soon after,' do you mean minutes or hours?" |
| **Probing** | Go deeper | "Why do you think that happened?" |
| **Follow-up** | Catch inconsistencies | "Earlier you said X, but now you mentioned Y. Help me understand." |
| **Confrontational** | Challenge statements | "Documents show [fact]. How do you respond?" |
| **Closing** | Ensure completeness | "Is there anything I didn't ask that you think I should know?" |

### Question templates by interview type

**Profile interview:**
```markdown
1. Background: "Tell me about where you grew up / how you got started."
2. Turning point: "When did you realize [X] was your path?"
3. Challenge: "What was the hardest moment in [period]?"
4. Values: "What principle guides your work?"
5. Future: "What are you working on next?"
```

**Investigative interview:**
```markdown
1. Establish rapport: Non-threatening background questions first
2. Timeline: "Walk me through [event] from the beginning."
3. Details: "Who else was there? What did you see/hear?"
4. Documentation: "Do you have any records of this?"
5. Corroboration: "Who else can confirm this?"
6. Response: "What did [other party] say when you raised this?"
```

**Expert/explainer interview:**
```markdown
1. Credentials: "What's your expertise in this area?"
2. Plain language: "Explain [concept] as if I'm not a specialist."
3. Context: "How common/unusual is [situation]?"
4. Significance: "Why does this matter?"
5. Sources: "Where can I learn more? Who else should I talk to?"
```

**Victim/sensitive interview:**
```markdown
1. Control: "Take your time. You can stop at any point."
2. Open: "Tell me what you're comfortable sharing."
3. Specific: "Can you describe [specific detail]?"
4. Impact: "How has this affected you?"
5. Agency: "What do you want people to understand?"
6. Check-in: "Are you okay to continue?"
```

## Recording and consent

### Recording laws by state type

**One-party consent states:** You can record without telling the other person (but you should tell them anyway for ethical reasons).

**Two-party/all-party consent states:** All parties must consent. These include: California, Connecticut, Florida, Illinois, Maryland, Massachusetts, Michigan, Montana, Nevada, New Hampshire, Pennsylvania, Washington.

**Always do:**
- State clearly at the start: "I'm recording this interview. Is that okay?"
- Get affirmative consent on the recording itself
- Note the consent in your notes

### Consent template

```markdown
## Recording consent

Date: [date]
Interviewer: [your name]
Subject: [their name]
Medium: [phone/video/in-person]

[At start of recording:]
"This is [your name] with [publication], interviewing [their name] on [date].
I'm recording this conversation. Do I have your permission to record?"

[Their response: yes/no]

"And you understand this may be used for publication?"

[Their response: yes/no]
```

## Attribution guidelines

### On the record (default)
- Everything can be published with full name and title
- This is the standard expectation unless otherwise agreed

### On background
- Information can be used, but source not identified by name
- Agree on description: "a senior official," "someone familiar with the matter"
- Confirm exact wording before interview ends

### Deep background
- Information can guide reporting but cannot be attributed at all
- Verify independently before publishing
- Rarely appropriate—push for at least background

### Off the record
- Information is for your knowledge only
- Cannot be published or used to seek confirmation elsewhere
- Agree to this BEFORE they share information, not after
- If they say something on the record then try to take it off, you can refuse

### Clarifying attribution

```markdown
Before starting:
"Just to be clear on attribution—are we on the record?"

If they request otherwise:
"I'd prefer on the record. What concerns you about that?"

If they insist:
"Okay, we'll go on background. What description can I use?"

Document it:
"So I can refer to you as [agreed description]—is that right?"
```

## Interview logistics

### Scheduling template

```markdown
## Interview request

To: [source name]
Subject: Interview request - [topic] - [publication]

[Name],

I'm a [title] at [publication] working on a story about [brief, honest description].

I'd like to speak with you because [why they're relevant]. The interview would take approximately [realistic time estimate].

Are you available [specific days/times]? I can do phone, video, or in-person—whatever works best for you.

Please let me know if you have questions about the story.

[Your name]
[Contact info]
```

### Pre-interview checklist

```markdown
## Day-of checklist

### Equipment
- [ ] Primary recorder charged/working
- [ ] Backup recorder ready
- [ ] Notebook and pens
- [ ] Printed questions/documents
- [ ] Business cards

### Logistics
- [ ] Location confirmed
- [ ] Contact's phone number for day-of
- [ ] Tested video/phone connection
- [ ] Quiet space secured

### Preparation
- [ ] Questions reviewed and prioritized
- [ ] Documents to reference ready
- [ ] Timeline of facts clear in mind
- [ ] Backup questions if interview goes short
```

## During the interview

### Opening
- Small talk to build rapport (brief)
- Confirm time available
- State recording and get consent
- Start with easy, open questions

### Active listening
- Let them finish sentences
- Use silence—don't fill every pause
- Take notes even if recording
- Note non-verbal cues separately

### Real-time verification
- Ask for specifics: dates, names, locations
- Request documentation during interview
- Ask "How do you know that?"
- Note inconsistencies for follow-up

### Closing
- "Is there anything I didn't ask that I should have?"
- "Who else should I talk to?"
- "Can I follow up if I have more questions?"
- Thank them for their time

## Follow-up protocols

### Immediate (same day)
- [ ] Back up recording
- [ ] Transcribe key quotes while fresh
- [ ] Note observations not on recording
- [ ] Send thank-you if appropriate

### Within 48 hours
- [ ] Full transcription or detailed notes
- [ ] Fact-check claims against available records
- [ ] Identify gaps requiring follow-up
- [ ] Add source to contacts database

### Before publication
- [ ] Verify quotes are accurate
- [ ] Confirm attribution terms
- [ ] Offer to read back quotes if promised
- [ ] Give chance to respond to characterizations (if newsworthy)

## Difficult situations

### They want to go off the record mid-interview
"Before I agree to that, let me hear what you want to tell me, and then we can discuss how to handle it."

### They refuse to answer
"I understand you can't discuss that. Can you point me to someone who can?"

### They're hostile
Stay calm. Keep questions factual. "I'm just trying to understand what happened."

### They're crying/emotional
Pause. "Take your time. We can stop whenever you need."

### They lie
Don't accuse. Present contradicting evidence: "Documents show [X]. Can you help me understand the discrepancy?"

---

*Good interviews require good preparation. The conversation is the easy part.*
