# CLAUDE.md - [Project name]

> Template for: Publications (newsletters, blogs, magazines, news sites)

## Project overview

[One sentence: What this publication covers and who reads it]

**Publication type:** [Newsletter, blog, magazine, news site]
**Frequency:** [Daily, weekly, monthly]
**Audience:** [Target readership]
**Established:** [When it started]

## Tech stack

**CMS:** [WordPress, Ghost, Substack, custom, etc.]
**Hosting:** [Platform or host]
**Email:** [Mailchimp, ConvertKit, built-in, etc.]
**Analytics:** [GA4, Plausible, etc.]

## Commands

```bash
# Local development
[command to run locally]

# Build/deploy
[command to publish]

# Newsletter send
[how newsletters are sent]

# Content backup
[backup command or process]
```

## Content structure

**Sections:**
- [Section A]: [What it covers]
- [Section B]: [What it covers]
- [Section C]: [What it covers]

**Content types:**
- Articles: [Long-form, short-form specs]
- Newsletters: [Format, length]
- [Other types]: [Specs]

## File structure

```
project-root/
├── content/            # Articles and posts
│   ├── articles/
│   ├── newsletters/
│   └── pages/
├── assets/             # Images, media
├── templates/          # Layout templates
├── styles/             # CSS/design files
└── config/             # Site configuration
```

## Editorial standards

**Voice and tone:**
- [Publication's voice description]
- [Style guide reference]

**Formatting:**
- Headlines: [Sentence case, title case, etc.]
- Bylines: [Format]
- Dates: [Format]
- Images: [Caption style, attribution]

**Quality checklist:**
- [ ] Spell-checked
- [ ] Links verified
- [ ] Images optimized with alt text
- [ ] SEO metadata complete
- [ ] Mobile preview checked

## Workflow

```
[Draft] --> [Edit] --> [Review] --> [Schedule] --> [Publish]
                           │
                           └--> [Revisions] (if needed)
```

## SEO and distribution

- **SEO approach:** [Keywords, meta, structured data]
- **Social sharing:** [Platforms, posting schedule]
- **RSS:** [Feed location]
- **Syndication:** [If applicable]

## Subscriber management

- [How subscriptions work]
- [Segmentation approach]
- [Unsubscribe handling]
- [GDPR/privacy compliance]

## Things to avoid

- Don't publish without editorial review
- Avoid breaking existing URLs
- Don't change published content without correction notes
- Never remove subscriber data improperly

---

*Update as editorial policies or tech stack evolves.*
