# CLAUDE.md - [Project name]

> Template for: Research projects (investigations, data journalism, academic)

## Project overview

[One sentence: What question this research answers]

**Research type:** [Investigative, data analysis, academic, etc.]
**Timeline:** [Start date - expected completion]
**Status:** [Planning, data collection, analysis, writing, published]
**Team:** [Who is working on this]

## Research question

[The central question or hypothesis being investigated]

**Sub-questions:**
1. [Sub-question A]
2. [Sub-question B]
3. [Sub-question C]

## Tech stack

**Analysis:** [Python, R, SQL, etc.]
**Visualization:** [D3, Matplotlib, Flourish, etc.]
**Data storage:** [CSV, SQLite, PostgreSQL, etc.]
**Collaboration:** [Git, Google Docs, etc.]

## Commands

```bash
# Run analysis
[command to run main analysis]

# Generate visualizations
[command to create charts/graphics]

# Export findings
[command to export results]

# Run validation checks
[command to verify data integrity]
```

## Data sources

**Primary sources:**
| Source | Type | Access | Status |
|--------|------|--------|--------|
| [Source A] | [FOIA, API, etc.] | [Public, restricted] | [Obtained, pending] |
| [Source B] | | | |

**Data lineage:**
- Original source → Cleaned data → Analysis → Findings

## File structure

```
project-root/
├── data/
│   ├── raw/            # Original, unmodified data
│   ├── processed/      # Cleaned data
│   └── outputs/        # Analysis results
├── analysis/           # Analysis scripts
├── notebooks/          # Jupyter/R notebooks
├── docs/               # Documentation, methodology
├── visuals/            # Charts, graphics
└── drafts/             # Story drafts
```

## Methodology

**Data collection:**
- [How data was obtained]
- [Sample size and selection]

**Analysis approach:**
- [Statistical methods]
- [Tools and techniques]

**Validation:**
- [How findings were verified]
- [Expert review if applicable]

## Source log

| Date | Source | Contact | Notes |
|------|--------|---------|-------|
| [Date] | [Source name] | [Person/method] | [What was obtained] |

## Key findings

1. [Finding A]: [brief description]
2. [Finding B]: [brief description]
3. [Finding C]: [brief description]

## Ethical considerations

- [IRB approval if applicable]
- [Anonymization requirements]
- [Informed consent status]
- [Potential harms considered]

## Publication plan

- **Target outlet:** [Publication name]
- **Format:** [Article, interactive, series]
- **Embargo:** [If applicable]
- **Data release:** [What will be published]

## Things to avoid

- Don't modify raw data files
- Avoid cherry-picking data
- Don't publish without methodology documentation
- Never reveal confidential sources

---

*Update status and findings as research progresses.*
