# Lessons learned - [Tool name]

> Template for: Editorial, journalism & newsroom tools

## Project summary
[What does this tool do? Who uses it? What editorial workflow does it support?]

## User overview
- **Primary users:** [reporters, editors, producers, etc.]
- **User count:** [number]
- **Usage frequency:** [daily, weekly, per-story]

## What worked

### Workflow wins
- [Step that got faster]
- [Error that got eliminated]
- [Collaboration that improved]

### Adoption wins
- [Feature that drove adoption]
- [Training approach that worked]
- [Champion who helped spread use]

### Integration wins
- [System it connected well with]
- [Data it surfaced usefully]
- [Export/output that fit workflow]

## What didn't work

### Workflow failures
- [Step that got harder]
- [New error introduced]
- [Workaround users invented]

### Adoption blockers
- [Why some users resisted]
- [Training gap]
- [Competing tool preference]

### Integration problems
- [System it didn't connect with]
- [Data format mismatch]
- [Authentication friction]

## Key insights

### The real problem
[What journalists actually needed vs what you built]

### Newsroom culture lessons
- [How deadline pressure affected adoption]
- [How existing habits shaped usage]
- [What editors vs reporters needed differently]

### Trust lessons
- [What made users trust the tool]
- [What made users distrust it]
- [Accuracy/reliability requirements]

## User feedback themes

### Loved
- [Quote or paraphrase]
- [Quote or paraphrase]

### Hated
- [Quote or paraphrase]
- [Quote or paraphrase]

### Requested
- [Feature request pattern]
- [Feature request pattern]

## Recommendations for future work

### If continuing this tool
- [Priority fix based on feedback]
- [Feature to add]

### If building similar tools
- [Design principle to follow]
- [Mistake to avoid]

## Artifacts worth keeping

| Component | Why |
|-----------|-----|
| [UI patterns] | [Tested with real journalists] |
| [Data models] | [Reflects editorial concepts correctly] |

## Stakeholders
- **Product owner:** [name/role]
- **Power users:** [names/roles]
- **IT/Support:** [contact]

## Metrics
- Daily active users: [number]
- Key action completion rate: [%]
- Time saved per task: [estimate]
- Error rate before/after: [comparison]

---

*Newsroom tools must evolve with the newsroom. Update as needs change.*
