# Lessons learned - [Event name]

> Template for: Conference, summit, and event websites

## Event overview
- **Event name:** [name]
- **Date(s):** [dates]
- **Location:** [venue/virtual]
- **Expected attendance:** [number]
- **Website launch:** [date] | **Event date:** [date]

## What worked

### Content wins
- [Messaging that resonated]
- [Speaker/session presentation that drove interest]
- [Call-to-action that converted]

### Design wins
- [Visual identity choice]
- [Mobile experience]
- [Accessibility feature]

### Technical wins
- [Registration integration]
- [Schedule display approach]
- [Performance optimization]

### Promotion wins
- [Channel that drove traffic]
- [Partnership that expanded reach]
- [Timing that worked]

## What didn't work

### Content failures
- [Information people couldn't find]
- [Confusion caused by messaging]
- [Missing content that caused support requests]

### Design issues
- [Element that confused users]
- [Branding inconsistency]
- [Responsive breakpoint problem]

### Technical problems
- [Registration friction]
- [Load time issue]
- [Integration failure]

### Promotion misses
- [Channel that underperformed]
- [Timing mistake]
- [Audience not reached]

## Key insights

### The real problem
[What attendees actually needed from the site vs what you built]

### Timeline lessons
- [What should have been ready earlier]
- [What could have waited]
- [Crunch points to avoid]

### Stakeholder lessons
- [Whose input was essential]
- [Approval bottlenecks]
- [Communication gaps]

## Content checklist for next time

### Must-have at launch
- [ ] Date, time, location
- [ ] Registration link/form
- [ ] Basic schedule/agenda
- [ ] Speaker highlights
- [ ] Venue/access info
- [ ] Contact information

### Add before event
- [ ] Full schedule with sessions
- [ ] Speaker bios and photos
- [ ] Sponsor recognition
- [ ] FAQ
- [ ] Accessibility info
- [ ] Code of conduct

### Post-event
- [ ] Recordings/slides
- [ ] Photo gallery
- [ ] Thank you messaging
- [ ] Save the date for next year

## Recommendations for future events

### If running this event again
- [What to keep]
- [What to change]

### For similar events
- [Transferable patterns]
- [Pitfalls to avoid]

## Artifacts worth keeping

| Component | Why |
|-----------|-----|
| [Design system/brand assets] | [Reusable for future years] |
| [Registration flow] | [Proven conversion] |
| [Email templates] | [Tested messaging] |

## Stakeholder contacts
- [Event organizer]
- [Venue contact]
- [Sponsor contacts]
- [Speaker coordinator]

## Analytics summary
- Total unique visitors: [number]
- Registration conversion: [%]
- Top traffic sources: [list]
- Peak traffic day: [date]

---

*Update after the event with attendee feedback and final metrics.*
