# Lessons learned - [Publication name]

> Template for: Newsletters, blogs, ongoing publications

## Publication overview
- **Name:** [publication name]
- **Format:** [newsletter, blog, podcast, etc.]
- **Frequency:** [daily, weekly, etc.]
- **Audience:** [who reads it]
- **Issues published:** [count]
- **Subscribers/readers:** [count]

## What worked

### Content wins
- [Topic/format that resonated]
- [Voice/tone that connected]
- [Series or feature that performed]

### Growth wins
- [Channel that drove subscriptions]
- [Referral pattern that worked]
- [Partnership that expanded reach]

### Production wins
- [Workflow that made publishing sustainable]
- [Tool that saved time]
- [Template that maintained consistency]

### Monetization wins (if applicable)
- [Revenue stream that worked]
- [Sponsor relationship that fit]
- [Premium offering that converted]

## What didn't work

### Content failures
- [Topic that flopped]
- [Format that didn't land]
- [Experiment that confused readers]

### Growth problems
- [Channel that didn't convert]
- [Churn pattern observed]
- [Audience mismatch]

### Production pain
- [Bottleneck in workflow]
- [Burnout factor]
- [Quality/consistency tradeoff]

### Monetization misses (if applicable)
- [Revenue attempt that failed]
- [Sponsor mismatch]
- [Pricing mistake]

## Key insights

### The real value
[What readers actually came for vs what you thought you were providing]

### Voice & identity lessons
- [What made the publication distinctive]
- [What felt inauthentic]
- [Evolution of voice over time]

### Sustainability lessons
- [What made it maintainable]
- [What led to burnout]
- [Right frequency in retrospect]

## Audience insights
- **Who they are:** [demographics, psychographics]
- **Why they subscribe:** [value proposition]
- **What they share:** [most viral content]
- **What they reply to:** [engagement triggers]

## Top performing issues/posts

| Title | Date | Why it worked |
|-------|------|---------------|
| [title] | [date] | [reason] |
| [title] | [date] | [reason] |

## Recommendations for future work

### If continuing this publication
- [Content to do more of]
- [Workflow to fix]
- [Growth channel to invest in]

### If starting a similar publication
- [What to replicate]
- [What to skip]
- [Minimum viable version]

## Artifacts worth keeping

| Component | Why |
|-----------|-----|
| [Style guide] | [Defines voice] |
| [Templates] | [Speeds production] |
| [Subscriber data] | [Audience insights] |

## Platform & tools
- **Publishing platform:** [Substack, Ghost, WordPress, etc.]
- **Email service:** [if different]
- **Analytics:** [what you track]
- **Writing tools:** [what you use]

## Metrics
- Open rate: [%]
- Click rate: [%]
- Growth rate: [%/month]
- Churn rate: [%/month]

---

*Publications evolve with their audience. Update as you learn what resonates.*
