# Lessons learned - [Project name]

> Template for: Research, investigation & analysis projects

## Project summary
[What question were you trying to answer? What was the investigation about?]

## Research overview
- **Duration:** [timeframe]
- **Team:** [who worked on it]
- **Output:** [article, report, database, tool]
- **Status:** [published, ongoing, abandoned]

## What worked

### Source wins
- [Source type that proved valuable]
- [Access obtained that was crucial]
- [FOIA/records request that succeeded]

### Method wins
- [Analysis technique that revealed insights]
- [Tool that accelerated work]
- [Collaboration approach that helped]

### Verification wins
- [Fact-check process that caught errors]
- [Corroboration method that worked]
- [Expert consultation that added credibility]

## What didn't work

### Source failures
- [Source that dried up]
- [Access denied]
- [Records request that failed/delayed]

### Method problems
- [Analysis that led nowhere]
- [Tool that wasted time]
- [Assumption that proved wrong]

### Verification gaps
- [Fact we couldn't verify]
- [Conflicting information unresolved]
- [Expert who wouldn't go on record]

## Key insights

### The real story
[What the investigation was actually about vs what you thought initially]

### Data lessons
- [What data existed vs what you expected]
- [Quality issues encountered]
- [Gaps that couldn't be filled]

### Human source lessons
- [How to approach sources for this topic]
- [What motivated sources to talk]
- [What scared sources off]

## Findings summary
- [Key finding 1]
- [Key finding 2]
- [Key finding 3]

## What we couldn't prove
- [Hypothesis that remained unconfirmed]
- [Question that stayed unanswered]

## Ethical considerations
- [Privacy decision made]
- [Harm consideration]
- [Source protection measure]

## Recommendations for future work

### If continuing this investigation
- [Lead to pursue]
- [Source to revisit]
- [Data to request]

### For similar investigations
- [Approach to replicate]
- [Mistake to avoid]
- [Tool to use]

## Artifacts worth keeping

| Component | Why |
|-----------|-----|
| [Data collection scripts] | [Could be reused for follow-up] |
| [Source database] | [Contacts for future stories] |
| [Analysis notebooks] | [Methodology documentation] |

## Source log
*(Keep detailed, consider security)*
- [Source type, not name if sensitive]
- [How contacted, response]

## Documents obtained
- [Document type, source, date obtained]
- [Storage location]

## Timeline of key events
- [Date]: [Event in the story]
- [Date]: [Event in the story]

---

*Investigations may be revisited. Keep notes thorough.*
