---
name: story-pitch
description: Craft effective story pitches for different publication types and formats. Use when pitching to editors, preparing query letters, or developing story angles. Includes templates for daily news, features, investigations, op-eds, and freelance queries.
---

# Story pitch guide

Good stories die in bad pitches. This skill covers pitch structure, angle development, and outlet-specific formatting.

## When to use

- Pitching stories to editors (internal or external)
- Developing freelance query letters
- Refining story angles before reporting
- Competing for assignment in a newsroom
- Proposal writing for grants or fellowships

## The pitch fundamentals

### What every pitch needs

1. **The hook**: Why should anyone care? Why now?
2. **The story**: What will you show/reveal/explain?
3. **The evidence**: What do you have? What can you get?
4. **The access**: Who will you talk to? What will you see?
5. **The ask**: What do you need (time, budget, resources)?

### The "so what" test

Before pitching, answer:
- **Why this story?** (significance)
- **Why now?** (timeliness/news hook)
- **Why you?** (access, expertise, angle)
- **Why this outlet?** (audience fit)

If you can't answer all four, you're not ready to pitch.

## Pitch templates by type

### Daily news pitch

For quick-turn stories to assignment editors.

```markdown
**Slug:** [2-3 word identifier]
**Pitch:** [One sentence: What's the news?]
**Why now:** [What makes this timely?]
**Sources:** [Who you'll talk to]
**Timeline:** [When you can file]
**Format:** [Length, multimedia]

Example:
**Slug:** Council-Budget-Vote
**Pitch:** City council votes tonight on controversial police budget increase.
**Why now:** Final vote after months of debate, protests expected.
**Sources:** Council president, protest organizers, police union rep.
**Timeline:** File by 10pm for morning.
**Format:** 600 words + photos from hearing.
```

### Feature pitch

For longer-form stories with more development time.

```markdown
## [Working title]

**The story in one sentence:**
[What is this story about?]

**The hook:**
[Why should readers care? What's the emotional/intellectual entry point?]

**What's new:**
[What do you know/have that hasn't been told?]

**The shape:**
[How will you tell it? Narrative structure, key scenes, characters]

**Sources and access:**
[Who will you interview? What will you witness? Documents?]

**Visuals:**
[Photo opportunities, graphics, multimedia]

**Timeline and resources:**
[How long to report? Write? What do you need?]

**Why me:**
[Your connection to story, relevant expertise, access]

Example:

## The last ferry captain

**The story in one sentence:**
After 47 years, the last original captain of the Staten Island Ferry is retiring—and taking decades of institutional knowledge with him.

**The hook:**
8 million New Yorkers depend on this ferry. Most have never met the people who run it. Captain Mike Carbone has seen mayors come and go, survived 9/11 from the water, and trained every current captain. His retirement is the end of an era.

**What's new:**
No one has profiled the ferry crews since the 2003 accident. Carbone has agreed to a ride-along on his final week. He's kept a journal since 1977.

**The shape:**
Narrative profile. Open with his final departure. Flash back through career highlights. Include voices from crew, family, passengers he's befriended over decades.

**Sources and access:**
- Carbone (confirmed, ride-along approved)
- NYC DOT ferry division chief
- Other captains he's trained
- Regular commuters
- His family

**Visuals:**
Photographer on ride-along. Harbor shots at dawn. Carbone's home with memorabilia. Archive photos from his collection.

**Timeline and resources:**
2 weeks reporting, 1 week writing. Need photographer availability for 3 early mornings.

**Why me:**
I grew up taking this ferry and have always wanted to tell this story. I've already built rapport with Carbone through initial conversations.
```

### Investigation pitch

For accountability journalism requiring significant resources.

```markdown
## [Working title]

**The thesis:**
[What we can prove / what we suspect]

**Why it matters:**
[Impact: Who is harmed? How much money? How many people?]

**What we have:**
[Documents, sources, data already obtained]

**What we need:**
[Additional reporting required]

**Key sources:**
[Who will talk? On/off record? Whistleblowers?]

**Documentary evidence:**
[FOIA requests needed? Court records? Financial filings?]

**Legal considerations:**
[Defamation risk? Source protection needs?]

**Competitive risk:**
[Is anyone else on this? Why now?]

**Timeline:**
[Realistic assessment of time to report, write, edit, legal review]

**Resources needed:**
[FOIA costs, travel, data analysis, graphics, multimedia]

**Publication plan:**
[Single story? Series? Rolling publication?]

Example:

## State contracts going to insiders

**The thesis:**
At least $50 million in state construction contracts over five years went to companies with personal ties to procurement officials, circumventing competitive bidding.

**Why it matters:**
Taxpayers are overpaying for public projects. At least three bridges have needed early repairs after work by connected contractors.

**What we have:**
- State contract database (scraped, analyzed)
- Corporate filings showing ownership connections
- Two former procurement employees willing to talk (one on record)
- Email chain showing official steering business to friend

**What we need:**
- Additional FOIA for internal communications
- More contractors willing to describe losing bids unfairly
- Engineering review of the bridge repair patterns
- Response from officials named

**Key sources:**
- Whistleblower A (on record, documented complaint)
- Whistleblower B (background only, fears retaliation)
- Contractor who lost bids (on record)
- Engineering expert for bridge assessment
- Officials (will request comment before publication)

**Documentary evidence:**
- Contract awards (public, obtained)
- Corporate filings (public, obtained)
- Internal emails (FOIA pending)
- Inspection reports (FOIA pending)

**Legal considerations:**
All claims will be documented. We'll seek comment from everyone named. Standard defamation review needed.

**Competitive risk:**
Local TV did a segment on one bridge last year but didn't connect the pattern. This is a deeper investigation.

**Timeline:**
8-10 weeks total. 6 weeks additional reporting, 2 weeks writing/editing, 2 weeks legal/response period.

**Resources needed:**
$2,000 FOIA costs, data analysis support, one reporting trip to state capital.

**Publication plan:**
Main story (3,000 words) + database for readers to search contracts + methodology box.
```

### Op-ed pitch

For opinion/commentary pieces.

```markdown
Subject: Op-ed submission: [Headline]

Dear [Editor name],

[One paragraph: What's your argument? Why now?]

[One paragraph: Why are you qualified to make this argument?]

[One paragraph: Why is this right for your publication's audience?]

The piece is [word count] words and is exclusive to [publication].

[Your name]
[Credentials/bio]
[Contact info]

---

Example:

Subject: Op-ed submission: School board's DEI cuts will hurt all students

Dear Opinion Editor,

When the Westfield school board votes Tuesday to eliminate diversity coordinators, they won't just hurt minority students—they'll deprive every student of the skills employers demand. I've spent 20 years in HR at Fortune 500 companies, and I can tell you: businesses want graduates who can work across difference. This decision makes our kids less competitive.

As the former Chief People Officer at [Company] and a Westfield parent, I've seen both sides of this issue. I'm not an activist; I'm a business leader who knows what the job market requires.

Your editorial page has covered school budget debates extensively. Your readers—many of them parents in our district—need to hear from someone who can translate business needs into educational priorities.

The piece is 750 words and is exclusive to [Publication].

Jane Smith
Former CPO, [Company]
Westfield School District parent
jane@email.com / 555-0123
```

### Freelance query letter

For pitching to publications you don't work for.

```markdown
Subject: Pitch: [Compelling headline]

Dear [Editor name],

[Opening hook—the most compelling detail or question from your story]

[What the story is, who it's about, what you'll show]

[Why now—the news hook or timely angle]

[What you have—sources confirmed, access secured, documents obtained]

[Why this publication—how it fits their coverage, audience]

[Why you—relevant clips, expertise, access]

I estimate [word count] words and can deliver in [timeframe].

Thank you for your consideration.

[Your name]
[Brief bio]
[Links to 2-3 relevant clips]
[Contact info]

---

Example:

Subject: Pitch: The nurse who tracks fake diplomas

Dear [Editor],

Maria Chen has caught 47 nurses with fake degrees in three years. None of them through background checks—through a spreadsheet she maintains in her free time.

Chen, a nursing supervisor at a rural Oklahoma hospital, started her database after discovering a colleague had purchased credentials from a diploma mill. State nursing boards, she found, rarely verify foreign credentials thoroughly. Her volunteer work has exposed a patient safety gap that regulators have ignored.

Her story comes as Oklahoma debates licensure reform this session—a bill she's testified for and the hospital lobby has opposed. The vote is in six weeks.

I've interviewed Chen twice, reviewed her database and documentation, and spoken with three of the fraudulent nurses she identified (two on background). The state nursing board has agreed to comment.

This fits [Publication]'s healthcare accountability coverage. Your recent piece on physician oversight touched on similar regulatory gaps.

I've covered healthcare regulation for [outlets] and have sources at several state nursing boards. My recent piece on travel nurse agencies for [outlet] is attached.

I estimate 2,500 words and can deliver in four weeks.

Thank you for your consideration.

[Name]
Freelance health reporter
[Clip links]
[Contact]
```

## Developing the angle

### Finding the hook

Ask yourself:
- What's the **conflict**? (Who's fighting whom?)
- What's the **tension**? (What's at stake?)
- What's the **surprise**? (What will readers not expect?)
- What's the **emotion**? (What will readers feel?)
- What's the **question**? (What don't we know?)

### The "dinner table" test

Can you explain this story in one sentence to someone at dinner?

**Too vague:** "It's about problems with the foster care system."

**Too inside baseball:** "It's about how HHS regulations from 2018 created incentive misalignment in Title IV-E funding."

**Just right:** "Kids in foster care are being moved to different homes so often that some have attended 10 schools in one year—and no one's tracking the damage."

### Angle versus topic

| Topic | Angle |
|-------|-------|
| Homelessness | The family that's been on the housing waitlist for 3 years |
| Climate change | The town that's already moving because of rising seas |
| Healthcare costs | The insulin price that tripled while the patent was extended |
| Education | The teacher who's spent $10k of her own money on supplies |

**Topic** is what you're covering. **Angle** is how you're covering it.

## Common pitch mistakes

### The information dump
❌ "There's a lot going on with the school board. They've had budget issues, enrollment decline, a superintendent search, and facilities problems. I want to cover all of it."

✅ "The superintendent search is down to two finalists with opposite visions for the district. I'll profile both and explain what's at stake."

### The missing news hook
❌ "Homelessness is a growing problem in our city."

✅ "The city's eviction filings hit a five-year high last month. Here's what's driving it."

### The vague access
❌ "I'll talk to homeless people and officials."

✅ "I've been following one family through the shelter system for two months. The housing director has agreed to an interview."

### The no-stakes pitch
❌ "The museum is having an exhibit on local history."

✅ "The museum's new exhibit includes artifacts a local family claims were stolen during redevelopment. The family wants them back."

## After the pitch

### If accepted
- Clarify deadline, length, edit process
- Confirm kill fee (for freelance)
- Get editor's preferred contact method
- Ask about style guide, multimedia needs

### If rejected
- Ask for feedback (briefly, politely)
- Ask if there's a different angle that would work
- Keep relationship warm for future pitches

### If silence
- Follow up once after 1-2 weeks
- If still nothing, you can pitch elsewhere (unless exclusive)
- Don't take it personally—editors are overwhelmed

---

*The pitch sells the story. The story sells itself after that.*
