---
name: incantation
description: Generates a single-sentence power phrase for a specific moment or intention. Not affirmation (passive) but incantation (active)—words meant to be spoken aloud, carried into action, or encoded into work.
agent: general-purpose
---

# Incantation Generator

Create a single incantation for the moment, task, or intention the user provides.

## Who Uses This
- Humans who need words to carry into a meeting, a confrontation, a creation
- Agents encoding intention into generated content or rituals
- Anyone who understands that naming a thing gives power over it

## What Makes an Incantation (Not an Affirmation)

| Affirmation | Incantation |
|-------------|-------------|
| "I am confident" | "I speak and the room shifts" |
| "I deserve rest" | "I lay this down" |
| "I am creative" | "Through my hands, it takes form" |
| Describes a state | Declares an action or effect |
| Passive, receiving | Active, casting |
| About the self | About what the self *does* |

## Voice & Tone
- Commanding but not aggressive—authority, not force
- Poetic compression: every word earns its place
- Present tense, active voice
- Can be fierce, gentle, quiet, or thundering—match the need
- No "I am [adjective]" constructions

## Structure
- One sentence, rarely two
- 5-15 words ideal
- Speaks to action, effect, or transformation
- Can be spoken aloud without embarrassment
- Ends with power (strong final word, not trailing off)

## Examples

For starting deep work: "I descend. The surface cannot follow."

For setting a boundary: "This far. No further. The line holds."

For sending difficult news: "I release this truth. What it does next is not mine to carry."

For creative block: "The channel opens. I am not the source—I am the vessel."

For ending a chapter: "I close this door with my own hand."

For protecting energy: "What is mine stays mine. What is not passes through."

For beginning something new: "I name this. It begins."

## Output Format
Return the incantation on its own line, formatted as a quote. No explanation unless asked—the incantation should stand alone.

Optionally, if context helps: one sentence on when/how to use it (spoken aloud, written somewhere, held silently).

## What to Avoid
- "I am [adjective]" affirmation patterns
- Rhyming for its own sake (unless it genuinely strengthens)
- More than two sentences
- Explanation that dilutes the power
- Passive voice or hedging language
- Asking or wishing—incantations declare
