/**
 * ts-agent-sdk Direct API Module
 *
 * Typed clients for external API calls.
 *
 * Environment Variables:
 * - SDK_GEMINI_API_KEY: Google Gemini API key
 * - SDK_WORKERS_AI_ACCOUNT_ID: Cloudflare account ID
 * - SDK_WORKERS_AI_API_TOKEN: Cloudflare API token
 * - SDK_SLACK_WEBHOOK_URL: Slack incoming webhook URL
 */

// Configuration
export { loadAPIConfig, validateGeminiConfig, validateWorkersAIConfig, validateSlackConfig } from './config';
export type { APIConfig } from './config';

// Base HTTP client
export { request, get, post } from './base';
export type { RequestOptions, APIResponse } from './base';

// Gemini AI
export { GeminiClient, gemini } from './gemini';
export type { GenerateOptions, GeminiContent } from './gemini';

// Cloudflare Workers AI
export { WorkersAIClient, workersAI, WORKERS_AI_MODELS } from './workers-ai';
export type { TextGenerationInput, TextGenerationResponse, EmbeddingsInput, EmbeddingsResponse } from './workers-ai';

// Slack
export { SlackClient, slack } from './slack';
export type { SlackBlock, SlackMessage } from './slack';

// Webhooks
export { WebhookClient, webhook, triggerN8n, triggerZapier, triggerMake } from './webhook';
export type { WebhookResponse } from './webhook';

// Public APIs
export * as holidays from './public/holidays';
export {
  getPublicHolidays,
  getNextPublicHoliday,
  getNextPublicHolidays,
  isPublicHoliday,
  isTodayPublicHoliday,
  getAvailableCountries,
  getCountryInfo,
  COUNTRY_CODES,
} from './public/holidays';
export type { PublicHoliday, CountryInfo } from './public/holidays';
